/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.DataModelInitializedEvent;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.SteppingController;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.ExpandStackEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.MessagesForLaunchVM;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMChildrenUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelImage;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;

public class CudaStackFramesVMNode
extends AbstractDMVMNode
implements IElementLabelProvider,
IElementMementoProvider,
IElementPropertiesProvider {
    public static final String PROP_IS_INCOMPLETE_STACK_MARKER = "is_incomplete_stack_marker";
    private final Map<IRunControl.IExecutionDMContext, Integer> fTemporaryLimits = new HashMap<IRunControl.IExecutionDMContext, Integer>();
    private final IElementLabelProvider fLabelProvider = this.createLabelProvider();

    public CudaStackFramesVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, IStack.IFrameDMContext.class);
    }

    public String toString() {
        return "StackFramesVMNode(" + this.getSession().getId() + ")";
    }

    protected IElementLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider provider = new PropertiesBasedLabelProvider();
        provider.setColumnInfo("ID_COLUMN_NO_COLUMNS", new LabelColumnInfo(new LabelAttribute[]{new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__Incomplete_stack_marker__text_format, new String[]{PROP_IS_INCOMPLETE_STACK_MARKER}){

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                return Boolean.TRUE.equals(properties.get(CudaStackFramesVMNode.PROP_IS_INCOMPLETE_STACK_MARKER));
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__text_format, new String[]{"frame_address", "frame_function", "frame_file", "frame_line", "frame_column", "frame_module"}){

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Integer line = (Integer)properties.get("frame_line");
                String file = (String)properties.get("frame_file");
                String function = (String)properties.get("frame_function");
                return line != null && line >= 0 && file != null && file.length() > 0 && function != null && function.contains(")");
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__add_parens__text_format, new String[]{"frame_address", "frame_function", "frame_file", "frame_line", "frame_column", "frame_module"}){

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                Integer line = (Integer)properties.get("frame_line");
                String file = (String)properties.get("frame_file");
                String function = (String)properties.get("frame_function");
                return line != null && line >= 0 && file != null && file.length() > 0 && (function == null || !function.contains(")"));
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__No_line__text_format, new String[]{"frame_address", "frame_function", "frame_module"}){

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                String function = (String)properties.get("frame_function");
                String module = (String)properties.get("frame_module");
                return function != null && function.length() > 0 && function.contains(")") && module != null && module.length() > 0;
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__No_line__add_parens__text_format, new String[]{"frame_address", "frame_function", "frame_module"}){

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                String function = (String)properties.get("frame_function");
                String module = (String)properties.get("frame_module");
                return function != null && function.length() > 0 && !function.contains(")") && module != null && module.length() > 0;
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__No_function__text_format, new String[]{"frame_address", "frame_module"}){

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                String module = (String)properties.get("frame_module");
                return module != null && module.length() > 0;
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__No_module__text_format, new String[]{"frame_address", "frame_function"}){

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                String function = (String)properties.get("frame_function");
                return function != null && function.length() > 0 && function.contains(")");
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__No_module__add_parens__text_format, new String[]{"frame_address", "frame_function"}){

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                String function = (String)properties.get("frame_function");
                return function != null && function.length() > 0 && !function.contains(")");
            }
        }, new LabelText(MessagesForLaunchVM.StackFramesVMNode_No_columns__Address_only__text_format, new String[]{"frame_address"}), new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_STACKFRAME_RUNNING")){
            {
                this.setPropertyNames(new String[]{"is_suspended"});
            }

            public boolean isEnabled(IStatus status, Map<String, Object> properties) {
                return Boolean.FALSE.equals(properties.get("is_suspended"));
            }
        }, new LabelImage(DebugUITools.getImageDescriptor((String)"IMG_OBJS_STACKFRAME"))}));
        return provider;
    }

    protected void baseUpdateHasElementsInSessionThread(IHasChildrenUpdate update) {
        IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        IRunControl.IExecutionDMContext execCtx = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (runControl == null || execCtx == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        update.setHasChilren(runControl.isSuspended(execCtx) || runControl.isStepping(execCtx));
        update.done();
    }

    protected void baseUpdateElementCountInSessionThread(final IChildrenCountUpdate update) {
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (stackService == null || execDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        final int stackFrameLimit = this.getStackFrameLimit(execDmc);
        stackService.getStackDepth((IDMContext)execDmc, stackFrameLimit == Integer.MAX_VALUE ? 0 : stackFrameLimit + 1, (DataRequestMonitor)new ViewerDataRequestMonitor<Integer>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            public void handleCompleted() {
                if (!this.isSuccess()) {
                    CudaStackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                    return;
                }
                int stackDepth = (Integer)this.getData();
                if (stackFrameLimit < stackDepth) {
                    stackDepth = stackFrameLimit + 1;
                }
                update.setChildCount(stackDepth);
                update.done();
            }
        });
    }

    protected void baseUpdateElementsInSessionThread(final IChildrenUpdate update) {
        IStack stackService = (IStack)this.getServicesTracker().getService(IStack.class);
        final IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (stackService == null || execDmc == null) {
            this.handleFailedUpdate((IViewerUpdate)update);
            return;
        }
        final int stackFrameLimit = this.getStackFrameLimit(execDmc);
        final int startIndex = update.getOffset();
        if (startIndex == 0 && update.getLength() == 1) {
            stackService.getTopFrame((IDMContext)execDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IStack.IFrameDMContext>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        CudaStackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    update.setChild((Object)CudaStackFramesVMNode.this.createVMContext((IDMContext)this.getData()), 0);
                    update.done();
                }
            });
        } else if (startIndex >= 0 && update.getLength() > 0) {
            int endIndex = startIndex + update.getLength() - 1;
            if (startIndex < stackFrameLimit && endIndex >= stackFrameLimit) {
                endIndex = stackFrameLimit - 1;
            }
            stackService.getFrames((IDMContext)execDmc, startIndex, endIndex, (DataRequestMonitor)new ViewerDataRequestMonitor<IStack.IFrameDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        CudaStackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    IStack.IFrameDMContext[] frames = (IStack.IFrameDMContext[])this.getData();
                    CudaStackFramesVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])frames, startIndex);
                    if (startIndex + update.getLength() > stackFrameLimit) {
                        update.setChild((Object)new IncompleteStackVMContext(execDmc, stackFrameLimit), stackFrameLimit);
                    }
                    update.done();
                }
            });
        } else {
            stackService.getFrames((IDMContext)execDmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IStack.IFrameDMContext[]>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                public void handleCompleted() {
                    if (!this.isSuccess()) {
                        CudaStackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        return;
                    }
                    IStack.IFrameDMContext[] frames = (IStack.IFrameDMContext[])this.getData();
                    if (frames.length > stackFrameLimit) {
                        IStack.IFrameDMContext[] tmpFrames = new IStack.IFrameDMContext[stackFrameLimit];
                        System.arraycopy(frames, 0, tmpFrames, 0, stackFrameLimit);
                        frames = tmpFrames;
                        update.setChild((Object)new IncompleteStackVMContext(execDmc, stackFrameLimit), stackFrameLimit);
                    }
                    CudaStackFramesVMNode.this.fillUpdateWithVMCs(update, (IDMContext[])frames);
                    update.done();
                }
            });
        }
    }

    public void update(ILabelUpdate[] updates) {
        this.fLabelProvider.update(updates);
    }

    /*
     * Unable to fully structure code
     */
    public void update(final IPropertiesUpdate[] updates) {
        block3: {
            try {
                this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        CudaStackFramesVMNode.this.updatePropertiesInSessionThread(updates);
                    }
                });
                break block3;
            }
            catch (RejectedExecutionException v0) {
                var5_2 = updates;
                var4_3 = updates.length;
                var3_4 = 0;
                ** while (var3_4 < var4_3)
            }
lbl-1000:
            // 1 sources

            {
                update = var5_2[var3_4];
                this.handleFailedUpdate((IViewerUpdate)update);
                ++var3_4;
                continue;
            }
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updatePropertiesInSessionThread(IPropertiesUpdate[] updates) {
        IStack service = (IStack)this.getServicesTracker().getService(IStack.class);
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            final IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            if (service == null) {
                this.handleFailedUpdate((IViewerUpdate)update);
            } else if (update.getElement() instanceof IncompleteStackVMContext) {
                update.setProperty(PROP_IS_INCOMPLETE_STACK_MARKER, (Object)Boolean.TRUE);
                update.done();
            } else {
                IStack.IFrameDMContext dmc = (IStack.IFrameDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IStack.IFrameDMContext.class);
                if (dmc == null) {
                    this.handleFailedUpdate((IViewerUpdate)update);
                } else {
                    IRunControl runControlService = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
                    IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IRunControl.IExecutionDMContext.class);
                    if (execDmc != null && runControlService != null) {
                        update.setProperty("is_suspended", (Object)runControlService.isSuspended(execDmc));
                        update.setProperty("is_stepping", (Object)runControlService.isStepping(execDmc));
                    } else {
                        update.setStatus(DsfUIPlugin.newErrorStatus((int)10002, (String)"Invalid context or service not available", null));
                    }
                    service.getFrameData(dmc, (DataRequestMonitor)new ViewerDataRequestMonitor<IStack.IFrameDMData>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

                        protected void handleSuccess() {
                            CudaStackFramesVMNode.this.fillFrameDataProperties(update, (IStack.IFrameDMData)this.getData());
                            update.done();
                        }
                    });
                }
            }
            ++n2;
        }
    }

    protected void fillFrameDataProperties(IPropertiesUpdate update, IStack.IFrameDMData data) {
        Object showFullPathPreference;
        String fileName;
        IAddress address = data.getAddress();
        if (address != null) {
            update.setProperty("frame_address", (Object)("0x" + address.toString(16)));
        }
        if ((fileName = data.getFile()) != null && (showFullPathPreference = this.getVMProvider().getPresentationContext().getProperty("org.eclipse.debug.ui.DebugView.org.eclipse.cdt.debug.ui.cDebug.show_full_paths")) instanceof Boolean && !((Boolean)showFullPathPreference).booleanValue()) {
            fileName = new Path(fileName).lastSegment();
        }
        update.setProperty("frame_file", (Object)fileName);
        update.setProperty("frame_function", (Object)data.getFunction());
        update.setProperty("frame_line", (Object)data.getLine());
        update.setProperty("frame_column", (Object)data.getColumn());
        update.setProperty("frame_module", (Object)data.getModule());
    }

    protected void fillColumnLabel(IStack.IFrameDMContext dmContext, IStack.IFrameDMData dmData, String columnId, int idx, ILabelUpdate update) {
        boolean hasFileName;
        if (idx != 0) {
            return;
        }
        IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), IRunControl.IExecutionDMContext.class);
        if (execDmc == null) {
            return;
        }
        IRunControl runControlService = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        SteppingController stepQueueMgr = (SteppingController)execDmc.getAdapter(SteppingController.class);
        if (runControlService == null || stepQueueMgr == null) {
            return;
        }
        String imageKey = null;
        imageKey = runControlService.isSuspended(execDmc) || runControlService.isStepping(execDmc) && !stepQueueMgr.isSteppingTimedOut(execDmc) ? "IMG_OBJS_STACKFRAME" : "IMG_OBJS_STACKFRAME_RUNNING";
        update.setImageDescriptor(DebugUITools.getImageDescriptor((String)imageKey), 0);
        StringBuilder label = new StringBuilder();
        if (dmData.getFunction() != null && dmData.getFunction().length() != 0) {
            label.append(" ");
            label.append(dmData.getFunction());
            label.append("()");
        }
        boolean bl = hasFileName = dmData.getFile() != null && dmData.getFile().length() != 0;
        if (hasFileName) {
            label.append(" at ");
            label.append(dmData.getFile());
        }
        if (dmData.getLine() >= 0) {
            label.append(":");
            label.append(dmData.getLine());
            label.append(" ");
        }
        if (!hasFileName && dmData.getModule() != null && dmData.getModule().length() != 0) {
            label.append(" ");
            label.append(dmData.getModule());
            label.append(" ");
        }
        if (dmData.getAddress() != null) {
            label.append("- 0x" + dmData.getAddress().toString(16));
        }
        update.setLabel(label.toString(), 0);
    }

    public int getDeltaFlags(Object e) {
        if (e instanceof FullStackRefreshEvent) {
            return 1024;
        }
        if (e instanceof IRunControl.ISuspendedDMEvent) {
            return 1024;
        }
        if (e instanceof SteppingController.SteppingTimedOutEvent) {
            return 1024;
        }
        if (e instanceof ModelProxyInstalledEvent || e instanceof DataModelInitializedEvent) {
            return 0x200000;
        }
        if (e instanceof ExpandStackEvent) {
            return 1024;
        }
        if (e instanceof IRunControl.IExitedDMEvent) {
            this.resetStackFrameLimit((IRunControl.IExecutionDMContext)((IRunControl.IExitedDMEvent)e).getDMContext());
            return 0;
        }
        if (e instanceof PropertyChangeEvent) {
            String property = ((PropertyChangeEvent)e).getProperty();
            if ("stackFrameLimitEnable".equals(property) || "stackFrameLimit".equals(property)) {
                return 1024;
            }
            if ("org.eclipse.debug.ui.DebugView.org.eclipse.cdt.debug.ui.cDebug.show_full_paths".equals(property)) {
                return 2048;
            }
        }
        return 0;
    }

    public void buildDelta(Object e, VMDelta parent, int nodeOffset, RequestMonitor rm) {
        if (e instanceof ExpandStackEvent) {
            IRunControl.IExecutionDMContext execDmc = (IRunControl.IExecutionDMContext)((IDMEvent)e).getDMContext();
            this.buildDeltaForExpandStackEvent(execDmc, parent, rm);
        } else if (e instanceof PropertyChangeEvent) {
            String property = ((PropertyChangeEvent)e).getProperty();
            if ("stackFrameLimitEnable".equals(property) || "stackFrameLimit".equals(property)) {
                this.buildDeltaForStackFrameLimitPreferenceChangedEvent(parent, rm);
            } else if ("org.eclipse.debug.ui.DebugView.org.eclipse.cdt.debug.ui.cDebug.show_full_paths".equals(property)) {
                this.buildDeltaForShowFullPathPreferenceChangedEvent(parent, rm);
            } else {
                rm.done();
            }
        } else {
            rm.done();
        }
    }

    protected void buildDeltaForExpandStackEvent(IRunControl.IExecutionDMContext execDmc, final VMDelta parentDelta, final RequestMonitor rm) {
        parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        final int offset = this.getStackFrameLimit(execDmc) / 2;
        this.getVMProvider().updateNode((IVMNode)this, (IChildrenUpdate)new VMChildrenUpdate((IModelDelta)parentDelta, this.getVMProvider().getPresentationContext(), offset, offset, (DataRequestMonitor)new DataRequestMonitor<List<Object>>(this.getExecutor(), rm){

            public void handleCompleted() {
                List data = (List)this.getData();
                if (data != null && data.size() != 0) {
                    parentDelta.addNode(data.get(0), offset, 0x200000);
                }
                rm.done();
            }
        }));
    }

    protected void buildDeltaForStackFrameLimitPreferenceChangedEvent(VMDelta parentDelta, RequestMonitor rm) {
        parentDelta.setFlags(parentDelta.getFlags() | 0x400);
        rm.done();
    }

    private void buildDeltaForShowFullPathPreferenceChangedEvent(VMDelta parentDelta, RequestMonitor rm) {
        parentDelta.setFlags(parentDelta.getFlags() | 0x800);
        rm.done();
    }

    private String produceFrameElementName(String viewName, IStack.IFrameDMContext frame) {
        if (viewName.startsWith("org.eclipse.debug.ui.VariableView") || viewName.startsWith("org.eclipse.debug.ui.ExpressionView")) {
            return "Frame." + frame.getLevel() + "." + frame.getSessionId();
        }
        return "Frame" + frame.getSessionId();
    }

    public void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementCompareRequest request = iElementCompareRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            String mementoName = memento.getString("STACK_FRAME_MEMENTO_NAME");
            if (mementoName != null && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IStack.IFrameDMContext) {
                String elementName = this.produceFrameElementName(request.getPresentationContext().getId(), (IStack.IFrameDMContext)dmc);
                request.setEqual(elementName.equals(mementoName));
            }
            request.done();
            ++n2;
        }
    }

    public void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IDMContext dmc;
            IElementMementoRequest request = iElementMementoRequestArray[n2];
            Object element = request.getElement();
            IMemento memento = request.getMemento();
            if (element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IStack.IFrameDMContext) {
                String elementName = this.produceFrameElementName(request.getPresentationContext().getId(), (IStack.IFrameDMContext)dmc);
                memento.putString("STACK_FRAME_MEMENTO_NAME", elementName);
            }
            request.done();
            ++n2;
        }
    }

    public int getStackFrameLimit(IRunControl.IExecutionDMContext execCtx) {
        if (this.fTemporaryLimits.containsKey(execCtx)) {
            return this.fTemporaryLimits.get(execCtx);
        }
        Object stackDepthLimit = this.getVMProvider().getPresentationContext().getProperty("stackFrameLimit");
        if (stackDepthLimit instanceof Integer) {
            return (Integer)stackDepthLimit;
        }
        return Integer.MAX_VALUE;
    }

    protected void resetStackFrameLimit(IRunControl.IExecutionDMContext execCtx) {
        if (execCtx instanceof IRunControl.IContainerDMContext) {
            Iterator<IRunControl.IExecutionDMContext> itr = this.fTemporaryLimits.keySet().iterator();
            while (itr.hasNext()) {
                IRunControl.IExecutionDMContext limitCtx = itr.next();
                if (!limitCtx.equals(execCtx) && !DMContexts.isAncestorOf((IDMContext)limitCtx, (IDMContext)execCtx)) continue;
                itr.remove();
            }
        } else {
            this.fTemporaryLimits.remove(execCtx);
        }
    }

    public void incrementStackFrameLimit(IRunControl.IExecutionDMContext execCtx) {
        int stackFrameLimit = this.getStackFrameLimit(execCtx);
        if (stackFrameLimit < 0x3FFFFFFF) {
            this.fTemporaryLimits.put(execCtx, stackFrameLimit * 2);
        } else {
            this.fTemporaryLimits.put(execCtx, Integer.MAX_VALUE);
        }
    }

    protected void updateElementsInSessionThread(final IChildrenUpdate update) {
        this.isActive((IViewerUpdate)update, new ViewerDataRequestMonitor<Boolean>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            protected void handleCompleted() {
                if (this.isSuccess() && ((Boolean)this.getData()).booleanValue()) {
                    CudaStackFramesVMNode.this.baseUpdateElementsInSessionThread(update);
                } else {
                    CudaStackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                }
            }
        });
    }

    private void isActive(IViewerUpdate update, final ViewerDataRequestMonitor<Boolean> rm) {
        IDMVMContext element;
        IDMContext dmContext;
        Object el = update.getElement();
        if (el instanceof IDMVMContext && (dmContext = (element = (IDMVMContext)el).getDMContext()) instanceof IFocusDMContext) {
            IFocusDMContext dmc = (IFocusDMContext)dmContext;
            dmc.getState((DataRequestMonitor)new DataRequestMonitor<CudaRuntimeInformation>((Executor)this.getSession().getExecutor(), rm){

                protected void handleCompleted() {
                    rm.done((Object)(this.isSuccess() && ((CudaRuntimeInformation)this.getData()).getState().isActive() ? 1 : 0));
                }
            });
            return;
        }
        rm.done((Object)true);
    }

    protected void updateElementCountInSessionThread(final IChildrenCountUpdate update) {
        this.isActive((IViewerUpdate)update, new ViewerDataRequestMonitor<Boolean>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            protected void handleCompleted() {
                if (this.isSuccess() && ((Boolean)this.getData()).booleanValue()) {
                    CudaStackFramesVMNode.this.baseUpdateElementCountInSessionThread(update);
                } else {
                    CudaStackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                }
            }
        });
    }

    protected void updateHasElementsInSessionThread(final IHasChildrenUpdate update) {
        this.isActive((IViewerUpdate)update, new ViewerDataRequestMonitor<Boolean>((Executor)this.getSession().getExecutor(), (IViewerUpdate)update){

            protected void handleCompleted() {
                if (this.isSuccess() && ((Boolean)this.getData()).booleanValue()) {
                    CudaStackFramesVMNode.this.baseUpdateHasElementsInSessionThread(update);
                } else {
                    CudaStackFramesVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                }
            }
        });
    }

    public class IncompleteStackVMContext
    extends AbstractVMContext {
        private final int fLevel;
        private final IRunControl.IExecutionDMContext fDmc;

        public IncompleteStackVMContext(IRunControl.IExecutionDMContext dmc, int level) {
            super((IVMNode)CudaStackFramesVMNode.this);
            this.fDmc = dmc;
            this.fLevel = level;
        }

        public int getLevel() {
            return this.fLevel;
        }

        public IRunControl.IExecutionDMContext getExecutionDMContext() {
            return this.fDmc;
        }

        public boolean equals(Object obj) {
            return obj instanceof IncompleteStackVMContext && ((IncompleteStackVMContext)((Object)obj)).fDmc.equals(this.fDmc);
        }

        public int hashCode() {
            return this.fDmc.hashCode();
        }
    }
}

