/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui;

import com.nvidia.cuda.ide.debug.model.CudaDim;
import com.nvidia.cuda.ide.debug.model.CudaThreadState;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.ui.IDebugLabelProvider;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;

public final class DefaultLabelFormatter
implements IDebugLabelProvider {
    @Override
    public String format(CudaThreadState state) {
        switch (state) {
            case DIVERGENT: {
                return "(Divergent)";
            }
            case INACTIVE: {
                return "(Inactive)";
            }
            case RUNNING: {
                return "";
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String format(CudaDim gridDim) {
        return gridDim == null ? "()" : gridDim.toString();
    }

    @Override
    public String formatLong(CudaThreadState state) {
        switch (state) {
            case DIVERGENT: {
                return "Divergent";
            }
            case INACTIVE: {
                return "Inactive";
            }
            case RUNNING: {
                return "Running";
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String formatLong(IFocusDMContext focus) {
        ICudaApplication app = (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)focus, ICudaApplication.class);
        Kernel kernel = app.getKernel(focus.getKernelId());
        if (kernel == null) {
            return "n/a";
        }
        return String.format("Thread %s Block %s Kernel %s", focus.getThreadIdx(), focus.getBlockIdx(), kernel.getName());
    }
}

