/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import java.util.Collections;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class BreakOnKernelModeContributionItem
extends ContributionItem
implements IPropertyChangeListener {
    private static final String[][] ITEMS = new String[][]{{"all", "Break on all kernel launches", CudaDebugImages.TOOL_BREAK_ALL_KERNELS.toString()}, {"application", "Break on application kernel launches", CudaDebugImages.TOOL_BREAK_APP_KERNELS.toString()}, {"system", "Break on system kernel launches", CudaDebugImages.TOOL_BREAK_SYS_KERNELS.toString()}, {"none", "Do not break on kernel launches", CudaDebugImages.TOOL_BREAK_NO_KERNELS.toString()}};
    private int current;
    private ToolItem item;
    private Menu menu;
    private MenuItem[] menuItems;
    private final IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private int previous = 1;

    public BreakOnKernelModeContributionItem() {
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private MenuItem createMenuItem(Menu menu, final int index) {
        MenuItem menuItem = new MenuItem(menu, 16);
        menuItem.setText(ITEMS[index][1]);
        menuItem.setImage(CudaDebugImages.valueOf(ITEMS[index][2]).getImage());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BreakOnKernelModeContributionItem.this.select(index);
            }
        });
        menuItem.setSelection(index == this.current);
        return menuItem;
    }

    protected void toggleCurrent(int index) {
        if (this.current == ITEMS.length - 1) {
            this.select(this.previous);
        } else {
            this.previous = this.current;
            this.select(ITEMS.length - 1);
        }
    }

    public void dispose() {
        if (this.item != null && !this.item.isDisposed()) {
            this.item.dispose();
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void fill(ToolBar parent, int index) {
        this.item = new ToolItem(parent, 4, index);
        this.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 4) {
                    BreakOnKernelModeContributionItem.this.showMenu(e);
                } else {
                    BreakOnKernelModeContributionItem.this.toggleCurrent(BreakOnKernelModeContributionItem.this.previous);
                }
            }
        });
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.update();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("break_on_launch".equals(event.getProperty())) {
            this.update();
        }
    }

    protected void showMenu(SelectionEvent e) {
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = new Menu((Control)this.item.getParent());
            this.menuItems = new MenuItem[ITEMS.length];
            int i = 0;
            while (i < ITEMS.length) {
                this.menuItems[i] = this.createMenuItem(this.menu, i);
                ++i;
            }
        }
        Point point = this.item.getParent().toDisplay(new Point(e.x, e.y));
        this.menu.setLocation(point.x, point.y);
        this.menu.setVisible(true);
    }

    protected void select(int mode) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("com.nvidia.cuda.ide.debug.commands.breakOnLaunch");
        ParameterizedCommand pCommand = ParameterizedCommand.generateCommand((Command)command, Collections.singletonMap("mode", ITEMS[mode][0]));
        try {
            pCommand.executeWithChecks(null, null);
        }
        catch (ExecutionException e) {
            Activator.log(e);
        }
        catch (NotDefinedException e) {
            Activator.log(e);
        }
        catch (NotEnabledException e) {
            Activator.log(e);
        }
        catch (NotHandledException e) {
            Activator.log(e);
        }
    }

    public void update() {
        int i;
        String value = this.preferenceStore.getString("break_on_launch");
        this.current = ITEMS.length - 1;
        if (value != null && value.trim().length() != 0) {
            i = 0;
            while (i < ITEMS.length) {
                if (value.trim().equals(ITEMS[i][0])) {
                    this.current = i;
                    break;
                }
                ++i;
            }
        }
        if (this.item != null) {
            this.item.setImage(CudaDebugImages.valueOf(ITEMS[this.current][2]).getImage());
            this.item.setToolTipText(ITEMS[this.current][1]);
        }
        if (this.menuItems != null) {
            i = 0;
            while (i < this.menuItems.length) {
                this.menuItems[i].setSelection(i == this.current);
                ++i;
            }
        }
    }
}

