/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.service;

import com.nvidia.cuda.ide.debug.memory.DeviceMemoryType;
import com.nvidia.cuda.ide.debug.mi.AbstractMITableInfo;
import com.nvidia.cuda.ide.debug.mi.CudaInfoDevices;
import com.nvidia.cuda.ide.debug.mi.CudaMIDataListRegisterNames;
import com.nvidia.cuda.ide.debug.mi.CudaMIDataListRegisterValues;
import com.nvidia.cuda.ide.debug.mi.CudaMIVarUpdate;
import com.nvidia.cuda.ide.debug.mi.DeviceInfo;
import com.nvidia.cuda.ide.debug.mi.LaunchTraceInfo;
import com.nvidia.cuda.ide.debug.mi.MICudaFocusSwitch;
import com.nvidia.cuda.ide.debug.mi.MICudaInfoBlocks;
import com.nvidia.cuda.ide.debug.mi.MICudaInfoKernels;
import com.nvidia.cuda.ide.debug.mi.MICudaInfoLanes;
import com.nvidia.cuda.ide.debug.mi.MICudaInfoLaunchTrace;
import com.nvidia.cuda.ide.debug.mi.MICudaInfoThreads;
import com.nvidia.cuda.ide.debug.mi.MICudaInfoWarps;
import com.nvidia.cuda.ide.debug.mi.MIFileListExecSourceFiles;
import com.nvidia.cuda.ide.debug.mi.MIFileListExecSourceFilesInfo;
import com.nvidia.cuda.ide.debug.mi.vo.KernelInfo;
import com.nvidia.cuda.ide.debug.mi.vo.LaneInfo;
import com.nvidia.cuda.ide.debug.mi.vo.SMInfo;
import com.nvidia.cuda.ide.debug.mi.vo.UnCoalescedBlockInfo;
import com.nvidia.cuda.ide.debug.mi.vo.UncoalescedThreadInfo;
import com.nvidia.cuda.ide.debug.mi.vo.UncoalescedWarpInfo;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.IFocusDMContext;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.service.CudaInfoSMs;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.debug.service.IMemorySpaces;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.service.command.CommandFactory_6_8;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.command.MIControlDMContext;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataListRegisterNamesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataListRegisterValuesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;

public final class CudaCommandFactory
extends CommandFactory_6_8 {
    public ICommand<MIBreakInsertInfo> createMIBreakInsert(IBreakpoints.IBreakpointsTargetDMContext ctx, boolean isTemporary, boolean isHardware, String condition, int ignoreCount, String line, int tid) {
        return super.createMIBreakInsert(ctx, isTemporary, isHardware, condition, ignoreCount, line, isTemporary ? 0 : tid);
    }

    public ICommand<MIBreakInsertInfo> createMIBreakInsert(IBreakpoints.IBreakpointsTargetDMContext ctx, boolean isTemporary, boolean isHardware, String condition, int ignoreCount, String location, int tid, boolean disabled, boolean isTracepoint) {
        return super.createMIBreakInsert(ctx, isTemporary, isHardware, condition, ignoreCount, location, isTemporary ? 0 : tid, disabled, isTracepoint);
    }

    public ICommand<AbstractMITableInfo<UnCoalescedBlockInfo>> createMICudaInfoBlocks(MIControlDMContext dmc, long kernelId) {
        return new MICudaInfoBlocks((IDMContext)dmc, kernelId);
    }

    public ICommand<AbstractMITableInfo<DeviceInfo>> createMICudaInfoDevices(MIControlDMContext dmc) {
        return new CudaInfoDevices((IDMContext)dmc);
    }

    public ICommand<AbstractMITableInfo<KernelInfo>> createMICudaInfoKernels(MIControlDMContext ctx) {
        return new MICudaInfoKernels(ctx);
    }

    public ICommand<AbstractMITableInfo<LaneInfo>> createMICudaInfoLanes(MIControlDMContext dmc, short deviceId, short sm, short warpId) {
        return new MICudaInfoLanes(dmc, deviceId, sm, warpId);
    }

    public ICommand<AbstractMITableInfo<LaunchTraceInfo>> createMICudaInfoLaunchTrace(MIControlDMContext ctx, long kernelId) {
        return new MICudaInfoLaunchTrace((IDMContext)ctx, kernelId);
    }

    public ICommand<AbstractMITableInfo<SMInfo>> createMICudaInfoSMs(MIControlDMContext ctx, short deviceId) {
        return new CudaInfoSMs((IDMContext)ctx, deviceId);
    }

    public ICommand<AbstractMITableInfo<UncoalescedThreadInfo>> createMICudaInfoThreads(IDMContext dmc, long kernelId, CudaCoord blockIdx) {
        return new MICudaInfoThreads(dmc, kernelId, blockIdx);
    }

    public ICommand<AbstractMITableInfo<UncoalescedThreadInfo>> createMICudaInfoThreads(MIControlDMContext dmc, short deviceId, short sm, short warp, short lane) {
        return new MICudaInfoThreads((IDMContext)dmc, deviceId, sm, warp, lane);
    }

    public ICommand<AbstractMITableInfo<UncoalescedWarpInfo>> createMICudaInfoWarps(MIControlDMContext dmc, short deviceId, short sm) {
        return new MICudaInfoWarps((IDMContext)dmc, deviceId, sm);
    }

    private ICommand<MIInfo> createMICudaKernelSelect(Kernel cudaKernel) {
        return new MICudaFocusSwitch(cudaKernel);
    }

    public ICommand<MIInfo> createMICudaThreadSelect(IFocusDMContext cudaThread) {
        return new MICudaFocusSwitch(cudaThread);
    }

    public ICommand<MIDataListRegisterNamesInfo> createMIDataListRegisterNames(IRunControl.IExecutionDMContext ctx, int[] regnos) {
        return new CudaMIDataListRegisterNames(ctx, regnos);
    }

    public ICommand<MIDataListRegisterNamesInfo> createMIDataListRegisterNames(IMIExecutionDMContext executionDmc) {
        return new CudaMIDataListRegisterNames((IRunControl.IExecutionDMContext)executionDmc);
    }

    public ICommand<MIDataListRegisterValuesInfo> createMIDataListRegisterValues(IMIExecutionDMContext ctx, int fmt) {
        return new CudaMIDataListRegisterValues(ctx, fmt);
    }

    public ICommand<MIDataListRegisterValuesInfo> createMIDataListRegisterValues(IMIExecutionDMContext ctx, int fmt, int[] regnos) {
        return new CudaMIDataListRegisterValues(ctx, fmt, regnos);
    }

    public ICommand<MIDataReadMemoryInfo> createMIDataReadMemory(IDMContext ctx, long offset, String address, int word_format, int word_size, int rows, int cols, Character asChar) {
        String realAddress;
        IMemorySpaces.IMemorySpaceDMContext memspace = (IMemorySpaces.IMemorySpaceDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IMemorySpaces.IMemorySpaceDMContext.class);
        if (memspace != null) {
            String memorySpaceId = memspace.getMemorySpaceId();
            realAddress = String.valueOf(DeviceMemoryType.valueOf(memorySpaceId).getCast()) + address;
        } else {
            realAddress = address;
        }
        return super.createMIDataReadMemory(ctx, offset, realAddress, word_format, word_size, rows, cols, asChar);
    }

    public ICommand<MIFileListExecSourceFilesInfo> createMIFileListExecSourceFiles(ICommandControlService.ICommandControlDMContext ctx) {
        return new MIFileListExecSourceFiles(ctx);
    }

    public ICommand<MIInfo> createMIThreadSelect(IDMContext ctx, int threadNum) {
        IFocusDMContext cudaThread = (IFocusDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IFocusDMContext.class);
        if (cudaThread != null) {
            return this.createMICudaThreadSelect(cudaThread);
        }
        Kernel cudaKernel = (Kernel)DMContexts.getAncestorOfType((IDMContext)ctx, Kernel.class);
        if (cudaKernel != null) {
            return this.createMICudaKernelSelect(cudaKernel);
        }
        return super.createMIThreadSelect(ctx, threadNum);
    }

    public ICommand<MIInfo> createMIThreadSelect(IDMContext ctx, String threadNum) {
        IFocusDMContext cudaThread = (IFocusDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IFocusDMContext.class);
        if (cudaThread != null) {
            return this.createMICudaThreadSelect(cudaThread);
        }
        Kernel cudaKernel = (Kernel)DMContexts.getAncestorOfType((IDMContext)ctx, Kernel.class);
        if (cudaKernel != null) {
            return this.createMICudaKernelSelect(cudaKernel);
        }
        return super.createMIThreadSelect(ctx, threadNum);
    }

    public CudaMIVarUpdate createMIVarUpdate(IFocusDMContext focusContext, String gdbName) {
        return new CudaMIVarUpdate(focusContext, gdbName);
    }
}

