/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.state;

import com.nvidia.cuda.ide.debug.mi.DeviceInfo;
import com.nvidia.cuda.ide.debug.mi.vo.SMInfo;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.CudaThreadState;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.state.ICudaQueries;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;

public final class HardwareStateManager {
    private long[][] smsMasks;
    private final ICudaQueries queries;
    private final ICudaApplication application;
    private Device[] devices;

    public HardwareStateManager(ICudaApplication application, ICudaQueries queries) {
        this.application = application;
        this.queries = queries;
    }

    public void invalidate() {
        this.smsMasks = null;
        this.devices = null;
    }

    public void getDevices(final DataRequestMonitor<Device[]> rm) {
        if (this.devices != null) {
            rm.setData((Object)this.devices);
            rm.done();
        } else if (!DsfSession.isSessionActive((String)this.application.getSessionId())) {
            rm.setData((Object)new Device[0]);
            rm.done();
        } else {
            this.queries.queryDevices(this.application, new DataRequestMonitor<DeviceInfo[]>((Executor)this.queries.getExecutor(), rm){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    HardwareStateManager.this.createDevices((DeviceInfo[])this.getData());
                    rm.setData((Object)HardwareStateManager.this.devices);
                    rm.done();
                }

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleErrorOrWarning() {
                    rm.setData((Object)new Device[0]);
                    rm.done();
                }
            });
        }
    }

    protected synchronized void createDevices(DeviceInfo[] infos) {
        if (this.devices == null) {
            if (infos == null || infos.length == 0) {
                this.devices = new Device[0];
            } else {
                this.devices = new Device[infos.length];
                int i = 0;
                DeviceInfo[] deviceInfoArray = infos;
                int n = infos.length;
                int n2 = 0;
                while (n2 < n) {
                    DeviceInfo info = deviceInfoArray[n2];
                    this.devices[i] = new Device(this.application, info.getId(), info.getDescription(), info.getSmType(), info.getSmCount(), info.getWarpCount(), info.getLaneCount(), info.getRegisterCount(), info.getActiveSMsMask());
                    ++i;
                    ++n2;
                }
            }
        }
    }

    private void ensureSMMasksUptodate(final Device device, final RequestMonitor rm) {
        if (this.devices == null) {
            rm.cancel();
            rm.done();
            return;
        }
        if (this.smsMasks == null) {
            this.smsMasks = new long[this.devices.length][];
        }
        if (this.smsMasks[device.getId()] == null) {
            this.queries.querySMs(device, device.getId(), new DataRequestMonitor<SMInfo[]>((Executor)this.queries.getExecutor(), rm){

                protected void handleSuccess() {
                    if (DebugUtil.isNullOrEmpty((Object[])this.getData())) {
                        rm.done();
                        return;
                    }
                    short deviceId = device.getId();
                    if (HardwareStateManager.this.smsMasks[deviceId] == null) {
                        ((HardwareStateManager)HardwareStateManager.this).smsMasks[deviceId] = new long[((SMInfo[])this.getData()).length];
                        SMInfo[] sMInfoArray = (SMInfo[])this.getData();
                        int n = sMInfoArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SMInfo info = sMInfoArray[n2];
                            ((HardwareStateManager)HardwareStateManager.this).smsMasks[deviceId][info.getSM()] = info.activeWarpsMask();
                            ++n2;
                        }
                    }
                    rm.done();
                }
            });
        } else {
            rm.done();
        }
    }

    public void getSMState(final StreamingMultiprocessor sm, final DataRequestMonitor<CudaRuntimeInformation> rm) {
        if (this.smsMasks == null) {
            this.getDevices(new DataRequestMonitor<Device[]>((Executor)this.queries.getExecutor(), rm){

                protected void handleSuccess() {
                    if (DebugUtil.isNullOrEmpty((Object[])this.getData())) {
                        rm.done();
                        return;
                    }
                    if (HardwareStateManager.this.smsMasks == null) {
                        HardwareStateManager.this.smsMasks = new long[((Device[])this.getData()).length][];
                    }
                    HardwareStateManager.this.getSMState(sm, (DataRequestMonitor<CudaRuntimeInformation>)rm);
                }
            });
        } else if (this.smsMasks[sm.getDeviceId()] == null) {
            this.ensureSMMasksUptodate((Device)DMContexts.getAncestorOfType((IDMContext)sm, Device.class), new RequestMonitor(this.application.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
                private final /* synthetic */ DataRequestMonitor val$rm;
                {
                    this.val$rm = dataRequestMonitor;
                    super($anonymous0, $anonymous1);
                }

                protected void handleSuccess() {
                    HardwareStateManager.this.getSMState(sm, (DataRequestMonitor<CudaRuntimeInformation>)this.val$rm);
                }
            });
        } else {
            byte activeWarps = DebugUtil.bitCount(this.smsMasks[sm.getDeviceId()][sm.getId()]);
            CudaRuntimeInformation info = new CudaRuntimeInformation(sm.getDeviceId(), sm.getId(), -1, -1, activeWarps == 0 ? CudaThreadState.INACTIVE : CudaThreadState.RUNNING);
            info.setActiveWarps(activeWarps);
            rm.setData((Object)info);
            rm.done();
        }
    }

    public void getWarpActiveBit(final Warp warp, DataRequestMonitor<Boolean> rm) {
        this.ensureSMMasksUptodate((Device)DMContexts.getAncestorOfType((IDMContext)warp, Device.class), new RequestMonitor((Executor)this.queries.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
            private final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                int warpMask;
                long mask = HardwareStateManager.this.smsMasks[warp.getDeviceId()][warp.getSMId()];
                long b = mask & (long)(warpMask = 1 << warp.getId());
                this.val$rm.setData((Object)(b != 0L ? 1 : 0));
                this.val$rm.done();
            }
        });
    }

    public void getWarpMasks(Device device, DataRequestMonitor<long[]> rm) {
        this.ensureSMMasksUptodate(device, new RequestMonitor((Executor)this.queries.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm, device){
            private final /* synthetic */ DataRequestMonitor val$rm;
            private final /* synthetic */ Device val$device;
            {
                this.val$rm = dataRequestMonitor;
                this.val$device = device;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                this.val$rm.setData((Object)HardwareStateManager.this.smsMasks[this.val$device.getId()]);
                this.val$rm.done();
            }
        });
    }
}

