/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.state;

import com.nvidia.cuda.ide.debug.mi.vo.UnCoalescedBlockInfo;
import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.CudaThreadState;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.state.AbstractCudaStateManager;
import com.nvidia.cuda.ide.debug.model.state.ICudaQueries;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class BlocksStateManager
extends AbstractCudaStateManager {
    private final Map<Long, Map<Long, Short>> activeBlocks = new ConcurrentHashMap<Long, Map<Long, Short>>();
    private final ICudaApplication application;
    private final ICudaQueries queries;

    public BlocksStateManager(ICudaApplication application, ICudaQueries queries) {
        this.application = application;
        this.queries = queries;
    }

    public void clear() {
        this.activeBlocks.clear();
    }

    protected void fillBlockState(Block cudaBlock, DataRequestMonitor<CudaRuntimeInformation> rm) {
        Kernel kernel = cudaBlock.getKernel();
        long ordinal = kernel.getGridDim().getOrdinal(cudaBlock.getBlockIdx());
        Map<Long, Short> ls = this.activeBlocks.get(kernel.getId());
        CudaThreadState state = ls != null ? (ls.containsKey(ordinal) ? CudaThreadState.RUNNING : CudaThreadState.INACTIVE) : CudaThreadState.INACTIVE;
        short sm = state.isActive() ? (short)this.getSM(cudaBlock) : (short)-1;
        rm.setData((Object)new CudaRuntimeInformation(kernel.getDeviceId(), sm, -1, -1, state));
        rm.done();
    }

    public void getBlockState(final Block cudaBlock, DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.ensureUpToDate(cudaBlock.getKernel(), cudaBlock.getKernel().getId(), new RequestMonitor((Executor)this.queries.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
            private final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                BlocksStateManager.this.fillBlockState(cudaBlock, (DataRequestMonitor<CudaRuntimeInformation>)this.val$rm);
            }
        });
    }

    private void ensureUpToDate(final Kernel kernel, final long kernelId, final RequestMonitor rm) {
        if (this.activeBlocks.get(kernelId) != null) {
            rm.done();
        } else {
            kernel.getState(new DataRequestMonitor<CudaRuntimeInformation>((Executor)this.queries.getExecutor(), rm){

                protected void handleSuccess() {
                    if (((CudaRuntimeInformation)this.getData()).getState().isActive()) {
                        BlocksStateManager.this.queries.queryBlocks(kernel, kernelId, new BlocksReconciler((Executor)BlocksStateManager.this.queries.getExecutor(), kernelId, rm));
                    } else {
                        BlocksStateManager.this.activeBlocks.put(kernel.getId(), new TreeMap());
                        rm.done();
                    }
                }
            });
        }
    }

    public short getSM(Block cudaBlock) {
        Map<Long, Short> blocks = this.activeBlocks.get(cudaBlock.getKernel().getId());
        if (blocks != null && blocks.containsKey(cudaBlock.getOrdinal())) {
            return blocks.get(cudaBlock.getOrdinal());
        }
        return -1;
    }

    protected void parseBlocks(long kernelId, UnCoalescedBlockInfo[] blocks) {
        UnCoalescedBlockInfo[] unCoalescedBlockInfoArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            UnCoalescedBlockInfo entry = unCoalescedBlockInfoArray[n2];
            Kernel kernel = this.application.getKernel(kernelId);
            CudaCoord blockIdx = entry.getBlockIdx();
            Map<Object, Object> blockToSm = this.activeBlocks.containsKey(kernel.getId()) ? this.activeBlocks.get(kernel.getId()) : new TreeMap();
            long blockId = kernel.getGridDim().getOrdinal(blockIdx);
            blockToSm.put(blockId, entry.getSm());
            this.activeBlocks.put(kernel.getId(), blockToSm);
            ++n2;
        }
    }

    public void getActiveBlocks(final Kernel kernel, final boolean fillGaps, final ICoordSorter sorter, DataRequestMonitor<IDMContext[]> rm) {
        this.ensureUpToDate(kernel, kernel.getId(), new RequestMonitor((Executor)this.queries.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
            private final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                BlocksStateManager.this.buildBlocksList(kernel, fillGaps, sorter, (DataRequestMonitor<IDMContext[]>)this.val$rm);
            }
        });
    }

    protected void buildBlocksList(Kernel kernel, boolean fillGaps, ICoordSorter sorter, DataRequestMonitor<IDMContext[]> rm) {
        CudaDim dim = kernel.getGridDim();
        Map<Long, Short> map = this.activeBlocks.get(kernel.getId());
        if (map == null) {
            map = Collections.emptyMap();
            this.activeBlocks.put(kernel.getId(), map);
        }
        Set<Long> keySet = map.keySet();
        try {
            IDMContext[] array = this.getActiveElements(this.application.getKernel(kernel.getId()), fillGaps, sorter, dim, keySet.iterator());
            rm.setData((Object)array);
        }
        catch (CudaException e) {
            rm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
        }
        rm.done();
    }

    @Override
    protected IDMContext createDMContext(IDMContext parent, CudaCoord coord) throws CudaException {
        return ((Kernel)parent).getBlock(coord);
    }

    private final class BlocksReconciler
    extends DataRequestMonitor<UnCoalescedBlockInfo[]> {
        private final RequestMonitor rm;
        private final long kernelId;

        private BlocksReconciler(Executor executor, long kernelId, RequestMonitor rm) {
            super(executor, rm);
            this.kernelId = kernelId;
            this.rm = rm;
        }

        protected void handleSuccess() {
            if (BlocksStateManager.this.activeBlocks.get(this.kernelId) == null) {
                BlocksStateManager.this.parseBlocks(this.kernelId, (UnCoalescedBlockInfo[])this.getData());
            }
            this.rm.done();
        }
    }
}

