/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import com.nvidia.cuda.ide.debug.memory.CudaGdbMemoryBlockRetrieval;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.internal.memory.GdbMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.ShutdownSequence;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.ISourceLocator;

public final class CudaLaunch
extends GdbLaunch {
    protected GdbMemoryBlockRetrieval fMemRetrieval;
    private final AtomicBoolean isShutDown = new AtomicBoolean(false);
    private boolean preemption;

    public CudaLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
    }

    public void initializeControl() throws CoreException {
        try {
            final DsfSession session = this.getSession();
            session.getExecutor().submit((Callable)new Callable<Object>(){

                @Override
                public Object call() throws CoreException {
                    CudaLaunch.this.fMemRetrieval = new CudaGdbMemoryBlockRetrieval("org.eclipse.cdt.dsf.gdb", CudaLaunch.this.getLaunchConfiguration(), session);
                    session.registerModelAdapter(IMemoryBlockRetrieval.class, (Object)CudaLaunch.this.fMemRetrieval);
                    session.addServiceEventListener((Object)CudaLaunch.this.fMemRetrieval, null);
                    return null;
                }
            }).get();
        }
        catch (InterruptedException e) {
            throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", 0, "Interrupted while waiting for get process callable.", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw (CoreException)e.getCause();
        }
        catch (RejectedExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", 0, "Debugger shut down before launch was completed.", (Throwable)e));
        }
    }

    public boolean isPreemptionOn() {
        return this.preemption;
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    public void shutdownSession(final RequestMonitor rm) {
        if (!this.isShutDown.compareAndSet(false, true)) {
            rm.done();
            return;
        }
        final DsfSession session = this.getSession();
        ShutdownSequence shutdownSeq = new ShutdownSequence(this.getDsfExecutor(), session.getId(), new RequestMonitor((Executor)session.getExecutor(), rm){

            public void handleCompleted() {
                if (CudaLaunch.this.fMemRetrieval != null) {
                    session.removeServiceEventListener((Object)CudaLaunch.this.fMemRetrieval);
                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)CudaLaunch.this.fMemRetrieval, 8)});
                }
                CudaLaunch.super.shutdownSession(rm);
            }
        });
        session.getExecutor().execute((Runnable)shutdownSeq);
    }

    public void setPreemptionEnabled(boolean preemption) {
        this.preemption = preemption;
    }
}

