/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.launch;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.service.ICudaGdbOptions;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.gdb.launching.FinalLaunchSequence_7_2;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;

public final class CudaFinalLaunchSequence
extends FinalLaunchSequence_7_2 {
    public static final String ATTR_PREEMPTION = String.valueOf(CudaFinalLaunchSequence.class.getName()) + ".preemptionEnabled";
    private final Map<String, Object> attributes;
    private final DsfSession session;

    private static boolean isRemoteSession(DsfSession session) {
        DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), session.getId());
        try {
            IGDBBackend backend = (IGDBBackend)tracker.getService(IGDBBackend.class);
            boolean bl = backend.getSessionType() == SessionType.REMOTE;
            return bl;
        }
        finally {
            tracker.dispose();
        }
    }

    public CudaFinalLaunchSequence(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
        this.session = session;
        this.attributes = attributes;
    }

    private String getBooleanFlag(String option) {
        return Boolean.TRUE.equals(this.attributes.get(option)) ? "on" : "off";
    }

    protected String[] getExecutionOrder(String group) {
        Object[] order = super.getExecutionOrder(group);
        if (!CoreUtil.isNullOrEmpty((Object[])order)) {
            String[] newOrder = new String[order.length + 3];
            newOrder[0] = "stepSetCudaOptions";
            newOrder[1] = "stepSetBreakOnApiFailures";
            newOrder[2] = "stepSetKernelNotifications";
            System.arraycopy(order, 0, newOrder, 3, order.length);
            return newOrder;
        }
        return order;
    }

    private void setVariable(RequestMonitor requestMonitor, String ... params) {
        DsfServicesTracker tracker = new DsfServicesTracker(Activator.getBundleContext(), this.session.getId());
        try {
            IMICommandControl fCommandControl = (IMICommandControl)tracker.getService(IMICommandControl.class);
            fCommandControl.queueCommand(fCommandControl.getCommandFactory().createMIGDBSet((IDMContext)fCommandControl.getContext(), params), new DataRequestMonitor((Executor)this.getExecutor(), requestMonitor));
        }
        finally {
            tracker.dispose();
        }
    }

    @ReflectionSequence.Execute
    public void stepSetBreakpointPending(final RequestMonitor requestMonitor) {
        super.stepSetBreakpointPending(new RequestMonitor(ImmediateExecutor.getInstance(), requestMonitor){

            protected void handleSuccess() {
                CudaFinalLaunchSequence.this.setVariable(requestMonitor, new String[]{"breakpoint", "conditional-pending", "on"});
            }
        });
    }

    @ReflectionSequence.Execute
    public void stepSetCudaOptions(RequestMonitor rm) {
        CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), rm);
        crm.setDoneCount(5);
        this.setVariable((RequestMonitor)crm, "cuda", "coalescing", "off");
        this.setVariable((RequestMonitor)crm, "cuda", ICudaGdbOptions.SS_OPTIMIZATIONS, "on");
        this.setVariable((RequestMonitor)crm, "cuda", "memcheck", this.getBooleanFlag("lc.enable.memcheck"));
        this.setVariable((RequestMonitor)crm, "cuda", "software_preemption", this.getBooleanFlag(ATTR_PREEMPTION));
        this.setVariable((RequestMonitor)crm, "cuda", "value_extrapolation", this.getBooleanFlag("lc.extrapolate"));
    }

    @ReflectionSequence.Execute
    public void stepSetBreakOnApiFailures(RequestMonitor rm) {
        Object object = this.attributes.get("breakOnError");
        String mode = Boolean.TRUE.equals(object) ? "stop" : "ignore";
        this.setVariable(rm, "cuda", "api_failures", mode);
    }

    @ReflectionSequence.Execute
    public void stepSetKernelNotifications(RequestMonitor rm) {
        Object property = this.attributes.get("lc.kernelevents");
        String events = Boolean.TRUE.equals(property) || "1".equals(System.getProperty("nsight.kernelEvents")) ? "all" : "none";
        this.setVariable(rm, "cuda", "kernel_events", events);
    }

    @ReflectionSequence.Execute
    public void stepSetSharedLibraryPaths(final RequestMonitor requestMonitor) {
        RequestMonitor rm = this.useRemoteSysroot() ? new RequestMonitor(ImmediateExecutor.getInstance(), requestMonitor){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                CudaFinalLaunchSequence.this.setVariable(requestMonitor, new String[]{"sysroot", "remote://"});
            }
        } : requestMonitor;
        super.stepSetSharedLibraryPaths(rm);
    }

    @ReflectionSequence.Execute
    public void stepSourceGDBInitFile(final RequestMonitor requestMonitor) {
        super.stepSourceGDBInitFile(new RequestMonitor(ImmediateExecutor.getInstance(), requestMonitor){

            protected void handleFailure() {
                requestMonitor.done();
            }
        });
    }

    private boolean useRemoteSysroot() {
        return !Boolean.FALSE.equals(this.attributes.get("lc.downloadso")) && CudaFinalLaunchSequence.isRemoteSession(this.session);
    }
}

