/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.core;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class DebugPreferencesListener
implements IPropertyChangeListener {
    private static final Collection<String> ignoredLaunches = Collections.synchronizedSet(new HashSet());
    private final MessageRunnable runnable = new MessageRunnable();

    public static void donotIgnore(ILaunchConfiguration config) {
        ignoredLaunches.remove(config.getName());
    }

    public static void ignore(ILaunchConfiguration config) {
        ignoredLaunches.add(config.getName());
    }

    private void notifyUserDebugRestartNeeded(Object value) {
        if (this.runnable.aboutToPost(Boolean.TRUE.equals(value))) {
            Display.getDefault().asyncExec((Runnable)this.runnable);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("enablePreemption".equals(event.getProperty()) && !CoreUtil.equals((Object)event.getOldValue(), (Object)event.getNewValue())) {
            try {
                if (this.warnIfLocalDebugSessions()) {
                    this.notifyUserDebugRestartNeeded(event.getNewValue());
                }
            }
            catch (CoreException e) {
                Activator.log(e);
            }
        }
    }

    private boolean warnIfLocalDebugSessions() throws CoreException {
        ILaunchManager manager;
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null && (manager = plugin.getLaunchManager()) != null) {
            ILaunch[] iLaunchArray = manager.getLaunches();
            int n = iLaunchArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                if (!ignoredLaunches.contains(launch.getLaunchConfiguration().getName()) && DebugUtil.isLocalCudaGdbLaunch(launch)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public class MessageRunnable
    implements Runnable {
        private boolean enabling;
        private final AtomicBoolean ran = new AtomicBoolean(false);

        public boolean aboutToPost(boolean enabling) {
            if (this.ran.compareAndSet(false, true)) {
                this.enabling = enabling;
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ran.set(false);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                MessageDialog.openWarning((Shell)window.getShell(), (String)"Nsight Visual Debugger", (String)String.format("%s CUDA software preemption debugging requires restarting local debug sessions", this.enabling ? "Enabling" : "Disabling"));
            }
        }
    }
}

