/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.core;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ptp.internal.remote.core.RemoteServicesImpl;
import org.eclipse.ptp.internal.remote.core.RemoteServicesProxy;
import org.eclipse.ptp.remote.core.IRemoteServices;

public class RemoteServices {
    private static IRemoteServices fLocalServices;

    public static IRemoteServices getLocalServices() {
        if (fLocalServices == null) {
            fLocalServices = RemoteServices.getRemoteServices("org.eclipse.ptp.remote.LocalServices");
        }
        return fLocalServices;
    }

    public static IRemoteServices getRemoteServices(String id) {
        return RemoteServices.getRemoteServices(id, null);
    }

    public static IRemoteServices getRemoteServices(String id, IProgressMonitor monitor) {
        IRemoteServices service;
        RemoteServicesProxy proxy = RemoteServicesImpl.getRemoteServiceProxyById(id);
        if (proxy != null && (service = proxy.getServices()).initialize(monitor)) {
            return service;
        }
        return null;
    }

    public static IRemoteServices getRemoteServices(URI uri) {
        return RemoteServices.getRemoteServices(uri, null);
    }

    public static IRemoteServices getRemoteServices(URI uri, IProgressMonitor monitor) {
        IRemoteServices service;
        RemoteServicesProxy proxy = RemoteServicesImpl.getRemoteServiceProxyByURI(uri);
        if (proxy != null && (service = proxy.getServices()).initialize(monitor)) {
            return service;
        }
        return null;
    }
}

