/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.core;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ptp.internal.remote.rse.core.RSEConnection;
import org.eclipse.ptp.internal.remote.rse.core.RSEConnectionManager;
import org.eclipse.ptp.internal.remote.rse.core.RSEFileManager;
import org.eclipse.ptp.internal.remote.rse.core.RSEProcessBuilder;
import org.eclipse.ptp.internal.remote.rse.core.messages.Messages;
import org.eclipse.ptp.remote.core.AbstractRemoteServices;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcess;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.IRemoteServicesDescriptor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RSEServices
extends AbstractRemoteServices {
    private ISystemRegistry fRegistry = null;
    private IRemoteConnectionManager fConnMgr = null;
    private boolean fInitialized;

    public RSEServices(IRemoteServicesDescriptor descriptor) {
        super(descriptor);
    }

    private void checkInitialize() {
        this.fRegistry = RSECorePlugin.getTheSystemRegistry();
        if (this.fRegistry == null) {
            return;
        }
        if (!RSECorePlugin.isInitComplete((int)0)) {
            return;
        }
        if (!RSECorePlugin.getThePersistenceManager().isRestoreComplete()) {
            return;
        }
        this.fConnMgr = new RSEConnectionManager(this.fRegistry, (IRemoteServices)this);
        this.fInitialized = true;
    }

    public IRemoteProcess getCommandShell(IRemoteConnection conn, int flags) throws IOException {
        throw new IOException("Not currently implemented");
    }

    public IRemoteConnectionManager getConnectionManager() {
        if (!this.fInitialized) {
            return null;
        }
        if (this.fConnMgr == null) {
            this.fConnMgr = new RSEConnectionManager(this.fRegistry, (IRemoteServices)this);
        }
        return this.fConnMgr;
    }

    public IRemoteFileManager getFileManager(IRemoteConnection conn) {
        if (!this.fInitialized) {
            return null;
        }
        if (!(conn instanceof RSEConnection)) {
            return null;
        }
        return new RSEFileManager((RSEConnection)conn);
    }

    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, List<String> command) {
        if (!this.fInitialized) {
            return null;
        }
        return new RSEProcessBuilder(conn, this.getFileManager(conn), command);
    }

    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, String ... command) {
        if (!this.fInitialized) {
            return null;
        }
        return new RSEProcessBuilder(conn, this.getFileManager(conn), command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initialize(IProgressMonitor monitor) {
        if (!this.fInitialized) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            progress.setTaskName(Messages.RSEServices_Initializing_RSE_services);
            while (!this.fInitialized && !progress.isCanceled()) {
                progress.setWorkRemaining(9);
                this.checkInitialize();
                if (!this.fInitialized) {
                    try {
                        RSEServices rSEServices = this;
                        synchronized (rSEServices) {
                            ((Object)((Object)this)).wait(500L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                progress.worked(1);
            }
        }
        return this.fInitialized;
    }
}

