/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.processes;

import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.ui.templateengine.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class OpenFiles
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        ProcessArgument[][] files;
        ProcessArgument[][] processArgumentArray = files = args[1].getComplexArrayValue();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument[] file = processArgumentArray[n2];
            String fileTargetPath = file[0].getSimpleValue();
            String projectName = args[0].getSimpleValue();
            IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IFile iFile = projectHandle.getFile(fileTargetPath);
            if (iFile.exists()) {
                try {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)iFile);
                    BasicNewResourceWizard.selectAndReveal((IResource)iFile, (IWorkbenchWindow)window);
                }
                catch (PartInitException partInitException) {
                    throw new ProcessFailureException(String.valueOf(Messages.OpenFiles_CannotOpen_error) + fileTargetPath);
                }
            } else {
                throw new ProcessFailureException(String.valueOf(Messages.OpenFiles_FileNotExist_error) + fileTargetPath);
            }
            ++n2;
        }
    }
}

