/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.ui.refactoring.utils.IdentifierResult;
import org.eclipse.cdt.internal.ui.refactoring.utils.Messages;
import org.eclipse.osgi.util.NLS;

public class IdentifierHelper {
    public static IdentifierResult checkIdentifierName(String identifier) {
        if (identifier == null) {
            return null;
        }
        if (IdentifierHelper.isCorrect(identifier)) {
            if (IdentifierHelper.isKeyword(identifier)) {
                return new IdentifierResult(4, NLS.bind((String)Messages.IdentifierHelper_isKeyword, (Object)identifier));
            }
            return new IdentifierResult(0, NLS.bind((String)Messages.IdentifierHelper_isValid, (Object)identifier));
        }
        if (IdentifierHelper.isLeadingADigit(identifier)) {
            return new IdentifierResult(3, NLS.bind((String)Messages.IdentifierHelper_leadingDigit, (Object)identifier));
        }
        if (identifier.length() == 0) {
            return new IdentifierResult(1, Messages.IdentifierHelper_emptyIdentifier);
        }
        if (IdentifierHelper.hasIllegalCharacters(identifier)) {
            return new IdentifierResult(2, NLS.bind((String)Messages.IdentifierHelper_illegalCharacter, (Object)identifier));
        }
        return new IdentifierResult(5, NLS.bind((String)Messages.IdentifierHelper_unidentifiedMistake, (Object)identifier));
    }

    private static boolean isKeyword(String identifier) {
        String[] stringArray = IdentifierHelper.getKeywords();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String currentKeyword = stringArray[n2];
            if (identifier.equals(currentKeyword)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasIllegalCharacters(String identifier) {
        Pattern p = Pattern.compile("\\W");
        Matcher m = p.matcher(identifier);
        return m.find();
    }

    private static boolean isLeadingADigit(String identifier) {
        Pattern p = Pattern.compile("\\d.*");
        Matcher m = p.matcher(identifier);
        return m.matches();
    }

    private static boolean isCorrect(String identifier) {
        Pattern p = Pattern.compile("[a-zA-Z_]\\w*");
        Matcher m = p.matcher(identifier);
        return m.matches();
    }

    public static String[] getKeywords() {
        Set keywords = KeywordSets.getKeywords((KeywordSetKey)KeywordSetKey.KEYWORDS, (ParserLanguage)ParserLanguage.CPP);
        return keywords.toArray(new String[keywords.size()]);
    }
}

