/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractfunction;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringRunner;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.ExtractFunctionWizard;
import org.eclipse.cdt.internal.ui.refactoring.extractfunction.RefactoringsRegistry;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.IShellProvider;

public class ExtractFunctionRefactoringRunner
extends RefactoringRunner {
    public ExtractFunctionRefactoringRunner(ICElement element, ISelection selection, IShellProvider shellProvider, ICProject cProject) {
        super(element, selection, shellProvider, cProject);
    }

    @Override
    public void run() {
        ILanguage language = null;
        IFile resource = (IFile)this.element.getAdapter(IFile.class);
        if (resource != null && resource.getType() == 1) {
            try {
                language = LanguageManager.getInstance().getLanguageForFile(resource, null);
            }
            catch (CoreException e1) {
                CUIPlugin.log(e1);
            }
        }
        try {
            ExtractFunctionRefactoring refactoring = (ExtractFunctionRefactoring)RefactoringsRegistry.getLanguageDelegate(language, "extractFunction");
            if (refactoring != null) {
                refactoring.init(this.element, this.selection, this.project);
                ExtractFunctionWizard wizard = new ExtractFunctionWizard(refactoring);
                this.run(wizard, refactoring, 4);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
    }
}

