/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.extractconstant;

import org.eclipse.cdt.internal.ui.refactoring.MethodContext;
import org.eclipse.cdt.internal.ui.refactoring.dialogs.NameAndVisibilityComposite;
import org.eclipse.cdt.internal.ui.refactoring.extractconstant.ExtractConstantInfo;
import org.eclipse.cdt.internal.ui.refactoring.extractconstant.ExtractConstantRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.extractconstant.Messages;
import org.eclipse.cdt.internal.ui.refactoring.utils.IdentifierHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.IdentifierResult;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class InputPage
extends UserInputWizardPage {
    private static final String PAGE_NAME = "InputPage";
    protected ExtractConstantInfo info;
    protected NameAndVisibilityComposite control;
    private boolean showVisibilityPane;

    public InputPage() {
        super(PAGE_NAME);
    }

    public void createControl(Composite parent) {
        this.info = ((ExtractConstantRefactoring)this.getRefactoring()).getRefactoringInfo();
        this.showVisibilityPane = this.info.getMethodContext().getType() == MethodContext.ContextType.METHOD;
        this.control = new NameAndVisibilityComposite(parent, Messages.InputPage_ConstName, this.info.getName());
        this.setTitle(this.getName());
        this.setPageComplete(false);
        this.control.getConstantNameText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputPage.this.info.setName(InputPage.this.control.getConstantNameText().getText());
                InputPage.this.checkName();
            }
        });
        Control[] controlArray = this.control.getVisibiltyGroup().getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control buttons = controlArray[n2];
            buttons.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    String text = ((Button)e.getSource()).getText();
                    InputPage.this.visibilityChange(text);
                }
            });
            ++n2;
        }
        this.checkName();
        this.control.getVisibiltyGroup().setVisible(this.showVisibilityPane);
        this.setControl((Control)this.control);
    }

    private void checkName() {
        String methodName = this.control.getConstantNameText().getText();
        IdentifierResult result = IdentifierHelper.checkIdentifierName(methodName);
        if (result.isCorrect()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
            this.verifyName(methodName);
        } else {
            this.setErrorMessage(result.getMessage());
            this.setPageComplete(false);
        }
    }

    private void verifyName(String name) {
        if (this.info.getUsedNames().contains(name)) {
            this.setErrorMessage(NLS.bind((String)Messages.InputPage_NameAlreadyDefined, (Object)name));
            this.setPageComplete(false);
        }
    }

    private void visibilityChange(String visibilityText) {
        this.info.setVisibility(VisibilityEnum.getEnumForStringRepresentation(visibilityText));
    }
}

