/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.preferences.TodoTaskConfigurationBlock;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TodoTaskInputDialog
extends StatusDialog {
    private final StringDialogField fNameDialogField;
    private final ComboDialogField fPriorityDialogField;
    private final List<String> fExistingNames;

    public TodoTaskInputDialog(Shell parent, TodoTaskConfigurationBlock.TodoTask task, List<TodoTaskConfigurationBlock.TodoTask> existingEntries) {
        super(parent);
        this.fExistingNames = new ArrayList<String>(existingEntries.size());
        int i = 0;
        while (i < existingEntries.size()) {
            TodoTaskConfigurationBlock.TodoTask curr = existingEntries.get(i);
            if (!curr.equals(task)) {
                this.fExistingNames.add(curr.name);
            }
            ++i;
        }
        if (task == null) {
            this.setTitle(PreferencesMessages.TodoTaskInputDialog_new_title);
        } else {
            this.setTitle(PreferencesMessages.TodoTaskInputDialog_edit_title);
        }
        CompilerTodoTaskInputAdapter adapter = new CompilerTodoTaskInputAdapter();
        this.fNameDialogField = new StringDialogField();
        this.fNameDialogField.setLabelText(PreferencesMessages.TodoTaskInputDialog_name_label);
        this.fNameDialogField.setDialogFieldListener(adapter);
        this.fNameDialogField.setText(task != null ? task.name : "");
        String[] items = new String[]{PreferencesMessages.TodoTaskInputDialog_priority_high, PreferencesMessages.TodoTaskInputDialog_priority_normal, PreferencesMessages.TodoTaskInputDialog_priority_low};
        this.fPriorityDialogField = new ComboDialogField(8);
        this.fPriorityDialogField.setLabelText(PreferencesMessages.TodoTaskInputDialog_priority_label);
        this.fPriorityDialogField.setItems(items);
        if (task != null) {
            if ("high".equals(task.priority)) {
                this.fPriorityDialogField.selectItem(0);
            } else if ("normal".equals(task.priority)) {
                this.fPriorityDialogField.selectItem(1);
            } else {
                this.fPriorityDialogField.selectItem(2);
            }
        } else {
            this.fPriorityDialogField.selectItem(1);
        }
    }

    public TodoTaskConfigurationBlock.TodoTask getResult() {
        TodoTaskConfigurationBlock.TodoTask task = new TodoTaskConfigurationBlock.TodoTask();
        task.name = this.fNameDialogField.getText().trim();
        switch (this.fPriorityDialogField.getSelectionIndex()) {
            case 0: {
                task.priority = "high";
                break;
            }
            case 1: {
                task.priority = "normal";
                break;
            }
            default: {
                task.priority = "low";
            }
        }
        return task;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        this.fNameDialogField.doFillIntoGrid(inner, 2);
        this.fPriorityDialogField.doFillIntoGrid(inner, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameDialogField.getTextControl(null), true);
        LayoutUtil.setWidthHint((Control)this.fNameDialogField.getTextControl(null), this.convertWidthInCharsToPixels(45));
        this.fNameDialogField.postSetFocusOnDialogField(parent.getDisplay());
        TodoTaskInputDialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.todo_task_input_dialog_context");
        return composite;
    }

    private void doValidation() {
        StatusInfo status = new StatusInfo();
        String newText = this.fNameDialogField.getText();
        if (newText.length() == 0) {
            status.setError(PreferencesMessages.TodoTaskInputDialog_error_enterName);
        } else if (newText.indexOf(44) != -1) {
            status.setError(PreferencesMessages.TodoTaskInputDialog_error_comma);
        } else if (this.fExistingNames.contains(newText)) {
            status.setError(PreferencesMessages.TodoTaskInputDialog_error_entryExists);
        } else if (Character.isWhitespace(newText.charAt(0)) || Character.isWhitespace(newText.charAt(newText.length() - 1))) {
            status.setError(PreferencesMessages.TodoTaskInputDialog_error_noSpace);
        }
        this.updateStatus(status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.cdt.ui.todo_task_input_dialog_context");
    }

    private class CompilerTodoTaskInputAdapter
    implements IDialogFieldListener {
        private CompilerTodoTaskInputAdapter() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            TodoTaskInputDialog.this.doValidation();
        }
    }
}

