/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.help;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.internal.ui.help.CHelpBook;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.ICHelpProvider;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CHelpProvider
implements ICHelpProvider {
    private static final String EXTENSION_POINT_ID = "org.eclipse.cdt.ui.HelpInfo";
    private static final String ELEMENT_NAME = "helpInfo";
    private static final String ATTRIB_FILE = "file";
    private static final String NODE_HEAD = "documentation";
    private static final String NODE_BOOK = "helpBook";
    private boolean Done = false;
    ICHelpBook[] hbs = null;

    @Override
    public ICHelpBook[] getCHelpBooks() {
        this.waitForDone();
        return this.hbs;
    }

    @Override
    public IFunctionSummary getFunctionInfo(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String name) {
        int i = 0;
        while (i < helpBooks.length) {
            IFunctionSummary fs;
            if (helpBooks[i] instanceof CHelpBook && (fs = ((CHelpBook)helpBooks[i]).getFunctionInfo(context, name)) != null) {
                return fs;
            }
            ++i;
        }
        return null;
    }

    @Override
    public ICHelpResourceDescriptor[] getHelpResources(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String name) {
        ArrayList<ICHelpResourceDescriptor> lst = new ArrayList<ICHelpResourceDescriptor>();
        ICHelpBook[] iCHelpBookArray = helpBooks;
        int n = helpBooks.length;
        int n2 = 0;
        while (n2 < n) {
            ICHelpResourceDescriptor hrd;
            ICHelpBook h = iCHelpBookArray[n2];
            if (h instanceof CHelpBook && (hrd = ((CHelpBook)h).getHelpResources(context, name)) != null) {
                lst.add(hrd);
            }
            ++n2;
        }
        if (lst.size() > 0) {
            return lst.toArray(new ICHelpResourceDescriptor[lst.size()]);
        }
        return null;
    }

    @Override
    public IFunctionSummary[] getMatchingFunctions(ICHelpInvocationContext context, ICHelpBook[] helpBooks, String prefix) {
        ArrayList<IFunctionSummary> lst = new ArrayList<IFunctionSummary>();
        int i = 0;
        while (i < helpBooks.length) {
            List<IFunctionSummary> fs;
            if (helpBooks[i] instanceof CHelpBook && (fs = ((CHelpBook)helpBooks[i]).getMatchingFunctions(context, prefix)) != null) {
                lst.addAll(fs);
            }
            ++i;
        }
        if (lst.size() > 0) {
            return lst.toArray(new IFunctionSummary[lst.size()]);
        }
        return null;
    }

    @Override
    public void initialize() {
        this.loadExtensions();
    }

    /*
     * Exception decompiling
     */
    private void waitForDone() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadExtensions() {
        try {
            IExtension[] extensions;
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
            if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
                ArrayList<ICHelpBook> chbl = new ArrayList<ICHelpBook>();
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension ex = iExtensionArray[n2];
                    String pluginId = ex.getNamespaceIdentifier();
                    IConfigurationElement[] iConfigurationElementArray = ex.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement el = iConfigurationElementArray[n4];
                        if (el.getName().equals(ELEMENT_NAME)) {
                            this.loadFile(el, chbl, pluginId);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                if (chbl.size() > 0) {
                    this.hbs = chbl.toArray(new ICHelpBook[chbl.size()]);
                }
            }
        }
        finally {
            this.Done = true;
        }
    }

    private void loadFile(IConfigurationElement el, ArrayList<ICHelpBook> chbl, String pluginId) {
        String fname = el.getAttribute(ATTRIB_FILE);
        if (fname == null || fname.trim().length() == 0) {
            return;
        }
        URL x = FileLocator.find((Bundle)Platform.getBundle((String)pluginId), (IPath)new Path(fname), null);
        if (x == null) {
            return;
        }
        try {
            x = FileLocator.toFileURL((URL)x);
        }
        catch (IOException iOException) {
            return;
        }
        fname = x.getPath();
        if (fname == null || fname.trim().length() == 0) {
            return;
        }
        Document doc = null;
        try {
            FileInputStream stream = new FileInputStream(fname);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            InputSource src = new InputSource(reader);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = builder.parse(src);
            Element e = doc.getDocumentElement();
            if (NODE_HEAD.equals(e.getNodeName())) {
                NodeList list = e.getChildNodes();
                int j = 0;
                while (j < list.getLength()) {
                    Node node = list.item(j);
                    if (node.getNodeType() == 1 && NODE_BOOK.equals(node.getNodeName())) {
                        chbl.add(new CHelpBook((Element)node));
                    }
                    ++j;
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
    }
}

