/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.ui.callhierarchy.CHContentProvider;
import org.eclipse.cdt.internal.ui.callhierarchy.CHNode;
import org.eclipse.cdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.cdt.internal.ui.callhierarchy.CalledByResult;
import org.eclipse.cdt.internal.ui.callhierarchy.CallsToResult;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class CHQueries {
    private static final CHNode[] EMPTY_NODES = new CHNode[0];

    private CHQueries() {
    }

    public static CHNode[] findCalledBy(CHContentProvider cp, CHNode node, IIndex index, IProgressMonitor pm) throws CoreException {
        CalledByResult result = new CalledByResult();
        ICElement callee = node.getRepresentedDeclaration();
        if (!(callee instanceof ISourceReference)) {
            return EMPTY_NODES;
        }
        boolean done = false;
        int linkageID = node.getLinkageID();
        if (linkageID == -1) {
            ITranslationUnit tu = ((ISourceReference)callee).getTranslationUnit();
            if (tu == null) {
                return EMPTY_NODES;
            }
            String ct = tu.getContentTypeId();
            if (ct.equals("org.eclipse.cdt.core.cxxHeader")) {
                CHQueries.findCalledBy(callee, 2, index, result);
                CHQueries.findCalledBy(callee, 1, index, result);
                done = true;
            }
        }
        if (!done) {
            CHQueries.findCalledBy(callee, linkageID, index, result);
        }
        return cp.createNodes(node, result);
    }

    private static void findCalledBy(ICElement callee, int linkageID, IIndex index, CalledByResult result) throws CoreException {
        ICProject project = callee.getCProject();
        IIndexBinding calleeBinding = IndexUI.elementToBinding(index, callee, linkageID);
        if (calleeBinding != null) {
            CHQueries.findCalledBy1(index, (IBinding)calleeBinding, true, project, result);
            if (calleeBinding instanceof ICPPMethod) {
                ICPPMethod[] overriddenBindings;
                ICPPMethod[] iCPPMethodArray = overriddenBindings = ClassTypeHelper.findOverridden((ICPPMethod)((ICPPMethod)calleeBinding), null);
                int n = overriddenBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPMethod overriddenBinding = iCPPMethodArray[n2];
                    CHQueries.findCalledBy1(index, (IBinding)overriddenBinding, false, project, result);
                    ++n2;
                }
            }
        }
    }

    private static void findCalledBy1(IIndex index, IBinding callee, boolean includeOrdinaryCalls, ICProject project, CalledByResult result) throws CoreException {
        CHQueries.findCalledBy2(index, callee, includeOrdinaryCalls, project, result);
        List<? extends IBinding> specializations = IndexUI.findSpecializations(index, callee);
        for (IBinding iBinding : specializations) {
            CHQueries.findCalledBy2(index, iBinding, includeOrdinaryCalls, project, result);
        }
    }

    private static void findCalledBy2(IIndex index, IBinding callee, boolean includeOrdinaryCalls, ICProject project, CalledByResult result) throws CoreException {
        IIndexName[] names;
        IIndexName[] iIndexNameArray = names = index.findNames(callee, 12);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            ICElementHandle elem;
            IIndexName caller;
            IIndexName rname = iIndexNameArray[n2];
            if ((includeOrdinaryCalls || rname.couldBePolymorphicMethodCall()) && (caller = rname.getEnclosingDefinition()) != null && (elem = IndexUI.getCElementForName(project, index, caller)) != null) {
                result.add((ICElement)elem, rname);
            }
            ++n2;
        }
    }

    public static CHNode[] findCalls(CHContentProvider cp, CHNode node, IIndex index, IProgressMonitor pm) throws CoreException {
        ICElement caller = node.getRepresentedDeclaration();
        CallsToResult result = new CallsToResult();
        IIndexName callerName = IndexUI.elementToName(index, caller);
        if (callerName != null) {
            IIndexName[] refs;
            IIndexName[] iIndexNameArray = refs = callerName.getEnclosedNames();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexName name = iIndexNameArray[n2];
                IIndexBinding binding = index.findBinding((IName)name);
                if (CallHierarchyUI.isRelevantForCallHierarchy((IBinding)binding)) {
                    do {
                        ICElement[] defs = null;
                        if (binding instanceof ICPPMethod && name.couldBePolymorphicMethodCall()) {
                            defs = CHQueries.findOverriders(index, (ICPPMethod)binding);
                        }
                        if (defs == null) {
                            defs = IndexUI.findRepresentative(index, (IBinding)binding);
                        }
                        if (defs == null || defs.length <= 0) continue;
                        result.add(defs, name);
                        break;
                    } while (binding instanceof ICPPSpecialization && (binding = ((ICPPSpecialization)binding).getSpecializedBinding()) != null);
                }
                ++n2;
            }
        }
        return cp.createNodes(node, result);
    }

    static ICElement[] findOverriders(IIndex index, ICPPMethod binding) throws CoreException {
        ICPPMethod[] virtualOverriders = ClassTypeHelper.findOverriders((IIndex)index, (ICPPMethod)binding);
        if (virtualOverriders.length > 0) {
            ArrayList<ICElementHandle> list = new ArrayList<ICElementHandle>();
            list.addAll(Arrays.asList(IndexUI.findRepresentative(index, (IBinding)binding)));
            ICPPMethod[] iCPPMethodArray = virtualOverriders;
            int n = virtualOverriders.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod overrider = iCPPMethodArray[n2];
                list.addAll(Arrays.asList(IndexUI.findRepresentative(index, (IBinding)overrider)));
                ++n2;
            }
            return list.toArray(new ICElement[list.size()]);
        }
        return null;
    }
}

