/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.css;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.CSSContext;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.AbstractLengthManager;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.StringMap;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public class FontSizeManager
extends AbstractLengthManager {
    protected static final StringMap values = new StringMap();

    static {
        values.put("large", CSSValueConstants.LARGE_VALUE);
        values.put("larger", CSSValueConstants.LARGER_VALUE);
        values.put("medium", CSSValueConstants.MEDIUM_VALUE);
        values.put("small", CSSValueConstants.SMALL_VALUE);
        values.put("smaller", CSSValueConstants.SMALLER_VALUE);
        values.put("x-large", CSSValueConstants.X_LARGE_VALUE);
        values.put("x-small", CSSValueConstants.X_SMALL_VALUE);
        values.put("xx-large", CSSValueConstants.XX_LARGE_VALUE);
        values.put("xx-small", CSSValueConstants.XX_SMALL_VALUE);
    }

    public StringMap getIdentifiers() {
        return values;
    }

    public boolean isInheritedProperty() {
        return true;
    }

    public String getPropertyName() {
        return "font-size";
    }

    public Value getDefaultValue() {
        return CSSValueConstants.MEDIUM_VALUE;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 12: {
                return CSSValueConstants.INHERIT_VALUE;
            }
            case 35: {
                String s = lu.getStringValue().toLowerCase().intern();
                Object v = values.get(s);
                if (v == null) {
                    throw this.createInvalidIdentifierDOMException(s);
                }
                return (Value)v;
            }
        }
        return super.createValue(lu, engine);
    }

    public CSSPrimitiveValue createStringValue(short type, String value) throws DOMException {
        if (type != 21) {
            throw this.createInvalidStringTypeDOMException(type);
        }
        Object v = values.get(value.toLowerCase().intern());
        if (v == null) {
            throw this.createInvalidIdentifierDOMException(value);
        }
        return (CSSPrimitiveValue)v;
    }

    public Value computeValue(CSSStylableElement elt, CSSEngine engine, int idx, Value value) {
        CSSContext ctx = engine.getCSSContext();
        float fs = ctx.getMediumFontSize();
        if (value == CSSValueConstants.XX_SMALL_VALUE) {
            return new FloatValue(9, fs / 1.2f / 1.2f / 1.2f);
        }
        if (value == CSSValueConstants.X_SMALL_VALUE) {
            return new FloatValue(9, fs / 1.2f / 1.2f);
        }
        if (value == CSSValueConstants.SMALL_VALUE) {
            return new FloatValue(9, fs / 1.2f);
        }
        if (value == CSSValueConstants.MEDIUM_VALUE) {
            return new FloatValue(9, fs);
        }
        if (value == CSSValueConstants.LARGE_VALUE) {
            return new FloatValue(9, fs * 1.2f);
        }
        if (value == CSSValueConstants.X_LARGE_VALUE) {
            return new FloatValue(9, fs * 1.2f * 1.2f);
        }
        if (value == CSSValueConstants.XX_LARGE_VALUE) {
            return new FloatValue(9, fs * 1.2f * 1.2f * 1.2f);
        }
        float scale = 1.0f;
        boolean doParentRelative = false;
        if (value == CSSValueConstants.SMALLER_VALUE) {
            doParentRelative = true;
            scale = 0.8333333f;
        } else if (value == CSSValueConstants.LARGER_VALUE) {
            doParentRelative = true;
            scale = 1.2f;
        } else if (value.getCssValueType() == 1) {
            switch (value.getPrimitiveType()) {
                case 3: {
                    doParentRelative = true;
                    scale = value.getFloatValue();
                    break;
                }
                case 4: {
                    doParentRelative = true;
                    scale = value.getFloatValue() * 0.5f;
                    break;
                }
                case 2: {
                    doParentRelative = true;
                    scale = value.getFloatValue() * 0.01f;
                }
            }
        }
        if (doParentRelative) {
            Value fontSize;
            IStyle style;
            CSSStylableElement parent = (CSSStylableElement)elt.getParent();
            if (parent != null && (style = parent.getComputedStyle()) != null && (fontSize = (Value)style.getProperty(39)) != null) {
                fs = fontSize.getFloatValue();
                return new FloatValue(fontSize.getPrimitiveType(), fs * scale);
            }
            return new FloatValue(9, fs * scale);
        }
        if (value.getPrimitiveType() == 1) {
            return super.computeValue(elt, engine, idx, new FloatValue(9, value.getFloatValue()));
        }
        return super.computeValue(elt, engine, idx, value);
    }
}

