/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.uitree.uiwidgets;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.ui.templateengine.event.PatternEvent;
import org.eclipse.cdt.ui.templateengine.uitree.InputUIElement;
import org.eclipse.cdt.ui.templateengine.uitree.UIAttributes;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIComposite;
import org.eclipse.cdt.utils.ui.controls.FileListControl;
import org.eclipse.cdt.utils.ui.controls.IFileListChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UIStringListWidget
extends InputUIElement {
    protected FileListControl fileListControl;
    protected Label label;
    protected List<String> itemsList = new ArrayList<String>();

    public UIStringListWidget(UIAttributes attribute) {
        super(attribute);
    }

    @Override
    public Map<String, String> getValues() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        String itemString = new String();
        int i = 0;
        while (i < this.itemsList.size()) {
            itemString = String.valueOf(itemString) + this.itemsList.get(i) + "|";
            ++i;
        }
        retMap.put((String)this.uiAttributes.get("id"), itemString);
        return retMap;
    }

    @Override
    public void setValues(Map<String, String> valueMap) {
        String items = valueMap.get(this.uiAttributes.get("id"));
        if (items != null) {
            items = items.trim();
            StringTokenizer st = new StringTokenizer(items, "|");
            while (st.hasMoreTokens()) {
                this.itemsList.add(st.nextToken());
            }
        }
    }

    @Override
    public void createWidgets(final UIComposite uiComposite) {
        GridData gridData = null;
        this.label = new Label((Composite)uiComposite, 16384);
        this.label.setText((String)this.uiAttributes.get("label"));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        gd.verticalIndent = 5;
        this.label.setLayoutData((Object)gd);
        if (this.uiAttributes.get("description") != null) {
            String tipText = (String)this.uiAttributes.get("description");
            tipText = tipText.replaceAll("\\\\r\\\\n", "\r\n");
            this.label.setToolTipText(tipText);
        }
        Composite flcComposite = new Composite((Composite)uiComposite, 0);
        gridData = new GridData(768);
        flcComposite.setLayout((Layout)new GridLayout());
        flcComposite.setLayoutData((Object)gridData);
        this.fileListControl = new FileListControl(flcComposite, (String)this.uiAttributes.get("label"), 0);
        this.fileListControl.setList(this.itemsList.toArray(new String[this.itemsList.size()]));
        this.fileListControl.setSelection(0);
        this.fileListControl.addChangeListener(new IFileListChangeListener(){

            @Override
            public void fileListChanged(FileListControl fileList, String[] oldValue, String[] newValue) {
                UIStringListWidget.this.itemsList.clear();
                UIStringListWidget.this.itemsList.addAll(Arrays.asList(newValue));
                uiComposite.firePatternEvent(UIStringListWidget.this.createPatternEvent());
            }
        });
        uiComposite.firePatternEvent(this.createPatternEvent());
    }

    protected PatternEvent createPatternEvent() {
        String msg = MessageFormat.format((String)"Please add an item to {0}", (Object[])new Object[]{this.label.getText()});
        return new PatternEvent(this, msg, this.isValid());
    }

    @Override
    public boolean isValid() {
        boolean retVal = true;
        String mandatory = (String)this.uiAttributes.get("mandatory");
        if ((this.itemsList == null || this.itemsList.size() == 0) && mandatory.equalsIgnoreCase("true")) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public void disposeWidget() {
        this.label.dispose();
        this.fileListControl = null;
    }
}

