/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCapture;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNamespaceDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTLiteralNode;
import org.eclipse.cdt.internal.ui.refactoring.Container;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.IToggleRefactoringStrategy;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.InsertionPointFinder;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleFileCreator;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleNodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleRefactoringContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEditGroup;

public class ToggleFromInHeaderToImplementationStrategy
implements IToggleRefactoringStrategy {
    private IASTTranslationUnit implAst;
    private ToggleRefactoringContext context;
    private TextEditGroup infoText = new TextEditGroup(Messages.EditGroupName);
    private ASTLiteralNode includeNode;

    public ToggleFromInHeaderToImplementationStrategy(ToggleRefactoringContext context) {
        this.context = context;
    }

    @Override
    public void run(ModificationCollector collector) throws CoreException {
        if (!this.newFileCheck()) {
            return;
        }
        ICPPASTFunctionDefinition newDefinition = this.getNewDefinition();
        if (this.context.getDeclaration() != null) {
            this.removeDefinitionFromHeader(collector);
        } else {
            this.replaceDefinitionWithDeclaration(collector);
        }
        ASTRewrite implRewrite = collector.rewriterForTranslationUnit(this.implAst);
        if (this.includeNode != null) {
            implRewrite.insertBefore((IASTNode)this.implAst, null, (IASTNode)this.includeNode, this.infoText);
        }
        IASTTranslationUnit insertionParent = null;
        ICPPASTNamespaceDefinition parent = this.getParentNamespace();
        if (parent != null) {
            this.adaptQualifiedNameToNamespaceLevel((IASTFunctionDefinition)newDefinition, (IASTNode)parent);
            insertionParent = this.searchNamespaceInImplementation(parent.getName());
            if (insertionParent == null) {
                insertionParent = this.createNamespace(parent);
                implRewrite = implRewrite.insertBefore((IASTNode)this.implAst.getTranslationUnit(), null, (IASTNode)insertionParent, this.infoText);
            }
        } else {
            insertionParent = this.implAst.getTranslationUnit();
        }
        newDefinition.setParent((IASTNode)insertionParent);
        IASTNode insertionPoint = this.findInsertionPoint((IASTNode)insertionParent, this.context.getDeclarationAST());
        ASTRewrite newRewriter = implRewrite.insertBefore((IASTNode)insertionParent, insertionPoint, (IASTNode)newDefinition, this.infoText);
        this.copyCommentsToNewFile(newDefinition, newRewriter, collector.rewriterForTranslationUnit(this.context.getDefinitionAST()));
        this.restoreLeadingComments(newDefinition, newRewriter, collector);
    }

    private void copyCommentsToNewFile(ICPPASTFunctionDefinition newDefinition, final ASTRewrite newRewriter, final ASTRewrite oldRewriter) {
        newDefinition.accept(new ASTVisitor(true){

            public int visit(IASTName name) {
                this.copy((IASTNode)name);
                return super.visit(name);
            }

            public int visit(IASTDeclaration declaration) {
                this.copy((IASTNode)declaration);
                return super.visit(declaration);
            }

            public int visit(IASTInitializer initializer) {
                this.copy((IASTNode)initializer);
                return super.visit(initializer);
            }

            public int visit(IASTParameterDeclaration parameterDeclaration) {
                this.copy((IASTNode)parameterDeclaration);
                return super.visit(parameterDeclaration);
            }

            public int visit(IASTDeclarator declarator) {
                this.copy((IASTNode)declarator);
                return super.visit(declarator);
            }

            public int visit(IASTDeclSpecifier declSpec) {
                this.copy((IASTNode)declSpec);
                return super.visit(declSpec);
            }

            public int visit(IASTArrayModifier arrayModifier) {
                this.copy((IASTNode)arrayModifier);
                return super.visit(arrayModifier);
            }

            public int visit(IASTPointerOperator ptrOperator) {
                this.copy((IASTNode)ptrOperator);
                return super.visit(ptrOperator);
            }

            public int visit(IASTExpression expression) {
                this.copy((IASTNode)expression);
                return super.visit(expression);
            }

            public int visit(IASTStatement statement) {
                this.copy((IASTNode)statement);
                return super.visit(statement);
            }

            public int visit(IASTTypeId typeId) {
                this.copy((IASTNode)typeId);
                return super.visit(typeId);
            }

            public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
                this.copy((IASTNode)enumerator);
                return super.visit(enumerator);
            }

            public int visit(IASTProblem problem) {
                this.copy((IASTNode)problem);
                return super.visit(problem);
            }

            public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier) {
                this.copy((IASTNode)baseSpecifier);
                return super.visit(baseSpecifier);
            }

            public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
                this.copy((IASTNode)namespaceDefinition);
                return super.visit(namespaceDefinition);
            }

            public int visit(ICPPASTTemplateParameter templateParameter) {
                this.copy((IASTNode)templateParameter);
                return super.visit(templateParameter);
            }

            public int visit(ICPPASTCapture capture) {
                this.copy((IASTNode)capture);
                return super.visit(capture);
            }

            public int visit(ICASTDesignator designator) {
                this.copy((IASTNode)designator);
                return super.visit(designator);
            }

            private void copy(IASTNode node) {
                this.copyComments(node, newRewriter, oldRewriter, ASTRewrite.CommentPosition.leading);
                this.copyComments(node, newRewriter, oldRewriter, ASTRewrite.CommentPosition.trailing);
                this.copyComments(node, newRewriter, oldRewriter, ASTRewrite.CommentPosition.freestanding);
            }

            private void copyComments(IASTNode node, ASTRewrite newRewriter2, ASTRewrite oldRewriter2, ASTRewrite.CommentPosition pos) {
                IASTNode originalNode = node.getOriginalNode();
                if (originalNode != node) {
                    List comments = oldRewriter2.getComments(originalNode, pos);
                    for (IASTComment comment : comments) {
                        newRewriter2.addComment(node, comment, pos);
                    }
                }
            }
        });
    }

    private boolean newFileCheck() throws CoreException {
        this.implAst = this.context.getASTForPartnerFile();
        if (this.implAst == null) {
            ToggleFileCreator fileCreator = new ToggleFileCreator(this.context, ".cpp");
            if (fileCreator.askUserForFileCreation(this.context)) {
                IFile file = fileCreator.createNewFile();
                this.implAst = this.context.getAST(file, null);
                this.includeNode = new ASTLiteralNode(fileCreator.getIncludeStatement());
                return true;
            }
            return false;
        }
        return true;
    }

    private ICPPASTNamespaceDefinition getParentNamespace() {
        IASTFunctionDeclarator toquery = this.context.getDeclaration();
        if (toquery == null) {
            toquery = this.context.getDefinition();
        }
        return (ICPPASTNamespaceDefinition)CPPVisitor.findAncestorWithType((IASTNode)toquery, ICPPASTNamespaceDefinition.class);
    }

    private IASTNode findInsertionPoint(IASTNode insertionParent, IASTTranslationUnit unit) {
        IASTFunctionDeclarator declarator = this.context.getDeclaration();
        if (unit == null) {
            unit = this.context.getDefinitionAST();
        }
        if (declarator == null) {
            declarator = this.context.getDefinition().getDeclarator();
        }
        IASTDeclaration insertion_point = InsertionPointFinder.findInsertionPoint(unit, insertionParent.getTranslationUnit(), declarator);
        return insertion_point;
    }

    private void restoreLeadingComments(ICPPASTFunctionDefinition newDefinition, ASTRewrite newRewriter, ModificationCollector collector) {
        ASTRewrite rw = collector.rewriterForTranslationUnit(this.context.getDefinitionAST());
        List comments = rw.getComments((IASTNode)this.context.getDefinition(), ASTRewrite.CommentPosition.leading);
        if (comments != null) {
            for (IASTComment comment : comments) {
                newRewriter.addComment((IASTNode)newDefinition, comment, ASTRewrite.CommentPosition.leading);
                if (this.context.getDeclaration() == null) continue;
                rw.remove((IASTNode)comment, this.infoText);
            }
        }
    }

    private void replaceDefinitionWithDeclaration(ModificationCollector collector) {
        IASTSimpleDeclaration newdeclarator = ToggleNodeHelper.createDeclarationFromDefinition(this.context.getDefinition());
        ASTRewrite rewrite = collector.rewriterForTranslationUnit(this.context.getDefinitionAST());
        rewrite.replace((IASTNode)this.context.getDefinition(), (IASTNode)newdeclarator, this.infoText);
    }

    private ICPPASTFunctionDefinition getNewDefinition() {
        ICPPASTFunctionDefinition newDefinition = ToggleNodeHelper.createFunctionSignatureWithEmptyBody(this.context.getDefinition().getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations), this.context.getDefinition().getDeclarator().copy(IASTNode.CopyStyle.withLocations), this.context.getDefinition().copy(IASTNode.CopyStyle.withLocations));
        newDefinition.getDeclSpecifier().setInline(false);
        newDefinition.setBody(this.context.getDefinition().getBody().copy(IASTNode.CopyStyle.withLocations));
        if (newDefinition instanceof ICPPASTFunctionWithTryBlock) {
            ICPPASTFunctionWithTryBlock newTryFun = (ICPPASTFunctionWithTryBlock)newDefinition;
            ICPPASTFunctionWithTryBlock oldTryFun = (ICPPASTFunctionWithTryBlock)this.context.getDefinition();
            ICPPASTCatchHandler[] iCPPASTCatchHandlerArray = oldTryFun.getCatchHandlers();
            int n = iCPPASTCatchHandlerArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTCatchHandler catchHandler = iCPPASTCatchHandlerArray[n2];
                newTryFun.addCatchHandler(catchHandler.copy(IASTNode.CopyStyle.withLocations));
                ++n2;
            }
        }
        return newDefinition;
    }

    private void adaptQualifiedNameToNamespaceLevel(IASTFunctionDefinition new_definition, IASTNode parent) {
        if (parent instanceof ICPPASTNamespaceDefinition) {
            ICPPASTNamespaceDefinition ns = (ICPPASTNamespaceDefinition)parent;
            if (new_definition.getDeclarator().getName() instanceof ICPPASTQualifiedName) {
                ICPPASTQualifiedName qname = (ICPPASTQualifiedName)new_definition.getDeclarator().getName();
                CPPASTQualifiedName qname_new = new CPPASTQualifiedName();
                boolean start = false;
                IASTName[] iASTNameArray = qname.getNames();
                int n = iASTNameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTName partname = iASTNameArray[n2];
                    if (partname.toString().equals(ns.getName().toString())) {
                        start = true;
                    } else if (start) {
                        qname_new.addName(partname);
                    }
                    ++n2;
                }
                if (start) {
                    new_definition.getDeclarator().setName((IASTName)qname_new);
                }
            }
        }
    }

    private CPPASTNamespaceDefinition createNamespace(ICPPASTNamespaceDefinition parent_namespace) {
        CPPASTNamespaceDefinition insertionParent = new CPPASTNamespaceDefinition(parent_namespace.getName().copy(IASTNode.CopyStyle.withLocations));
        insertionParent.setParent((IASTNode)this.implAst);
        return insertionParent;
    }

    private void removeDefinitionFromHeader(ModificationCollector collector) {
        ASTRewrite header_rewrite = collector.rewriterForTranslationUnit(this.context.getDefinitionAST());
        header_rewrite.remove(ToggleNodeHelper.getParentRemovePoint(this.context.getDefinition()), this.infoText);
    }

    private IASTNode searchNamespaceInImplementation(final IASTName name) {
        final Container result = new Container();
        this.implAst.accept(new ASTVisitor(){
            {
                this.shouldVisitNamespaces = true;
            }

            public int visit(ICPPASTNamespaceDefinition namespaceDefinition) {
                if (name.toString().equals(namespaceDefinition.getName().toString())) {
                    result.setObject(namespaceDefinition);
                    return 2;
                }
                return super.visit(namespaceDefinition);
            }
        });
        return (IASTNode)result.getObject();
    }
}

