/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.language.settings.providers;

import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.ui.ImageCombo;
import org.eclipse.cdt.internal.ui.newui.LanguageSettingsImages;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.AbstractPropertyDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LanguageSettingEntryDialog
extends AbstractPropertyDialog {
    private static final String SLASH = "/";
    private ICConfigurationDescription cfgDescription;
    private IProject project;
    private ICLanguageSettingEntry entry;
    private boolean clearValue;
    private int kind;
    private Composite compositeArea;
    private Label iconComboKind;
    private ImageCombo comboKind;
    private ImageCombo comboPathCategory;
    private Label labelInput;
    public Text inputName;
    private Label checkBoxValue;
    public Text inputValue;
    private Button buttonBrowse;
    private Button buttonVars;
    private Button checkBoxBuiltIn;
    private Button checkBoxSystem;
    private Button checkBoxFramework;
    private Button buttonOk;
    private Button buttonCancel;
    private static final int COMBO_INDEX_INCLUDE_DIR = 0;
    private static final int COMBO_INDEX_MACRO = 1;
    private static final int COMBO_INDEX_INCLUDE_FILE = 2;
    private static final int COMBO_INDEX_MACRO_FILE = 3;
    private static final int COMBO_INDEX_LIBRARY_DIR = 4;
    private static final int COMBO_INDEX_LIBRARY_FILE = 5;
    private final String[] comboKindItems = new String[]{Messages.LanguageSettingEntryDialog_IncludeDirectory, Messages.LanguageSettingEntryDialog_PreporocessorMacro, Messages.LanguageSettingEntryDialog_IncludeFile, Messages.LanguageSettingEntryDialog_PreprocessorMacroFile, Messages.LanguageSettingEntryDialog_LibraryPath, Messages.LanguageSettingEntryDialog_Library};
    private final Image[] comboKindImages = new Image[]{CDTSharedImages.getImage("icons/obj16/hfolder_obj.gif"), CDTSharedImages.getImage("icons/obj16/define_obj.gif"), CDTSharedImages.getImage("icons/obj16/h_file_obj.gif"), CDTSharedImages.getImage("icons/obj16/macros_file.gif"), CDTSharedImages.getImage("icons/obj16/fldr_lib_obj.gif"), CDTSharedImages.getImage("icons/obj16/lib_obj.gif")};
    private static final int COMBO_PATH_INDEX_PROJECT = 0;
    private static final int COMBO_PATH_INDEX_WORKSPACE = 1;
    private static final int COMBO_PATH_INDEX_FILESYSTEM = 2;
    private final String[] pathCategories = new String[]{Messages.LanguageSettingEntryDialog_ProjectPath, Messages.LanguageSettingEntryDialog_WorkspacePath, Messages.LanguageSettingEntryDialog_Filesystem};
    private final Image[] pathCategoryImages = new Image[]{CDTSharedImages.getImage("icons/etool16/prj_obj.gif"), CDTSharedImages.getImage("icons/obj16/workspace.gif"), CDTSharedImages.getImage("icons/obj16/filesyst.gif")};
    private ICLanguageSettingEntry[] entries;

    public LanguageSettingEntryDialog(Shell parent, ICConfigurationDescription cfgDescription, int kind) {
        super(parent, "");
        this.cfgDescription = cfgDescription;
        this.project = cfgDescription.getProjectDescription().getProject();
        this.entry = null;
        this.clearValue = true;
        this.kind = kind;
    }

    public LanguageSettingEntryDialog(Shell parent, ICConfigurationDescription cfgDescription, ICLanguageSettingEntry entry, boolean clearValue) {
        super(parent, "");
        this.cfgDescription = cfgDescription;
        this.project = cfgDescription.getProjectDescription().getProject();
        this.entry = entry;
        this.kind = entry != null ? entry.getKind() : 1;
        this.clearValue = clearValue;
    }

    public LanguageSettingEntryDialog(Shell parent, ICConfigurationDescription cfgDescription, ICLanguageSettingEntry entry) {
        this(parent, cfgDescription, entry, false);
    }

    private int comboIndexToKind(int index) {
        int kind = 0;
        switch (index) {
            case 0: {
                kind = 1;
                break;
            }
            case 1: {
                kind = 4;
                break;
            }
            case 2: {
                kind = 2;
                break;
            }
            case 3: {
                kind = 8;
                break;
            }
            case 4: {
                kind = 16;
                break;
            }
            case 5: {
                kind = 32;
            }
        }
        return kind;
    }

    private int kindToComboIndex(int kind) {
        int index = 0;
        switch (kind) {
            case 1: {
                index = 0;
                break;
            }
            case 4: {
                index = 1;
                break;
            }
            case 2: {
                index = 2;
                break;
            }
            case 8: {
                index = 3;
                break;
            }
            case 16: {
                index = 4;
                break;
            }
            case 32: {
                index = 5;
            }
        }
        return index;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(4, false));
        this.compositeArea = new Composite(parent, 0);
        GridData gd = new GridData(768);
        gd.verticalAlignment = 128;
        gd.horizontalSpan = 7;
        this.compositeArea.setLayoutData((Object)gd);
        this.compositeArea.setLayout((Layout)new GridLayout(7, false));
        this.iconComboKind = new Label(this.compositeArea, 0);
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 131072;
        this.iconComboKind.setLayoutData((Object)gd);
        this.iconComboKind.setText(Messages.LanguageSettingEntryDialog_SelectKind);
        int kindToComboIndex = this.kindToComboIndex(this.kind);
        this.iconComboKind.setImage(this.comboKindImages[kindToComboIndex]);
        this.comboKind = new ImageCombo(this.compositeArea, 2060);
        int i = 0;
        while (i < this.comboKindItems.length) {
            this.comboKind.add(this.comboKindItems[i], this.comboKindImages[i]);
            ++i;
        }
        this.comboKind.setText(this.comboKindItems[kindToComboIndex]);
        this.comboKind.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LanguageSettingEntryDialog.this.updateImages();
                LanguageSettingEntryDialog.this.setButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.comboKind.setEnabled(this.clearValue);
        Label comboPathCategoryIcon = new Label(this.compositeArea, 0);
        gd = new GridData(640);
        gd.verticalAlignment = 128;
        gd.widthHint = 15;
        comboPathCategoryIcon.setLayoutData((Object)gd);
        comboPathCategoryIcon.setText("");
        this.comboPathCategory = new ImageCombo(this.compositeArea, 2060);
        int i2 = 0;
        while (i2 < this.pathCategories.length) {
            this.comboPathCategory.add(this.pathCategories[i2], this.pathCategoryImages[i2]);
            ++i2;
        }
        int pcindex = 0;
        if (this.entry != null) {
            pcindex = (this.entry.getFlags() & 8) == 0 ? 2 : (this.entry.getName().startsWith(SLASH) ? 1 : 0);
        }
        this.comboPathCategory.setText(this.pathCategories[pcindex]);
        gd = new GridData(4, 0, false, false);
        gd.verticalAlignment = 128;
        gd.horizontalSpan = 4;
        this.comboPathCategory.setLayoutData(gd);
        this.comboPathCategory.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LanguageSettingEntryDialog.this.updateImages();
                LanguageSettingEntryDialog.this.setButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.labelInput = new Label(this.compositeArea, 0);
        this.labelInput.setText(Messages.LanguageSettingEntryDialog_Directory);
        gd = new GridData();
        this.labelInput.setLayoutData((Object)gd);
        this.inputName = new Text(this.compositeArea, 2052);
        if (this.entry != null && !this.clearValue) {
            this.inputName.setText(this.entry.getName());
        }
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.inputName.setLayoutData((Object)gd);
        this.inputName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LanguageSettingEntryDialog.this.setButtons();
            }
        });
        this.inputName.setFocus();
        this.inputName.setSelection(0, this.inputName.getText().length());
        this.checkBoxValue = new Label(this.compositeArea, 0);
        this.checkBoxValue.setText(Messages.LanguageSettingEntryDialog_Value);
        gd = new GridData();
        this.checkBoxValue.setLayoutData((Object)gd);
        this.buttonBrowse = new Button(this.compositeArea, 8);
        this.buttonBrowse.setText("...");
        this.buttonBrowse.setImage(this.pathCategoryImages[0]);
        this.buttonBrowse.setLayoutData((Object)new GridData());
        this.buttonBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LanguageSettingEntryDialog.this.buttonPressed(event);
            }
        });
        this.buttonVars = new Button(this.compositeArea, 8);
        this.buttonVars.setText(AbstractCPropertyTab.VARIABLESBUTTON_NAME);
        this.buttonVars.setLayoutData((Object)new GridData());
        this.buttonVars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LanguageSettingEntryDialog.this.buttonPressed(event);
            }
        });
        int comboPathWidth = this.comboPathCategory.computeSize((int)-1, (int)0).x;
        this.inputValue = new Text(this.compositeArea, 2052);
        if (this.entry != null && !this.clearValue) {
            this.inputValue.setText(this.entry.getValue());
        }
        gd = new GridData(4, 0, false, false);
        gd.widthHint = comboPathWidth;
        this.inputValue.setLayoutData((Object)gd);
        if (this.entry != null && this.kind == 4 && !this.clearValue) {
            this.inputValue.setFocus();
            this.inputValue.setSelection(0, this.inputValue.getText().length());
        }
        Composite compCheckboxes = new Composite(parent, 0);
        gd = new GridData(768);
        gd.verticalAlignment = 128;
        gd.horizontalSpan = 4;
        compCheckboxes.setLayoutData((Object)gd);
        compCheckboxes.setLayout((Layout)new GridLayout(1, false));
        this.checkBoxBuiltIn = new Button(compCheckboxes, 32);
        this.checkBoxBuiltIn.setText(Messages.LanguageSettingEntryDialog_BuiltInFlag);
        this.checkBoxBuiltIn.setSelection(this.entry != null && (this.entry.getFlags() & 1) != 0);
        gd = new GridData(768);
        this.checkBoxBuiltIn.setLayoutData((Object)gd);
        this.checkBoxBuiltIn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LanguageSettingEntryDialog.this.updateImages();
                LanguageSettingEntryDialog.this.setButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.checkBoxSystem = new Button(compCheckboxes, 32);
        this.checkBoxSystem.setText(Messages.LanguageSettingEntryDialog_ContainsSystemHeaders);
        this.checkBoxSystem.setSelection(this.entry != null && (this.entry.getFlags() & 4) == 0);
        gd = new GridData(768);
        this.checkBoxSystem.setLayoutData((Object)gd);
        this.checkBoxSystem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LanguageSettingEntryDialog.this.updateImages();
                LanguageSettingEntryDialog.this.setButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.checkBoxFramework = new Button(compCheckboxes, 32);
        this.checkBoxFramework.setText(Messages.LanguageSettingEntryDialog_FrameworkFolder);
        this.checkBoxFramework.setSelection(this.entry != null && (this.entry.getFlags() & 0x40) != 0);
        gd = new GridData(768);
        this.checkBoxFramework.setLayoutData((Object)gd);
        this.checkBoxFramework.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LanguageSettingEntryDialog.this.updateImages();
                LanguageSettingEntryDialog.this.setButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite compButtons = new Composite(parent, 4);
        gd = new GridData(131072, 1024, false, false);
        gd.horizontalSpan = 4;
        gd.grabExcessVerticalSpace = true;
        compButtons.setLayoutData((Object)gd);
        compButtons.setLayout((Layout)new GridLayout(4, false));
        Label placeholder = new Label(compButtons, 0);
        placeholder.setLayoutData((Object)new GridData(512));
        this.buttonOk = new Button(compButtons, 8);
        this.buttonOk.setText(IDialogConstants.OK_LABEL);
        gd = new GridData();
        gd.widthHint = this.buttonVars.computeSize((int)-1, (int)0).x;
        this.buttonOk.setLayoutData((Object)gd);
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LanguageSettingEntryDialog.this.buttonPressed(event);
            }
        });
        this.buttonCancel = new Button(compButtons, 8);
        this.buttonCancel.setText(IDialogConstants.CANCEL_LABEL);
        gd = new GridData();
        gd.widthHint = this.buttonVars.computeSize((int)-1, (int)0).x;
        this.buttonCancel.setLayoutData((Object)gd);
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LanguageSettingEntryDialog.this.buttonPressed(event);
            }
        });
        parent.getShell().setDefaultButton(this.buttonOk);
        parent.pack();
        this.updateImages();
        this.setButtons();
        return parent;
    }

    private void setButtons() {
        int kindSelectionIndex = this.comboKind.getSelectionIndex();
        boolean isIncludeDirSelected = kindSelectionIndex == 0;
        this.checkBoxSystem.setVisible(isIncludeDirSelected);
        this.checkBoxFramework.setVisible(isIncludeDirSelected);
        boolean isMacroSelected = kindSelectionIndex == 1;
        this.comboPathCategory.setVisible(!isMacroSelected);
        this.buttonBrowse.setVisible(!isMacroSelected);
        this.buttonVars.setVisible(!isMacroSelected);
        this.checkBoxValue.setVisible(isMacroSelected);
        this.inputValue.setVisible(isMacroSelected);
        ((GridData)this.checkBoxValue.getLayoutData()).exclude = !isMacroSelected;
        ((GridData)this.inputValue.getLayoutData()).exclude = !isMacroSelected;
        ((GridData)this.buttonBrowse.getLayoutData()).exclude = isMacroSelected;
        ((GridData)this.buttonVars.getLayoutData()).exclude = isMacroSelected;
        switch (kindSelectionIndex) {
            case 0: 
            case 4: {
                this.labelInput.setText(Messages.LanguageSettingEntryDialog_Path);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                this.labelInput.setText(Messages.LanguageSettingEntryDialog_File);
                break;
            }
            default: {
                this.labelInput.setText(Messages.LanguageSettingEntryDialog_Name);
            }
        }
        this.inputValue.setEnabled(isMacroSelected);
        int indexPathKind = this.comboPathCategory.getSelectionIndex();
        boolean isProjectSelected = indexPathKind == 0;
        boolean isWorkspaceSelected = indexPathKind == 1;
        boolean isFilesystemSelected = indexPathKind == 2;
        String path = this.inputName.getText().trim();
        if (path.isEmpty()) {
            this.buttonOk.setEnabled(false);
        } else {
            this.buttonOk.setEnabled(isProjectSelected && !path.startsWith(SLASH) || isWorkspaceSelected && path.startsWith(SLASH) || isFilesystemSelected);
        }
        this.buttonVars.setEnabled(isFilesystemSelected);
        this.compositeArea.layout(true);
    }

    @Override
    public void buttonPressed(SelectionEvent e) {
        String str = null;
        if (e.widget.equals(this.buttonOk)) {
            String name;
            this.text1 = name = this.inputName.getText().trim();
            String value = this.inputValue.getText().trim();
            this.result = true;
            int flagBuiltIn = this.checkBoxBuiltIn.isVisible() && this.checkBoxBuiltIn.getSelection() ? 1 : 0;
            int flagSystem = this.checkBoxSystem.isVisible() && this.checkBoxSystem.getSelection() ? 0 : 4;
            int flagFramework = this.checkBoxFramework.isVisible() && this.checkBoxFramework.getSelection() ? 64 : 0;
            int indexPathKind = this.comboPathCategory.getSelectionIndex();
            int kind = this.comboKind.getSelectionIndex();
            boolean isProjectPath = indexPathKind == 0;
            boolean isWorkspacePath = kind != 1 && (isProjectPath || indexPathKind == 1);
            int flagWorkspace = isWorkspacePath ? 24 : 0;
            int flags = flagBuiltIn | flagWorkspace | flagSystem | flagFramework;
            CIncludePathEntry entry = null;
            switch (kind) {
                case 0: {
                    entry = CDataUtil.createCIncludePathEntry((String)name, (int)flags);
                    break;
                }
                case 1: {
                    entry = CDataUtil.createCMacroEntry((String)name, (String)value, (int)flags);
                    break;
                }
                case 2: {
                    entry = CDataUtil.createCIncludeFileEntry((String)name, (int)flags);
                    break;
                }
                case 3: {
                    entry = CDataUtil.createCMacroFileEntry((String)name, (int)flags);
                    break;
                }
                case 4: {
                    entry = CDataUtil.createCLibraryPathEntry((String)name, (int)flags);
                    break;
                }
                case 5: {
                    entry = CDataUtil.createCLibraryFileEntry((String)name, (int)flags);
                    break;
                }
                default: {
                    this.result = false;
                }
            }
            this.entries = new ICLanguageSettingEntry[]{entry};
            this.shell.dispose();
        } else if (e.widget.equals(this.buttonCancel)) {
            this.shell.dispose();
        } else if (e.widget.equals(this.buttonBrowse)) {
            boolean isDirectory = false;
            boolean isFile = false;
            switch (this.comboKind.getSelectionIndex()) {
                case 0: 
                case 4: {
                    isDirectory = true;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    isFile = true;
                    break;
                }
            }
            if (isDirectory) {
                switch (this.comboPathCategory.getSelectionIndex()) {
                    case 1: {
                        str = AbstractCPropertyTab.getWorkspaceDirDialog(this.shell, this.inputName.getText().trim());
                        break;
                    }
                    case 0: {
                        str = AbstractCPropertyTab.getProjectDirDialog(this.shell, this.inputName.getText().trim(), this.project);
                        break;
                    }
                    case 2: {
                        str = AbstractCPropertyTab.getFileSystemDirDialog(this.shell, this.inputName.getText().trim());
                    }
                }
            } else if (isFile) {
                switch (this.comboPathCategory.getSelectionIndex()) {
                    case 1: {
                        str = AbstractCPropertyTab.getWorkspaceFileDialog(this.shell, this.inputName.getText().trim());
                        break;
                    }
                    case 0: {
                        str = AbstractCPropertyTab.getProjectFileDialog(this.shell, this.inputName.getText().trim(), this.project);
                        break;
                    }
                    case 2: {
                        str = AbstractCPropertyTab.getFileSystemFileDialog(this.shell, this.inputName.getText().trim());
                    }
                }
            }
            if (str != null) {
                str = LanguageSettingEntryDialog.strip_wsp(str);
                if (this.comboPathCategory.getSelectionIndex() == 0 && str.startsWith(SLASH + this.project.getName() + SLASH)) {
                    str = str.substring(this.project.getName().length() + 2);
                }
                this.inputName.setText(str);
            }
        } else if (e.widget.equals(this.buttonVars) && (str = AbstractCPropertyTab.getVariableDialog(this.shell, this.cfgDescription)) != null) {
            this.inputName.insert(str);
        }
    }

    public ICLanguageSettingEntry[] getEntries() {
        return this.entries;
    }

    private void updateImages() {
        int indexEntryKind = this.comboKind.getSelectionIndex();
        int indexPathKind = this.comboPathCategory.getSelectionIndex();
        this.shell.setText(String.valueOf(Messages.LanguageSettingEntryDialog_Add) + this.comboKindItems[indexEntryKind]);
        int kind = this.comboIndexToKind(indexEntryKind);
        int flagBuiltin = this.checkBoxBuiltIn.getSelection() ? 1 : 0;
        int flagSystem = this.checkBoxSystem.getSelection() ? 0 : 4;
        int flagFramework = this.checkBoxFramework.getSelection() ? 64 : 0;
        boolean isWorkspacePath = indexPathKind == 0 || indexPathKind == 1;
        int flagWorkspace = isWorkspacePath ? 24 : 0;
        int flags = flagBuiltin | flagWorkspace | flagSystem | flagFramework;
        Image image = LanguageSettingsImages.getImage(kind, flags, indexPathKind == 0);
        this.iconComboKind.setImage(image);
        this.shell.setImage(image);
        this.buttonBrowse.setImage(this.pathCategoryImages[indexPathKind]);
    }
}

