/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.indexer.ProjectIndexerInputAdapter;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.ide.IDE;

public class CreateParserLogAction
implements IObjectActionDelegate {
    private static final String INDENT = "   ";
    private static final Comparator<String> COMP_INSENSITIVE = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.toUpperCase().compareTo(o2.toUpperCase());
        }
    };
    private ISelection fSelection;
    private IWorkbenchPartSite fSite;
    private boolean fWroteUnresolvedTitle;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fSite = targetPart.getSite();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    public void run(IAction action) {
        if (!(this.fSelection instanceof IStructuredSelection)) {
            return;
        }
        ArrayList<IWorkingCopy> workingCopies = new ArrayList<IWorkingCopy>();
        IWorkbenchPage activePage = this.fSite.getWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingCopy inputElement;
            IEditorReference eref = iEditorReferenceArray[n2];
            IEditorPart editor = eref.getEditor(false);
            if (editor instanceof CEditor && (inputElement = ((CEditor)editor).getInputCElement()) instanceof IWorkingCopy) {
                workingCopies.add(inputElement);
            }
            ++n2;
        }
        String title = action.getText().replace("&", "");
        IStructuredSelection cElements = SelectionConverter.convertSelectionToCElements(this.fSelection);
        Iterator i = cElements.iterator();
        ArrayList<ITranslationUnit> tuSelection = new ArrayList<ITranslationUnit>();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof ITranslationUnit)) continue;
            tuSelection.add(this.convertToWorkingCopy((ITranslationUnit)o, workingCopies));
        }
        ITranslationUnit[] tuArray = tuSelection.toArray(new ITranslationUnit[tuSelection.size()]);
        if (tuArray.length == 0) {
            return;
        }
        FileDialog dlg = new FileDialog(this.fSite.getShell(), 8192);
        dlg.setText(title);
        dlg.setFilterExtensions(new String[]{"*.log"});
        String path = null;
        while (path == null) {
            String msg;
            path = dlg.open();
            if (path == null) {
                return;
            }
            File file = new File(path);
            if (!file.exists()) continue;
            if (!file.canWrite()) {
                msg = NLS.bind((String)ActionMessages.CreateParserLogAction_readOnlyFile, (Object)path);
                MessageDialog.openError((Shell)this.fSite.getShell(), (String)title, (String)msg);
                path = null;
                continue;
            }
            msg = NLS.bind((String)ActionMessages.CreateParserLogAction_existingFile, (Object)path);
            if (MessageDialog.openQuestion((Shell)this.fSite.getShell(), (String)title, (String)msg)) continue;
            path = null;
        }
        try {
            PrintStream out = new PrintStream(path);
            try {
                boolean needsep = false;
                ITranslationUnit[] iTranslationUnitArray = tuArray;
                int n3 = tuArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITranslationUnit tu = iTranslationUnitArray[n4];
                    if (needsep) {
                        out.println();
                        out.println();
                    }
                    this.createLog(out, tu, (IProgressMonitor)new NullProgressMonitor());
                    needsep = true;
                    ++n4;
                }
            }
            finally {
                out.close();
            }
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)activePage, (IFileStore)EFS.getStore((URI)URIUtil.toURI((String)path)));
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.fSite.getShell(), (String)action.getText(), (String)e.getMessage());
        }
    }

    private ITranslationUnit convertToWorkingCopy(ITranslationUnit tu, List<IWorkingCopy> workingCopies) {
        for (IWorkingCopy wc : workingCopies) {
            if (!tu.equals(wc.getOriginalElement())) continue;
            return wc;
        }
        return tu;
    }

    private void createLog(final PrintStream out, final ITranslationUnit tu, IProgressMonitor pm) {
        try {
            tu.open(pm);
        }
        catch (CModelException e) {
            CUIPlugin.log(e);
        }
        ASTProvider.getASTProvider().runOnAST((ICElement)tu, ASTProvider.WAIT_IF_OPEN, pm, new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                if (ast != null) {
                    return CreateParserLogAction.this.createLog(out, tu, lang, ast);
                }
                return Status.CANCEL_STATUS;
            }
        });
    }

    protected IStatus createLog(PrintStream out, ITranslationUnit tu, ILanguage lang, IASTTranslationUnit ast) {
        TranslationUnit itu;
        IIndexFile[] ctxToHeader;
        IStatus status = Status.OK_STATUS;
        ICProject cproject = tu.getCProject();
        String projectName = cproject == null ? null : cproject.getElementName();
        IIndex index = ast.getIndex();
        ITranslationUnit configureWith = tu;
        int ctxLinkage = 0;
        ISignificantMacros ctxSigMacros = null;
        if (tu instanceof TranslationUnit && (ctxToHeader = (itu = (TranslationUnit)tu).getContextToHeader(index, 32)) != null) {
            try {
                IIndexFile ctxFile = ctxToHeader[0];
                ctxLinkage = ctxToHeader[0].getLinkageID();
                ctxSigMacros = ctxFile.getSignificantMacros();
                configureWith = CoreModelUtil.findTranslationUnitForLocation((IIndexFileLocation)ctxFile.getLocation(), (ICProject)cproject);
            }
            catch (CoreException coreException) {}
            if (configureWith == null) {
                configureWith = tu;
                ctxToHeader = null;
            }
        }
        ExtendedScannerInfo scfg = new ExtendedScannerInfo(configureWith.getScannerInfo(true));
        MyVisitor visitor = new MyVisitor();
        ast.accept((ASTVisitor)visitor);
        out.println("Project:               " + projectName);
        out.println("File:                  " + tu.getLocationURI());
        out.println("Language:              " + lang.getName());
        out.println("Index Version:         " + PDOM.versionString((int)PDOM.getDefaultVersion()));
        out.println("Build Configuration:   " + this.getBuildConfig(cproject));
        if (configureWith == tu) {
            out.println("Context:               none");
        } else {
            out.println("Context:               " + configureWith.getLocationURI());
            out.println(INDENT + this.getLinkageName(ctxLinkage) + ", " + ctxSigMacros);
        }
        try {
            IIndexFile[] versions = index.getFiles(IndexLocationFactory.getIFL((ITranslationUnit)tu));
            out.println("Versions in Index:     " + versions.length);
            IIndexFile[] iIndexFileArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFile f = iIndexFileArray[n2];
                int[] count = this.countNames(f);
                out.println(INDENT + this.getLinkageName(f.getLinkageID()) + ": " + f.getSignificantMacros() + "; " + count[0] + " macros, " + count[1] + " includes, " + count[2] + " names;");
                ++n2;
            }
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        out.println();
        this.output(out, "Include Search Path (option -I):", scfg.getIncludePaths());
        this.output(out, "Local Include Search Path (option -iquote):", scfg.getLocalIncludePath());
        this.output(out, "Preincluded files (option -include):", scfg.getIncludeFiles());
        this.output(out, "Preincluded macro files (option -imacros):", scfg.getMacroFiles());
        HashSet<String> reported = new HashSet<String>();
        this.output(out, "Macro definitions (option -D):", scfg.getDefinedSymbols(), reported);
        this.output(out, "Macro definitions (from language + headers in index):", ast.getBuiltinMacroDefinitions(), reported);
        this.output(out, "Macro definitions (from files actually parsed):", ast.getMacroDefinitions(), reported);
        try {
            this.outputUnresolvedIncludes(cproject, ast.getIndex(), out, ast.getIncludeDirectives(), ast.getLinkage().getLinkageID());
        }
        catch (CoreException e) {
            status = e.getStatus();
        }
        this.output(out, "Scanner problems:", ast.getPreprocessorProblems());
        this.output(out, "Parser problems:", visitor.fProblems.toArray(new IASTProblem[0]));
        this.output(out, "Unresolved names:", visitor.fProblemBindings.toArray(new IProblemBinding[0]));
        this.output(out, "Exceptions in name resolution:", visitor.fExceptions);
        out.println("Written on " + new Date().toString());
        return status;
    }

    private int[] countNames(IIndexFile f) {
        int[] result = new int[3];
        try {
            result[0] = f.getMacros().length;
            result[1] = f.getIncludes().length;
            result[2] = f.findNames(0, Integer.MAX_VALUE).length;
        }
        catch (CoreException coreException) {}
        return result;
    }

    private String getLinkageName(int linkageID) {
        switch (linkageID) {
            case 0: {
                return "none";
            }
            case 2: {
                return "C";
            }
            case 1: {
                return "C++";
            }
            case 3: {
                return "Fortran";
            }
            case 4: {
                return "Objective-C";
            }
        }
        return String.valueOf(linkageID);
    }

    private String getBuildConfig(ICProject cproject) {
        ICConfigurationDescription cfg;
        ICProjectDescriptionManager prjDescMgr = CCorePlugin.getDefault().getProjectDescriptionManager();
        ICProjectDescription prefs = prjDescMgr.getProjectDescription(cproject.getProject(), false);
        if (prefs != null && (cfg = prefs.getDefaultSettingConfiguration()) != null) {
            return cfg.getName();
        }
        return "unknown";
    }

    private void outputUnresolvedIncludes(ICProject prj, IIndex index, PrintStream out, IASTPreprocessorIncludeStatement[] includeDirectives, int linkageID) throws CoreException {
        this.fWroteUnresolvedTitle = false;
        ProjectIndexerInputAdapter resolver = new ProjectIndexerInputAdapter(prj);
        HashSet<IIndexFile> handled = new HashSet<IIndexFile>();
        IASTPreprocessorIncludeStatement[] iASTPreprocessorIncludeStatementArray = includeDirectives;
        int n = includeDirectives.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorIncludeStatement include = iASTPreprocessorIncludeStatementArray[n2];
            if (include.isResolved()) {
                IIndexFileLocation ifl = resolver.resolveASTPath(include.getPath());
                IIndexFile ifile = index.getFile(linkageID, ifl, include.getSignificantMacros());
                this.outputUnresolvedIncludes(index, out, ifl, ifile, handled);
            }
            ++n2;
        }
        if (this.fWroteUnresolvedTitle) {
            out.println();
        }
    }

    private void outputUnresolvedIncludes(IIndex index, PrintStream out, IIndexFileLocation ifl, IIndexFile ifile, Set<IIndexFile> handled) throws CoreException {
        if (ifile == null) {
            this.writeUnresolvedTitle(out);
            out.println(INDENT + ifl.getURI() + " is not indexed");
        } else if (handled.add(ifile)) {
            IIndexInclude[] includes;
            IIndexInclude[] iIndexIncludeArray = includes = ifile.getIncludes();
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexInclude inc = iIndexIncludeArray[n2];
                if (inc.isActive()) {
                    if (inc.isResolved()) {
                        IIndexFile next = index.resolveInclude(inc);
                        this.outputUnresolvedIncludes(index, out, inc.getIncludesLocation(), next, handled);
                    } else {
                        this.writeUnresolvedTitle(out);
                        out.println("   Unresolved inclusion: " + inc.getFullName() + " in file " + inc.getIncludedByLocation().getURI());
                    }
                }
                ++n2;
            }
        }
    }

    public void writeUnresolvedTitle(PrintStream out) {
        if (!this.fWroteUnresolvedTitle) {
            this.fWroteUnresolvedTitle = true;
            out.println("Unresolved includes (from headers in index):");
        }
    }

    private void output(PrintStream out, String label, String[] list) {
        if (list.length > 0) {
            out.println(label);
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                out.println(INDENT + line);
                ++n2;
            }
            out.println();
        }
    }

    private void output(PrintStream out, String label, Map<String, String> definedSymbols, HashSet<String> reported) {
        if (!definedSymbols.isEmpty()) {
            out.println(label);
            TreeMap<String, String> sorted = new TreeMap<String, String>(COMP_INSENSITIVE);
            sorted.putAll(definedSymbols);
            for (Map.Entry entry : sorted.entrySet()) {
                String macro = String.valueOf((String)entry.getKey()) + '=' + (String)entry.getValue();
                if (!reported.add(macro)) continue;
                out.println(INDENT + macro);
            }
            out.println();
        }
    }

    private void output(PrintStream out, String label, IASTPreprocessorMacroDefinition[] defs, HashSet<String> reported) {
        if (defs.length > 0) {
            out.println(label);
            TreeSet<String> macros = new TreeSet<String>(COMP_INSENSITIVE);
            IASTPreprocessorMacroDefinition[] iASTPreprocessorMacroDefinitionArray = defs;
            int n = defs.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPreprocessorMacroDefinition def = iASTPreprocessorMacroDefinitionArray[n2];
                macros.add(def.toString());
                ++n2;
            }
            for (String macro : macros) {
                if (!reported.add(macro)) continue;
                out.println(INDENT + macro);
            }
            out.println();
        }
    }

    private void output(PrintStream out, String label, IASTProblem[] preprocessorProblems) {
        if (preprocessorProblems.length > 0) {
            out.println(label);
            IASTProblem[] iASTProblemArray = preprocessorProblems;
            int n = preprocessorProblems.length;
            int n2 = 0;
            while (n2 < n) {
                IASTProblem problem = iASTProblemArray[n2];
                out.println(INDENT + problem.getMessageWithLocation());
                ++n2;
            }
            out.println();
        }
    }

    private void output(PrintStream out, String label, IProblemBinding[] list) {
        if (list.length > 0) {
            out.println(label);
            IProblemBinding[] iProblemBindingArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                IProblemBinding problem = iProblemBindingArray[n2];
                String file = problem.getFileName();
                int line = problem.getLineNumber();
                out.println(INDENT + problem.getMessage() + " in file " + file + ':' + line);
                ++n2;
            }
            out.println();
        }
    }

    private void output(PrintStream out, String label, List<Exception> list) {
        if (!list.isEmpty()) {
            out.println(label);
            for (Exception problem : list) {
                problem.printStackTrace(out);
            }
            out.println();
        }
    }

    private static final class MyVisitor
    extends ASTVisitor {
        List<IASTProblem> fProblems = new ArrayList<IASTProblem>();
        List<IProblemBinding> fProblemBindings = new ArrayList<IProblemBinding>();
        List<Exception> fExceptions = new ArrayList<Exception>();

        MyVisitor() {
            this.shouldVisitProblems = true;
            this.shouldVisitNames = true;
        }

        public int visit(IASTProblem problem) {
            this.fProblems.add(problem);
            return 1;
        }

        public int visit(IASTName name) {
            if (name instanceof ICPPASTQualifiedName) {
                return 3;
            }
            try {
                IBinding binding = name.resolveBinding();
                if (binding instanceof IProblemBinding) {
                    this.fProblemBindings.add((IProblemBinding)binding);
                }
            }
            catch (RuntimeException e) {
                this.fExceptions.add(e);
            }
            return 3;
        }
    }
}

