/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui.widgets;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ptp.internal.remote.core.PTPRemoteCorePlugin;
import org.eclipse.ptp.internal.remote.core.RemoteServicesImpl;
import org.eclipse.ptp.internal.remote.core.RemoteServicesProxy;
import org.eclipse.ptp.internal.remote.core.preferences.Preferences;
import org.eclipse.ptp.internal.remote.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.RemoteServices;
import org.eclipse.ptp.remote.ui.IRemoteUIConnectionManager;
import org.eclipse.ptp.remote.ui.RemoteUIServices;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RemoteConnectionWidget
extends Composite {
    public static int FLAG_FORCE_PROVIDER_SELECTION = 1;
    public static int FLAG_NO_LOCAL_SELECTION = 2;
    private static final String EMPTY_STRING = "";
    private Combo fServicesCombo = null;
    private Button fLocalButton;
    private Button fRemoteButton;
    private final Combo fConnectionCombo;
    private final Button fNewConnectionButton;
    private final RemoteServicesProxy[] fRemoteServices;
    private IRemoteConnection fSelectedConnection;
    private IRemoteServices fDefaultServices;
    private boolean fSelectionListernersEnabled = true;
    private boolean fEnabled = true;
    private final IRunnableContext fContext;
    private String[] fAttrHints;
    private String[] fAttrHintValues;
    private final ListenerList fSelectionListeners = new ListenerList();
    private final WidgetListener fWidgetListener = new WidgetListener();

    public RemoteConnectionWidget(Composite parent, int style, String title, int flags, IRunnableContext context) {
        super(parent, style);
        GridData gd;
        String id;
        this.fContext = context;
        RemoteConnectionWidget body = this;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        if (title != null) {
            Group group = new Group((Composite)this, 0);
            group.setText(title);
            GridLayout groupLayout = new GridLayout(1, false);
            groupLayout.marginHeight = 0;
            groupLayout.marginWidth = 0;
            groupLayout.numColumns = 4;
            group.setLayout((Layout)groupLayout);
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            layout.numColumns = 1;
            body = group;
        }
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        if ((flags & FLAG_FORCE_PROVIDER_SELECTION) == 0 && (id = Preferences.getString((String)PTPRemoteCorePlugin.getUniqueIdentifier(), (String)"remoteServicesId")) != null) {
            this.fDefaultServices = this.getRemoteServices(id);
        }
        if (this.fDefaultServices == null) {
            Label label = new Label((Composite)body, 0);
            label.setText(Messages.RemoteConnectionWidget_remoteServiceProvider);
            gd = new GridData();
            gd.horizontalSpan = 1;
            label.setLayoutData((Object)gd);
            this.fServicesCombo = new Combo((Composite)body, 12);
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            this.fServicesCombo.setLayoutData((Object)gd);
            this.fServicesCombo.addSelectionListener((SelectionListener)this.fWidgetListener);
            this.fServicesCombo.setFocus();
        }
        if ((flags & FLAG_NO_LOCAL_SELECTION) == 0 && (flags & FLAG_FORCE_PROVIDER_SELECTION) == 0) {
            this.fLocalButton = new Button((Composite)body, 16);
            this.fLocalButton.setText(Messages.RemoteConnectionWidget_Local);
            GridData data = new GridData();
            data.horizontalSpan = 1;
            this.fLocalButton.setLayoutData((Object)data);
            this.fLocalButton.addSelectionListener((SelectionListener)this.fWidgetListener);
            this.fLocalButton.setSelection(false);
            this.fRemoteButton = new Button((Composite)body, 16);
            this.fRemoteButton.setText(Messages.RemoteConnectionWidget_Remote);
            data = new GridData();
            data.horizontalSpan = 1;
            this.fRemoteButton.setLayoutData((Object)data);
        } else {
            Label remoteLabel = new Label((Composite)body, 0);
            remoteLabel.setText(Messages.RemoteConnectionWidget_connectionName);
            gd = new GridData();
            gd.horizontalSpan = 1;
            remoteLabel.setLayoutData((Object)gd);
        }
        this.fConnectionCombo = new Combo((Composite)body, 12);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 1;
        this.fConnectionCombo.setLayoutData((Object)gd2);
        this.fConnectionCombo.addSelectionListener((SelectionListener)this.fWidgetListener);
        if (this.fDefaultServices != null) {
            this.fConnectionCombo.setFocus();
        }
        this.fConnectionCombo.setEnabled(false);
        this.fNewConnectionButton = new Button((Composite)body, 8);
        this.fNewConnectionButton.setText(Messages.RemoteConnectionWidget_new);
        gd2 = new GridData();
        this.fNewConnectionButton.setLayoutData((Object)gd2);
        this.fNewConnectionButton.addSelectionListener((SelectionListener)this.fWidgetListener);
        this.fRemoteServices = RemoteServicesImpl.getRemoteServiceProxies();
        if (this.fServicesCombo != null) {
            this.initializeRemoteServicesCombo(null);
        }
        this.handleRemoteServiceSelected(null);
        if (this.fLocalButton != null) {
            this.handleButtonSelected();
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public Button getButton() {
        return this.fNewConnectionButton;
    }

    public IRemoteConnection getConnection() {
        return this.fSelectedConnection;
    }

    private IRemoteConnection getRemoteConnection(IRemoteServices services, String name) {
        IRemoteConnectionManager manager = this.getRemoteConnectionManager(services);
        if (manager != null) {
            return manager.getConnection(name);
        }
        return null;
    }

    private IRemoteConnection getRemoteConnection(String name) {
        IRemoteServices services = this.getSelectedServices();
        if (this.fDefaultServices != null && name.equals("Local")) {
            services = RemoteServices.getLocalServices();
        }
        return this.getRemoteConnection(services, name);
    }

    protected IRemoteConnectionManager getRemoteConnectionManager(IRemoteServices services) {
        if (services != null) {
            return services.getConnectionManager();
        }
        return null;
    }

    protected IRemoteServices getRemoteServices(String id) {
        if (id != null && !id.equals(EMPTY_STRING)) {
            return RemoteUIServices.getRemoteServices(id, this.fContext);
        }
        return null;
    }

    private IRemoteServices getSelectedServices() {
        if (this.fDefaultServices != null) {
            return this.fDefaultServices;
        }
        int selectionIndex = this.fServicesCombo.getSelectionIndex();
        if (this.fRemoteServices.length > 0 && selectionIndex > 0) {
            return RemoteServices.getRemoteServices((String)this.fRemoteServices[selectionIndex - 1].getId());
        }
        return null;
    }

    private IRemoteUIConnectionManager getUIConnectionManager() {
        IRemoteServices services = this.getSelectedServices();
        if (services != null) {
            return RemoteUIServices.getRemoteUIServices(services).getUIConnectionManager();
        }
        return null;
    }

    private void handleButtonSelected() {
        this.fRemoteButton.setSelection(!this.fLocalButton.getSelection());
        this.updateEnablement();
        this.handleConnectionSelected();
    }

    protected void handleConnectionSelected() {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        IRemoteConnection selectedConnection = null;
        if (this.fLocalButton != null && this.fLocalButton.getSelection()) {
            selectedConnection = RemoteServices.getLocalServices().getConnectionManager().getConnection("Local");
        } else {
            int currentSelection = this.fConnectionCombo.getSelectionIndex();
            if (currentSelection > 0) {
                String connectionName = this.fConnectionCombo.getItem(currentSelection);
                selectedConnection = this.getRemoteConnection(connectionName);
            }
        }
        if (selectedConnection == null || this.fSelectedConnection == null || !selectedConnection.getName().equals(this.fSelectedConnection.getName())) {
            this.fSelectedConnection = selectedConnection;
            Event evt = new Event();
            evt.widget = this;
            this.notifyListeners(new SelectionEvent(evt));
        }
        this.fWidgetListener.setEnabled(enabled);
    }

    protected void handleNewRemoteConnectionSelected() {
        IRemoteConnection conn;
        if (this.getUIConnectionManager() != null && (conn = this.getUIConnectionManager().newConnection(this.getShell(), this.fAttrHints, this.fAttrHintValues)) != null) {
            this.handleRemoteServiceSelected(conn);
            this.handleConnectionSelected();
        }
    }

    protected void handleRemoteServiceSelected(IRemoteConnection conn) {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        try {
            IRemoteServices selectedServices = this.getSelectedServices();
            if (conn != null) {
                selectedServices = conn.getRemoteServices();
            }
            if (this.fDefaultServices == null && conn != null) {
                int index = 0;
                while (index < this.fRemoteServices.length) {
                    if (this.fRemoteServices[index].getId().equals(selectedServices.getId())) {
                        this.fServicesCombo.select(index + 1);
                        break;
                    }
                    ++index;
                }
            }
            this.fConnectionCombo.removeAll();
            this.fConnectionCombo.add(Messages.RemoteConnectionWidget_selectConnection);
            if (selectedServices == null) {
                this.fConnectionCombo.select(0);
                this.fConnectionCombo.setEnabled(false);
                this.fNewConnectionButton.setEnabled(false);
            } else {
                this.fConnectionCombo.setEnabled(true);
                IRemoteConnectionManager connectionManager = selectedServices.getConnectionManager();
                IRemoteConnection[] connections = connectionManager.getConnections();
                Arrays.sort(connections, new Comparator<IRemoteConnection>(){

                    @Override
                    public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                        return c1.getName().compareToIgnoreCase(c2.getName());
                    }
                });
                int selected = 0;
                int offset = 1;
                int i = 0;
                while (i < connections.length) {
                    this.fConnectionCombo.add(connections[i].getName());
                    if (conn != null && connections[i].getName().equals(conn.getName())) {
                        selected = i + offset;
                    }
                    ++i;
                }
                this.fConnectionCombo.select(selected);
                this.handleConnectionSelected();
                this.fNewConnectionButton.setEnabled(selectedServices.canCreateConnections());
            }
        }
        finally {
            this.fWidgetListener.setEnabled(enabled);
        }
    }

    protected void initializeRemoteServicesCombo(String id) {
        boolean enabled = this.fWidgetListener.isEnabled();
        this.fWidgetListener.disable();
        IRemoteServices defService = null;
        if (id != null) {
            defService = this.getRemoteServices(id);
        }
        Arrays.sort(this.fRemoteServices, new Comparator<RemoteServicesProxy>(){

            @Override
            public int compare(RemoteServicesProxy c1, RemoteServicesProxy c2) {
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
        });
        this.fServicesCombo.removeAll();
        int offset = 1;
        int defIndex = 0;
        this.fServicesCombo.add(Messages.RemoteConnectionWidget_selectRemoteProvider);
        int i = 0;
        while (i < this.fRemoteServices.length) {
            this.fServicesCombo.add(this.fRemoteServices[i].getName());
            if (defService != null && this.fRemoteServices[i].equals(defService)) {
                defIndex = i + offset;
            }
            ++i;
        }
        if (this.fRemoteServices.length > 0) {
            this.fServicesCombo.select(defIndex);
        }
        this.fWidgetListener.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.fEnabled;
    }

    private void notifyListeners(SelectionEvent e) {
        if (this.fSelectionListernersEnabled) {
            Object[] objectArray = this.fSelectionListeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                ((SelectionListener)listener).widgetSelected(e);
                ++n2;
            }
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setConnection(IRemoteConnection connection) {
        this.fSelectionListernersEnabled = false;
        if (this.fLocalButton != null && connection != null && connection.getRemoteServices() == RemoteServices.getLocalServices()) {
            this.fLocalButton.setSelection(true);
            this.handleButtonSelected();
        } else {
            this.handleRemoteServiceSelected(connection);
        }
        this.handleConnectionSelected();
        this.updateEnablement();
        this.fSelectionListernersEnabled = true;
    }

    public void setConnection(String id, String name) {
        IRemoteConnection connection;
        IRemoteServices services = this.getRemoteServices(id);
        if (services != null && (connection = this.getRemoteConnection(services, name)) != null) {
            this.setConnection(connection);
        }
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
        this.updateEnablement();
    }

    public void setHints(String[] attrHints, String[] attrHintValues) {
        this.fAttrHints = attrHints;
        this.fAttrHintValues = attrHintValues;
    }

    private void updateEnablement() {
        if (this.fDefaultServices != null) {
            boolean isRemote = true;
            if (this.fLocalButton != null) {
                this.fLocalButton.setEnabled(this.fEnabled);
                this.fRemoteButton.setEnabled(this.fEnabled);
                isRemote = !this.fLocalButton.getSelection();
            }
            this.fConnectionCombo.setEnabled(this.fEnabled && isRemote);
            this.fNewConnectionButton.setEnabled(this.fEnabled && isRemote && this.fDefaultServices.canCreateConnections());
        } else {
            IRemoteServices services = this.getSelectedServices();
            this.fConnectionCombo.setEnabled(this.fEnabled && services != null);
            this.fNewConnectionButton.setEnabled(this.fEnabled && services != null && services.canCreateConnections());
            this.fServicesCombo.setEnabled(this.fEnabled);
        }
    }

    protected class WidgetListener
    implements SelectionListener {
        private boolean listenerEnabled = true;

        protected WidgetListener() {
        }

        public void disable() {
            this.setEnabled(false);
        }

        protected void doWidgetDefaultSelected(SelectionEvent e) {
        }

        public void enable() {
            this.setEnabled(true);
        }

        public synchronized boolean isEnabled() {
            return this.listenerEnabled;
        }

        public synchronized void setEnabled(boolean enabled) {
            this.listenerEnabled = enabled;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            if (this.isEnabled()) {
                this.widgetSelected(e);
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.isEnabled()) {
                Object source = e.getSource();
                if (source == RemoteConnectionWidget.this.fServicesCombo) {
                    RemoteConnectionWidget.this.handleRemoteServiceSelected(null);
                } else if (source == RemoteConnectionWidget.this.fConnectionCombo) {
                    RemoteConnectionWidget.this.handleConnectionSelected();
                } else if (source == RemoteConnectionWidget.this.fNewConnectionButton) {
                    RemoteConnectionWidget.this.handleNewRemoteConnectionSelected();
                } else if (source == RemoteConnectionWidget.this.fLocalButton) {
                    RemoteConnectionWidget.this.handleButtonSelected();
                }
            }
        }
    }
}

