/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.internal.remote.ui.messages.Messages;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.exception.RemoteConnectionException;
import org.eclipse.ptp.remote.ui.widgets.RemoteConnectionWidget;
import org.eclipse.swt.widgets.Shell;

public class RemoteUIServicesUtils {
    public static void openConnectionWithProgress(Shell shell, IRunnableContext context, final IRemoteConnection connection) {
        if (!connection.isOpen()) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        connection.open(monitor);
                    }
                    catch (RemoteConnectionException e) {
                        throw new InvocationTargetException(e);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            try {
                if (context != null) {
                    context.run(true, true, op);
                } else {
                    new ProgressMonitorDialog(shell).run(true, true, op);
                }
            }
            catch (InvocationTargetException e) {
                ErrorDialog.openError((Shell)shell, (String)Messages.AbstractRemoteUIConnectionManager_Connection_Error, (String)Messages.AbstractRemoteUIConnectionManager_Could_not_open_connection, (IStatus)new Status(4, "org.eclipse.ptp.remote.ui", e.getCause().getMessage()));
            }
            catch (InterruptedException e) {
                ErrorDialog.openError((Shell)shell, (String)Messages.AbstractRemoteUIConnectionManager_Connection_Error, (String)Messages.AbstractRemoteUIConnectionManager_Could_not_open_connection, (IStatus)new Status(4, "org.eclipse.ptp.remote.ui", e.getMessage()));
            }
        }
    }

    public static void setConnectionHints(RemoteConnectionWidget connectionWidget, IRemoteConnection connection) throws URISyntaxException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("CONNECTION_ADDRESS_HINT", connection.getAddress());
        result.put("LOGIN_USERNAME_HINT", connection.getUsername());
        result.put("CONNECTION_PORT_HINT", String.valueOf(connection.getPort()));
        String[] hints = new String[result.size()];
        String[] defaults = new String[hints.length];
        int i = 0;
        Iterator iterator = result.keySet().iterator();
        while (iterator.hasNext()) {
            String s;
            hints[i] = s = (String)iterator.next();
            defaults[i++] = (String)result.get(s);
        }
        connectionWidget.setHints(hints, defaults);
    }
}

