/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.ui.preferences;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ptp.internal.remote.core.preferences.Preferences;

public class PreferencesAdapter
implements IPreferenceStore {
    private final ListenerList fListeners = new ListenerList(1);
    private final PreferenceChangeListener fListener = new PreferenceChangeListener();
    private final String fPrefsQualifier;
    private boolean fSilent;
    private boolean fNeedsSaving = false;

    public PreferencesAdapter(String qualifier) {
        this.fPrefsQualifier = qualifier;
        Preferences.addPreferenceChangeListener((String)this.fPrefsQualifier, (IEclipsePreferences.IPreferenceChangeListener)this.fListener);
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public boolean contains(String name) {
        return Preferences.contains((String)this.fPrefsQualifier, (String)name);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.fNeedsSaving = true;
        if (!this.fSilent) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                ++i;
            }
        }
    }

    public boolean getBoolean(String name) {
        return Preferences.getBoolean((String)this.fPrefsQualifier, (String)name);
    }

    public boolean getDefaultBoolean(String name) {
        return Preferences.getDefaultBoolean((String)this.fPrefsQualifier, (String)name, (boolean)false);
    }

    public double getDefaultDouble(String name) {
        return Preferences.getDefaultDouble((String)this.fPrefsQualifier, (String)name, (double)0.0);
    }

    public float getDefaultFloat(String name) {
        return Preferences.getDefaultFloat((String)this.fPrefsQualifier, (String)name, (float)0.0f);
    }

    public int getDefaultInt(String name) {
        return Preferences.getDefaultInt((String)this.fPrefsQualifier, (String)name, (int)0);
    }

    public long getDefaultLong(String name) {
        return Preferences.getDefaultLong((String)this.fPrefsQualifier, (String)name, (long)0L);
    }

    public String getDefaultString(String name) {
        return Preferences.getDefaultString((String)this.fPrefsQualifier, (String)name, (String)"");
    }

    public double getDouble(String name) {
        return Preferences.getDouble((String)this.fPrefsQualifier, (String)name);
    }

    public float getFloat(String name) {
        return Preferences.getFloat((String)this.fPrefsQualifier, (String)name);
    }

    public int getInt(String name) {
        return Preferences.getInt((String)this.fPrefsQualifier, (String)name);
    }

    public long getLong(String name) {
        return Preferences.getLong((String)this.fPrefsQualifier, (String)name);
    }

    public String getString(String name) {
        return Preferences.getString((String)this.fPrefsQualifier, (String)name);
    }

    public boolean isDefault(String name) {
        return Preferences.isDefault((String)this.fPrefsQualifier, (String)name);
    }

    public boolean needsSaving() {
        return this.fNeedsSaving;
    }

    public void putValue(String name, String value) {
        try {
            this.fSilent = true;
            Preferences.setString((String)this.fPrefsQualifier, (String)name, (String)value);
        }
        finally {
            this.fSilent = false;
        }
    }

    public void setDefault(String name, double value) {
        Preferences.setDefaultDouble((String)this.fPrefsQualifier, (String)name, (double)value);
    }

    public void setDefault(String name, float value) {
        Preferences.setDefaultFloat((String)this.fPrefsQualifier, (String)name, (float)value);
    }

    public void setDefault(String name, int value) {
        Preferences.setDefaultInt((String)this.fPrefsQualifier, (String)name, (int)value);
    }

    public void setDefault(String name, long value) {
        Preferences.setDefaultLong((String)this.fPrefsQualifier, (String)name, (long)value);
    }

    public void setDefault(String name, String defaultObject) {
        Preferences.setDefaultString((String)this.fPrefsQualifier, (String)name, (String)defaultObject);
    }

    public void setDefault(String name, boolean value) {
        Preferences.setDefaultBoolean((String)this.fPrefsQualifier, (String)name, (boolean)value);
    }

    public void setToDefault(String name) {
        Preferences.setToDefault((String)this.fPrefsQualifier, (String)name);
    }

    public void setValue(String name, double value) {
        Preferences.setDouble((String)this.fPrefsQualifier, (String)name, (double)value);
    }

    public void setValue(String name, float value) {
        Preferences.setFloat((String)this.fPrefsQualifier, (String)name, (float)value);
    }

    public void setValue(String name, int value) {
        Preferences.setInt((String)this.fPrefsQualifier, (String)name, (int)value);
    }

    public void setValue(String name, long value) {
        Preferences.setLong((String)this.fPrefsQualifier, (String)name, (long)value);
    }

    public void setValue(String name, String value) {
        Preferences.setString((String)this.fPrefsQualifier, (String)name, (String)value);
    }

    public void setValue(String name, boolean value) {
        Preferences.setBoolean((String)this.fPrefsQualifier, (String)name, (boolean)value);
    }

    private class PreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private PreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            PreferencesAdapter.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
        }
    }
}

