/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.toolkit;

import java.util.regex.Pattern;

public enum ToolkitVersion {
    v5_5("CUDA Toolkit 5.5", "/usr/local/cuda-5.5/bin", "/Developer/NVIDIA/CUDA-5.5", ".*release 5\\.5.*"),
    v6_0("CUDA Toolkit 6.0", "/usr/local/cuda-6.0/bin", "/Developer/NVIDIA/CUDA-6.0", ".*release 6\\.0.*"),
    v6_5("CUDA Toolkit 6.5", "/usr/local/cuda-6.5/bin", "/Developer/NVIDIA/CUDA-6.5", ".*release 6\\.5.*");

    public static ToolkitVersion current;
    public final Pattern compilerVersionRegex;
    public final String defaultBinPath;
    public final String defaultMacBinPath;
    public final String label;

    static {
        current = v6_5;
    }

    private ToolkitVersion(String label, String defaultBinPath, String defaultMacBinPath, String compilerVersionRegex) {
        this.label = label;
        this.defaultBinPath = defaultBinPath;
        this.defaultMacBinPath = defaultMacBinPath;
        this.compilerVersionRegex = Pattern.compile(compilerVersionRegex);
    }

    public boolean matches(String compilerOutput) {
        return this.compilerVersionRegex.matcher(compilerOutput).matches();
    }
}

