/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.internal.toolkit;

import com.nvidia.common.internal.Activator;
import com.nvidia.common.internal.toolkit.BundledToolkit;
import com.nvidia.common.internal.toolkit.CommandLineToolkit;
import com.nvidia.common.internal.toolkit.CudaToolkit;
import com.nvidia.common.internal.toolkit.IToolkitLookup;
import com.nvidia.common.internal.toolkit.LocallyInstalledToolkits;
import com.nvidia.common.internal.toolkit.ToolkitOnPath;
import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.toolkit.IToolkitRegistry;
import com.nvidia.common.util.CoreUtil;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

public final class ToolkitManager
extends AbstractPreferenceInitializer
implements IToolkitManager {
    private static final String TOOLKITS_PREFERENCE = "cuda.toolkits";
    private static final String PREF_DEFAULT_TOOLKIT = "cuda.toolkits.default";
    private IToolkitRegistry registry = null;

    private static String getToolkitPathPreferenceName(int id) {
        return String.format("%s.%d.path", TOOLKITS_PREFERENCE, id);
    }

    @Override
    public ICudaToolkit editToolkit(String id) {
        if (this.registry != null && this.registry.ownsToolkit(id)) {
            return this.registry.editToolkit(id);
        }
        return null;
    }

    @Override
    public ICudaToolkit getDefaultToolkit() {
        int i;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String string = store.getString(ToolkitManager.getToolkitPathPreferenceName(i = store.getInt(PREF_DEFAULT_TOOLKIT)));
        if (string != null && new File(string).isDirectory()) {
            return new CudaToolkit(null, (IPath)new Path(string), null);
        }
        return null;
    }

    public IToolkitRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public ICudaToolkit getToolkit(String id) throws CoreException {
        if (CoreUtil.isNullOrEmpty(id)) {
            return this.getDefaultToolkit();
        }
        if (this.registry != null) {
            return this.registry.getToolkit(id);
        }
        return null;
    }

    @Override
    public boolean isInitialized() {
        return this.registry != null ? this.registry.isInitialized() : true;
    }

    private IToolkitLookup[] getToolkitLookups() {
        return new IToolkitLookup[]{new CommandLineToolkit(), new BundledToolkit(), new ToolkitOnPath(), new LocallyInstalledToolkits()};
    }

    public void initializeDefaultPreferences() {
        LinkedHashSet<ICudaToolkit> toolkits = new LinkedHashSet<ICudaToolkit>();
        IToolkitLookup[] iToolkitLookupArray = this.getToolkitLookups();
        int n = iToolkitLookupArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToolkitLookup lookup = iToolkitLookupArray[n2];
            ICudaToolkit[] discovered = lookup.discover();
            if (discovered != null) {
                toolkits.addAll(Arrays.asList(discovered));
            }
            ++n2;
        }
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (!toolkits.isEmpty()) {
            int i = 1;
            store.setDefault(PREF_DEFAULT_TOOLKIT, 1);
            for (ICudaToolkit toolkit : toolkits) {
                store.setDefault(ToolkitManager.getToolkitPathPreferenceName(i++), Path.fromOSString((String)toolkit.getBinDirectory()).toPortableString());
            }
        }
    }

    public void setRegistry(IToolkitRegistry registry) {
        this.registry = registry;
    }
}

