/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupNameValidator
extends AbstractElementValidator {
    private static GroupNameValidator instance = new GroupNameValidator();

    public static GroupNameValidator getInstance() {
        return instance;
    }

    public List<SemanticException> validateForAddingGroup(ListingHandle element, String groupName) {
        List<GroupElement> groupList = Collections.emptyList();
        ListingElement targetElement = (ListingElement)element.getElement();
        if (targetElement == null) {
            targetElement = (ListingElement)element.getElement();
            groupList = this.getGroups(element.getModule(), (ListingElement)element.getElement());
        } else {
            groupList = this.getGroupsWithContents(element.getModule(), targetElement);
        }
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        if (this.isDuplicateGroupName(element.getModule(), groupList, groupName)) {
            list.add(new NameException((DesignElement)targetElement, groupName, "Error.NameException.DUPLICATE"));
            return list;
        }
        return list;
    }

    public List<SemanticException> validateForRenamingGroup(ListingHandle element, GroupHandle group, String groupName) {
        if (group.getName() == groupName || groupName != null && groupName.equals(group.getName())) {
            return Collections.emptyList();
        }
        ListingElement targetElement = (ListingElement)element.getElement();
        if (targetElement == null) {
            return Collections.emptyList();
        }
        List<GroupElement> groupList = this.getGroupsWithContents(element.getModule(), targetElement);
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        if (this.isDuplicateGroupName(element.getModule(), groupList, groupName)) {
            list.add(new NameException((DesignElement)targetElement, groupName, "Error.NameException.DUPLICATE"));
            return list;
        }
        return list;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        if (!(element instanceof ListingElement)) {
            return Collections.emptyList();
        }
        return this.doValidate(module, (ListingElement)element);
    }

    private List<SemanticException> doValidate(Module module, ListingElement toValidate) {
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        List<GroupElement> groupList = this.getGroupsWithContents(module, toValidate);
        HashSet<String> duplicateNames = null;
        int size = groupList.size();
        int i = 0;
        while (i < size - 1) {
            GroupElement group1 = groupList.get(i);
            String groupName1 = group1.getStringProperty(module, "groupName");
            assert (groupName1 != null);
            if (duplicateNames == null || !duplicateNames.contains(groupName1)) {
                int j = i + 1;
                while (j < size) {
                    GroupElement group2 = groupList.get(j);
                    String groupName2 = group2.getStringProperty(module, "groupName");
                    assert (groupName2 != null);
                    if (groupName1.equalsIgnoreCase(groupName2)) {
                        if (duplicateNames == null) {
                            duplicateNames = new HashSet<String>();
                        }
                        duplicateNames.add(groupName1);
                        list.add(new SemanticError(group2.getContainer(), new String[]{groupName1}, "Error.SemanticError.DUPLICATE_GROUP_NAME"));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list;
    }

    public List<SemanticException> validate(ListingHandle element) {
        return this.validate(element.getModule(), element.getElement());
    }

    private List<GroupElement> getGroups(Module module, ListingElement element) {
        ArrayList<GroupElement> list = new ArrayList<GroupElement>();
        for (GroupElement groupElement : element.getGroups()) {
            String groupName = groupElement.getStringProperty(module, "groupName");
            if (StringUtil.isBlank(groupName)) continue;
            list.add(groupElement);
        }
        return list;
    }

    private List<GroupElement> getGroupsWithContents(Module module, DesignElement element) {
        ArrayList<GroupElement> list = new ArrayList<GroupElement>();
        if (element instanceof ListingElement) {
            list.addAll(this.getGroups(module, (ListingElement)element));
        }
        return list;
    }

    private boolean isDuplicateGroupName(Module module, List<GroupElement> groupNameList, String groupName) {
        for (GroupElement group : groupNameList) {
            String tmpName = group.getStringProperty(module, "groupName");
            assert (tmpName != null);
            if (!tmpName.equalsIgnoreCase(groupName)) continue;
            return true;
        }
        return false;
    }
}

