/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.interfaces.IDerivedExtendableElementModel;
import org.eclipse.birt.report.model.elements.interfaces.IExtendedItemModel;
import org.eclipse.birt.report.model.elements.interfaces.IOdaExtendableElementModel;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

public class SimpleGroupElementHandle
extends GroupElementHandle {
    protected final Module module;
    protected List elements = null;

    public SimpleGroupElementHandle(ModuleHandle moduleHandle, List elements) {
        assert (moduleHandle != null);
        this.module = moduleHandle.getModule();
        assert (elements != null);
        this.elements = elements;
    }

    public List getElements() {
        return this.elements;
    }

    public Module getModule() {
        return this.module;
    }

    public ModuleHandle getModuleHandle() {
        return (ModuleHandle)this.module.getHandle(this.module);
    }

    public List getCommonProperties() {
        if (this.elements.size() == 1) {
            return Collections.unmodifiableList(((DesignElementHandle)this.elements.get(0)).getElement().getPropertyDefns());
        }
        List minProps = this.getMinPropDefns();
        ArrayList commonProps = new ArrayList(minProps);
        block0: for (PropertyDefn propDefn : minProps) {
            int i = 0;
            while (i < this.elements.size()) {
                if (((DesignElementHandle)this.elements.get(i)).getElement().getPropertyDefn(propDefn.getName()) == null) {
                    commonProps.remove(propDefn);
                    continue block0;
                }
                ++i;
            }
        }
        return Collections.unmodifiableList(commonProps);
    }

    private List getMinPropDefns() {
        int min = Integer.MAX_VALUE;
        List<IElementPropertyDefn> rtnPropDefns = Collections.EMPTY_LIST;
        int j = 0;
        while (j < this.elements.size()) {
            Object item = this.elements.get(j);
            if (!(item instanceof DesignElementHandle)) {
                return Collections.EMPTY_LIST;
            }
            List<IElementPropertyDefn> propDefns = ((DesignElementHandle)item).getElement().getPropertyDefns();
            if (propDefns.size() < min) {
                min = propDefns.size();
                rtnPropDefns = propDefns;
            }
            ++j;
        }
        return rtnPropDefns;
    }

    public boolean isSameType() {
        if (this.elements.size() == 0) {
            return false;
        }
        IElementDefn baseDefn = null;
        int i = 0;
        while (i < this.elements.size()) {
            Object item = this.elements.get(i);
            if (!(item instanceof DesignElementHandle)) {
                return false;
            }
            IElementDefn elemDefn = ((DesignElementHandle)item).getDefn();
            if (baseDefn == null) {
                baseDefn = elemDefn;
            }
            if (elemDefn != baseDefn) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Iterator visiblePropertyIterator() {
        List list = this.getCommonProperties();
        ArrayList<IElementPropertyDefn> visibleList = new ArrayList<IElementPropertyDefn>();
        int i = 0;
        while (i < list.size()) {
            IElementPropertyDefn propDefn = (IElementPropertyDefn)list.get(i);
            if (this.isPropertyVisible(propDefn.getName())) {
                visibleList.add(propDefn);
            }
            ++i;
        }
        return new GroupElementHandle.GroupPropertyIterator(visibleList);
    }

    protected boolean isPropertyVisible(String propName) {
        List elements = this.getElements();
        int i = 0;
        while (i < elements.size()) {
            PropertyHandle propertyHandle = ((DesignElementHandle)elements.get(i)).getPropertyHandle(propName);
            if (propertyHandle != null && !propertyHandle.isVisible() || propertyHandle == null) {
                return false;
            }
            ++i;
        }
        return !this.needHide(propName);
    }

    public void clearLocalProperties() throws SemanticException {
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ClearProperties"));
        try {
            Iterator iter = this.propertyIterator();
            while (iter.hasNext()) {
                Object localValue;
                String propName;
                GroupPropertyHandle propHandle = (GroupPropertyHandle)iter.next();
                DesignElementHandle elementHandle = null;
                if (this.elements != null && !this.elements.isEmpty()) {
                    elementHandle = (DesignElementHandle)this.elements.get(0);
                }
                if ("extends".equals(propName = propHandle.getPropertyDefn().getName()) || "name".equals(propName) || "extensionName".equals(propName) && elementHandle instanceof IExtendedItemModel || propHandle.isExtensionModelProperty() || elementHandle instanceof IDerivedExtendableElementModel && "extensionID".equals(propName) || elementHandle instanceof IOdaExtendableElementModel && "extensionID".equals(propName) || propHandle.getPropertyDefn().getTypeCode() == 23 || (localValue = propHandle.getLocalValue()) == null) continue;
                propHandle.clearValue();
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void clearLocalPropertiesIncludeSubElement() throws SemanticException {
        ActivityStack stack = this.module.getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.ClearProperties"));
        try {
            Iterator iter = this.propertyIterator();
            while (iter.hasNext()) {
                GroupPropertyHandle propHandle = (GroupPropertyHandle)iter.next();
                DesignElementHandle elementHandle = null;
                if (this.elements != null && !this.elements.isEmpty()) {
                    elementHandle = (DesignElementHandle)this.elements.get(0);
                }
                String propName = propHandle.getPropertyDefn().getName();
                elementHandle.getPropertyIterator();
                if ("extends".equals(propName) || "name".equals(propName) || "extensionName".equals(propName) && elementHandle instanceof IExtendedItemModel || propHandle.isExtensionModelProperty() || elementHandle instanceof IDerivedExtendableElementModel && "extensionID".equals(propName) || elementHandle instanceof IOdaExtendableElementModel && "extensionID".equals(propName)) continue;
                if (propHandle.getPropertyDefn().getTypeCode() == 23) {
                    Object object = propHandle.getValue();
                    if (object == null) continue;
                    if (object instanceof DesignElementHandle) {
                        DesignElementHandle designElementHandle = (DesignElementHandle)object;
                        this.clearLocalPropertiesIncludeSubElement(designElementHandle);
                        continue;
                    }
                    if (!(object instanceof List) || ((List)object).size() <= 0) continue;
                    int i = 0;
                    while (i < ((List)object).size()) {
                        DesignElementHandle designElementHandle = (DesignElementHandle)((List)object).get(i);
                        this.clearLocalPropertiesIncludeSubElement(designElementHandle);
                        ++i;
                    }
                    continue;
                }
                Object localValue = propHandle.getLocalValue();
                if (localValue == null) continue;
                propHandle.clearValue();
            }
        }
        catch (SemanticException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    private void clearLocalPropertiesIncludeSubElement(DesignElementHandle elementHandle) throws SemanticException {
        if (!this.hasLocalPropertiesIncludeSubElement(elementHandle)) {
            return;
        }
        Iterator iterator = elementHandle.getPropertyIterator();
        while (iterator.hasNext()) {
            PropertyHandle propertyHandler = (PropertyHandle)iterator.next();
            String propertyName = propertyHandler.getPropertyDefn().getName();
            if ("extends".equals(propertyName) || "name".equals(propertyName) || "extensionName".equals(propertyName) && elementHandle instanceof IExtendedItemModel || elementHandle instanceof ExtendedItemHandle && ((ExtendedItem)elementHandle.getElement()).isExtensionModelProperty(propertyName) || elementHandle instanceof IDerivedExtendableElementModel && "extensionID".equals(propertyName) || elementHandle instanceof IOdaExtendableElementModel && "extensionID".equals(propertyName)) continue;
            if (propertyHandler.getPropertyDefn().getTypeCode() == 23) {
                List list = propertyHandler.getContents();
                if (list == null || list.size() <= 0) continue;
                int i = 0;
                while (i < list.size()) {
                    DesignElementHandle handle = (DesignElementHandle)list.get(i);
                    this.clearLocalPropertiesIncludeSubElement(handle);
                    ++i;
                }
                continue;
            }
            Object localValue = elementHandle.getElement().getLocalProperty(elementHandle.getModule(), propertyName);
            if (localValue == null) continue;
            elementHandle.setProperty(propertyName, null);
        }
    }

    public boolean isExtendedElements() {
        if (this.elements.isEmpty()) {
            return false;
        }
        for (Object next : this.elements) {
            if (!(next instanceof DesignElementHandle)) {
                return false;
            }
            DesignElementHandle designHandle = (DesignElementHandle)next;
            if (designHandle.getExtends() != null) continue;
            return false;
        }
        return true;
    }

    protected boolean allExtendedElements() {
        if (this.elements.isEmpty()) {
            return false;
        }
        for (Object next : this.elements) {
            if (!(next instanceof DesignElementHandle)) {
                return false;
            }
            DesignElementHandle elementHandle = (DesignElementHandle)next;
            if (elementHandle.getExtends() != null || elementHandle.getElement().getBaseId() > 0L) continue;
            return false;
        }
        return true;
    }

    protected boolean isPropertyReadOnly(String propName) {
        int i = 0;
        while (i < this.elements.size()) {
            PropertyHandle propertyHandle = ((DesignElementHandle)this.elements.get(i)).getPropertyHandle(propName);
            if (propertyHandle != null && propertyHandle.isReadOnly() || propertyHandle == null) {
                return true;
            }
            ++i;
        }
        return this.needHide(propName);
    }

    /*
     * Unable to fully structure code
     */
    private boolean needHide(String propName) {
        if (!("bookmark".equals(propName) || "toc".equals(propName) || "pageBreakAfter".equals(propName) || "pageBreakBefore".equals(propName) || "pageBreakInside".equals(propName) || "drop".equals(propName))) {
            return false;
        }
        i = 0;
        while (i < this.elements.size()) {
            block7: {
                current = (DesignElementHandle)this.elements.get(i);
                container = current.getContainer();
                if (!"drop".equals(propName)) ** GOTO lbl13
                if (!(current instanceof CellHandle) || container == null || container.getContainer() instanceof GroupHandle) break block7;
                return true;
lbl-1000:
                // 1 sources

                {
                    if (container instanceof MasterPageHandle) {
                        return true;
                    }
                    container = container.getContainer();
lbl13:
                    // 2 sources

                    ** while (container != null)
                }
            }
            ++i;
        }
        return false;
    }

    public GroupPropertyHandle getPropertyHandle(String propName) {
        List commProps = this.getCommonProperties();
        int i = 0;
        while (i < commProps.size()) {
            ElementPropertyDefn propDefn = (ElementPropertyDefn)commProps.get(i);
            if (propDefn.getName().equalsIgnoreCase(propName)) {
                return new GroupPropertyHandle(this, propDefn);
            }
            ++i;
        }
        return null;
    }

    protected boolean isInGroup(DesignElementHandle element) {
        return this.elements.contains(element);
    }
}

