/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.activity.RecordTask;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ExtensionPropertyDefinitionEvent;
import org.eclipse.birt.report.model.api.command.PropertyEvent;
import org.eclipse.birt.report.model.api.extension.IElementCommand;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.ExtendedItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtensionActivityRecord
extends ActivityRecord {
    private IElementCommand extRecord = null;
    private DesignElement element = null;
    private String propName = null;

    public ExtensionActivityRecord(IElementCommand extCommand) {
        assert (extCommand != null);
        this.extRecord = extCommand;
        this.setLabel(extCommand.getLabel());
        if (extCommand.getElementHandle() != null) {
            this.element = extCommand.getElementHandle().getElement();
        }
    }

    @Override
    public boolean canRedo() {
        return this.extRecord.canRedo();
    }

    @Override
    public boolean canUndo() {
        return this.extRecord.canUndo();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    public int getTransNo() {
        return super.getTransNo();
    }

    @Override
    public void execute() {
        this.extRecord.execute();
    }

    @Override
    public void undo() {
        this.extRecord.undo();
    }

    @Override
    public void redo() {
        this.extRecord.redo();
    }

    public DesignElement getTarget() {
        return this.element;
    }

    private NotificationEvent getEvent() {
        assert (this.element != null);
        NotificationEvent event = null;
        assert (this.element instanceof ExtendedItem);
        IReportItem extElement = ((ExtendedItem)this.element).getExtendedElement();
        event = extElement != null && extElement.refreshPropertyDefinition() ? new ExtensionPropertyDefinitionEvent(this.element) : new PropertyEvent(this.element, this.propName);
        return event;
    }

    @Override
    public void rollback() {
        this.undo();
        this.setState(2);
    }

    @Override
    protected List<RecordTask> getPostTasks() {
        if (this.element == null) {
            return Collections.emptyList();
        }
        ArrayList<RecordTask> retList = new ArrayList<RecordTask>();
        retList.add(new NotificationRecordTask(this.element, this.getEvent()));
        return retList;
    }
}

