/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.FileUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.activity.CuptiActivityFunction;
import com.nvidia.viper.activity.CuptiActivityInstructionExecution;
import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultInstructionExecution;
import com.nvidia.viper.editor.SourceSassEditorInput;
import com.nvidia.viper.jni.NativeDemangler;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SourceSassModel;
import com.nvidia.viper.ui.analysis.AnalysisResultControl;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class InstructionExecutionResultControl
extends AnalysisResultControl {
    private IEditorPart editor = null;

    public InstructionExecutionResultControl(Composite parent, AnalysisResult result, Session session) {
        super(parent, result, session);
        this.activeSession.addPropertyChangeListener(new ISessionPropertyChangeListener(){

            @Override
            public void propertyChange(IModel model, String propertyName) {
                if ("session:timelinereset".equals(propertyName) && InstructionExecutionResultControl.this.editor != null) {
                    InstructionExecutionResultControl.this.editor.getSite().getPage().closeEditor(InstructionExecutionResultControl.this.editor, false);
                }
            }
        });
    }

    @Override
    protected boolean allowsSelection() {
        return false;
    }

    @Override
    protected boolean hasExtension() {
        return true;
    }

    @Override
    protected void createExtension(Composite parent) {
        final HashMap<String, Integer> functionIdMap = new HashMap<String, Integer>();
        final HashMap<String, Integer> fileLineMap = new HashMap<String, Integer>();
        int total = 0;
        int max = 0;
        int count = 0;
        for (ICuptiActivitySourceLevelResult result : this.getSourceLevelResult().getSourceLevelResults()) {
            if (!(result instanceof CuptiActivityInstructionExecution)) continue;
            CuptiActivityInstructionExecution instExec = (CuptiActivityInstructionExecution)result;
            CuptiActivitySourceLocator locator = this.activeSession.getSourceLocator().getLocation(instExec.getSourceLocatorId());
            String fileName = locator.fileName;
            int lineNumber = locator.lineNumber;
            if (!fileLineMap.containsKey(fileName)) {
                fileLineMap.put(fileName, lineNumber);
            } else if (lineNumber < (Integer)fileLineMap.get(fileName)) {
                fileLineMap.put(fileName, lineNumber);
            }
            CuptiActivityFunction function = this.activeSession.getCudaFunctionManager().getFunction(instExec.functionId);
            String funcName = NativeDemangler.demangle(function.name);
            if (!functionIdMap.containsKey(funcName)) {
                functionIdMap.put(funcName, function.id);
            }
            if (instExec.executed > max) {
                max = instExec.executed;
            }
            total += instExec.executed;
            ++count;
        }
        Label label = new Label(parent, 0);
        label.setText("Cuda Functions :");
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        final List listFunctions = new List(parent, 2560);
        listFunctions.setLayoutData((Object)new GridData(4, 4, true, true));
        listFunctions.setItems(functionIdMap.keySet().toArray(new String[functionIdMap.size()]));
        label = new Label(parent, 0);
        label.setText("Maximum instruction execution count: " + max);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(parent, 0);
        label.setText("Average instruction execution count: " + total / count);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        label = new Label(parent, 0);
        label.setText("Source files :");
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        final List listFiles = new List(parent, 2560);
        listFiles.setLayoutData((Object)new GridData(4, 4, true, true));
        listFiles.setItems(fileLineMap.keySet().toArray(new String[fileLineMap.size()]));
        listFunctions.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String function = listFunctions.getItem(listFunctions.getSelectionIndex());
                SourceSassModel model = new SourceSassModel(InstructionExecutionResultControl.this.activeSession, InstructionExecutionResultControl.this.getSourceLevelResult(), (Integer)functionIdMap.get(function));
                InstructionExecutionResultControl.this.openEditor(model);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        listFiles.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String fileName = listFiles.getItem(listFiles.getSelectionIndex());
                SourceSassModel model = new SourceSassModel(InstructionExecutionResultControl.this.activeSession, InstructionExecutionResultControl.this.getSourceLevelResult(), fileName, (Integer)fileLineMap.get(fileName));
                InstructionExecutionResultControl.this.openEditor(model);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    @Override
    public boolean grabsVerticalSpace() {
        return false;
    }

    private AnalysisResultInstructionExecution getSourceLevelResult() {
        return (AnalysisResultInstructionExecution)this.result;
    }

    private void openEditor(SourceSassModel model) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (FileUtils.resolveFilePathInBrowser(model.getLocatorToOpen(), this.activeSession) != null) {
            try {
                this.editor = activePage.openEditor((IEditorInput)new SourceSassEditorInput(model), "com.nvidia.viper.sourcesasseditor");
            }
            catch (PartInitException e1) {
                ViperExceptionHandler.handle(ViperMessages.Instruction_Execution_Failed_Title, ViperMessages.Instruction_Execution_Failed_Message, new ViperException(e1));
            }
        }
    }
}

