/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.cuda.ide.util.ColumnsDragSupport;
import com.nvidia.viper.BandwidthFormatter;
import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.FlopsFormatter;
import com.nvidia.viper.FrequencyFormatter;
import com.nvidia.viper.PowerFormatter;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperComputeDictionary;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.activity.CuptiActivityComputeApiKind;
import com.nvidia.viper.activity.CuptiActivityMarkerData;
import com.nvidia.viper.activity.CuptiActivityMemoryKind;
import com.nvidia.viper.activity.CuptiDeviceAttribute;
import com.nvidia.viper.activity.CuptiEnvironmentClocksThrottleReason;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultGPUCompute;
import com.nvidia.viper.analysis.AnalysisResultGPUComputeEfficiency;
import com.nvidia.viper.analysis.AnalysisResultGPUOverlap;
import com.nvidia.viper.analysis.AnalysisResultGlobalMemoryEfficiency;
import com.nvidia.viper.analysis.AnalysisResultInterval;
import com.nvidia.viper.analysis.AnalysisResultKernelExecutionEfficiency;
import com.nvidia.viper.analysis.AnalysisResultKernelOccupancy;
import com.nvidia.viper.analysis.AnalysisResultLocalMemoryOverhead;
import com.nvidia.viper.analysis.AnalysisResultMemcpyOverlap;
import com.nvidia.viper.analysis.AnalysisResultMemcpySize;
import com.nvidia.viper.analysis.AnalysisResultMemcpyThroughput;
import com.nvidia.viper.analysis.AnalysisResultOccupancy;
import com.nvidia.viper.analysis.AnalysisResultSharedMemoryEfficiency;
import com.nvidia.viper.analysis.AnalysisResultWarpExecutionEfficiency;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.jni.CuCacheConfig;
import com.nvidia.viper.jni.CuptiMetricValueKind;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.ComputeLimits;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineContext;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalAPI;
import com.nvidia.viper.model.TimelineIntervalEnvironment;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalMarker;
import com.nvidia.viper.model.TimelineIntervalMemcpy;
import com.nvidia.viper.model.TimelineIntervalMemset;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.model.TimelineIntervalRange;
import com.nvidia.viper.model.TimelineIntervalUVM;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineMemcpy;
import com.nvidia.viper.model.TimelineUVM;
import com.nvidia.viper.ui.PreciseTimeFormatter;
import com.nvidia.viper.ui.UIUtils;
import com.nvidia.viper.value.IValue;
import com.nvidia.viper.value.ValueBandwidth;
import com.nvidia.viper.value.ValueByteSize;
import com.nvidia.viper.value.ValuePercent;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TimelinePropertyComposite
extends Composite
implements ISessionPropertyChangeListener {
    private static NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    private static NumberFormat percentIntegerFormatter = NumberFormat.getPercentInstance();
    private static NumberFormat numberFormatter = NumberFormat.getInstance();
    private Session activeSession;
    protected TimelineIntervalPair input;
    private final Map<TreeItem, String> nodeTooltips = new HashMap<TreeItem, String>();
    private final Label title;
    private final Label note;
    private final Tree tree;
    private final TreeColumn nameColumn;
    private final TreeColumn valueColumn;

    static {
        numberFormatter.setMaximumFractionDigits(32);
        numberFormatter.setGroupingUsed(false);
        percentFormatter.setMaximumFractionDigits(32);
        percentFormatter.setGroupingUsed(false);
        percentIntegerFormatter.setMaximumFractionDigits(0);
        percentIntegerFormatter.setGroupingUsed(false);
    }

    public TimelinePropertyComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        this.setLayout((Layout)gl);
        this.title = new Label((Composite)this, 0);
        GridData gd = new GridData(4, 128, true, false);
        gd.verticalIndent = 5;
        gd.horizontalIndent = 5;
        this.title.setLayoutData((Object)gd);
        UIUtils.boldFont((Control)this.title);
        this.note = new Label((Composite)this, 64);
        this.note.setLayoutData((Object)new GridData(4, 128, true, false));
        this.note.setText("Select or highlight a single interval to see properties");
        this.tree = new Tree((Composite)this, 2816);
        this.tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(false);
        new ColumnsDragSupport(this.tree);
        this.nameColumn = new TreeColumn(this.tree, 0);
        this.nameColumn.setText("Name");
        this.valueColumn = new TreeColumn(this.tree, 0);
        this.valueColumn.setText("Value");
        this.tree.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                TreeItem item = TimelinePropertyComposite.this.tree.getItem(new Point(e.x, e.y));
                String toolTip = (String)TimelinePropertyComposite.this.nodeTooltips.get(item);
                if (item != null && toolTip != null) {
                    TimelinePropertyComposite.this.tree.setToolTipText((String)TimelinePropertyComposite.this.nodeTooltips.get(item));
                } else {
                    TimelinePropertyComposite.this.tree.setToolTipText(null);
                }
            }

            public void mouseExit(MouseEvent e) {
                TimelinePropertyComposite.this.tree.setToolTipText(null);
            }

            public void mouseEnter(MouseEvent e) {
                TimelinePropertyComposite.this.tree.setToolTipText(null);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TimelinePropertyComposite.this.activeSession != null) {
                    TimelinePropertyComposite.this.activeSession.removePropertyChangeListener(TimelinePropertyComposite.this);
                }
            }
        });
    }

    protected void checkSubclass() {
        assert (this.getClass() == TimelinePropertyComposite.class);
    }

    protected void setInput(TimelineIntervalPair pair, boolean force) {
        boolean changed;
        boolean bl = !force && (this.input == null ? pair == null : this.input.equals(pair)) ? false : (changed = true);
        if (changed) {
            this.input = pair;
            this.setTitle(null, null);
            this.tree.removeAll();
            if (this.input == null) {
                ((GridData)this.note.getLayoutData()).exclude = false;
                this.note.setVisible(true);
            } else {
                ((GridData)this.note.getLayoutData()).exclude = true;
                this.note.setVisible(false);
                ITimelineInterval interval = this.input.getInterval();
                Timeline timeline = this.input.getTimeline();
                if (interval != null) {
                    if (interval instanceof TimelineIntervalAPI) {
                        this.showAPIInterval(timeline, (TimelineIntervalAPI)interval);
                    } else if (interval instanceof TimelineIntervalKernel) {
                        this.showKernelInterval(timeline, (TimelineIntervalKernel)interval, null);
                    } else if (interval instanceof TimelineIntervalMemcpy) {
                        this.showMemcpyInterval(timeline, (TimelineIntervalMemcpy)interval, null);
                    } else if (interval instanceof TimelineIntervalMemset) {
                        this.showMemsetInterval(timeline, (TimelineIntervalMemset)interval, null);
                    } else if (interval instanceof TimelineIntervalMarker) {
                        this.showMarkerInterval(timeline, (TimelineIntervalMarker)interval);
                    } else if (interval instanceof TimelineIntervalRange) {
                        this.showRangeInterval(timeline, (TimelineIntervalRange)interval);
                    } else if (interval instanceof TimelineIntervalEnvironment) {
                        this.showEnvironmentInterval(timeline, (TimelineIntervalEnvironment)interval);
                    } else if (interval instanceof TimelineIntervalUVM) {
                        this.showUVMInterval(timeline, (TimelineIntervalUVM)interval, null);
                    } else {
                        this.showInterval(timeline, interval);
                    }
                } else if (timeline != null) {
                    if (TimelineKind.KERNELS.equals((Object)timeline.getKind())) {
                        this.showComputeTimeline(timeline);
                    } else if (timeline instanceof TimelineKernel) {
                        this.showKernelTimeline((TimelineKernel)timeline);
                    } else if (timeline instanceof TimelineMemcpy) {
                        this.showMemcpyTimeline((TimelineMemcpy)timeline);
                    } else if (timeline instanceof TimelineUVM) {
                        this.showUVMTimeline((TimelineUVM)timeline);
                    } else if (timeline instanceof TimelineDevice) {
                        this.showDeviceTimeline((TimelineDevice)timeline);
                    } else if (timeline.getKind().isAPI()) {
                        this.showAPITimeline(timeline);
                    } else {
                        this.showTimeline(timeline);
                    }
                }
                if (this.nameColumn.getWidth() == 0 || this.valueColumn.getWidth() == 0) {
                    int width = this.tree.getClientArea().width;
                    this.nameColumn.setWidth((int)(0.7 * (double)width));
                    this.valueColumn.setWidth(width - this.nameColumn.getWidth());
                }
            }
            this.tree.getParent().layout(true);
        }
    }

    protected void setTitle(String name, String tooltip) {
        if (name != null) {
            name = StringUtils.getBoundedText(name, new Dimension(this.title.getSize()), this.title.getFont(), 1);
        }
        this.title.setText(name == null ? "" : name);
        this.title.setToolTipText(tooltip);
    }

    protected void showInterval(Timeline timeline, ITimelineInterval interval) {
        this.setTitle(interval.getDisplayName(), interval.getDisplayName());
        this.addNode(null, "Start", new PreciseTimeFormatter(interval.getStart()), null, "The start time for the timeline interval");
        this.addNode(null, "End", new PreciseTimeFormatter(interval.getEnd()), null, "The end time for the timeline interval");
        this.addNode(null, "Duration", new PreciseTimeFormatter(interval.getDuration()), null, "The duration of the timeline interval");
    }

    private void showEnvironmentInterval(Timeline timeline, TimelineIntervalEnvironment interval) {
        this.setTitle(interval.getDisplayName(), interval.getDisplayName());
        this.addNode(null, "Timestamp", new PreciseTimeFormatter(interval.getStart()), null, null);
        switch (interval.getEnvironmentKind()) {
            case CUPTI_ACTIVITY_ENVIRONMENT_SPEED: {
                if (interval.getSmClock() > -1) {
                    this.addNode(null, "SM clock", new FrequencyFormatter().format((long)interval.getSmClock() * 1000000L), null, null);
                }
                if (interval.getMemoryClock() > -1) {
                    this.addNode(null, "Memory Clock", new FrequencyFormatter().format((long)interval.getMemoryClock() * 1000000L), null, null);
                }
                if (interval.getPcieLinkGen() > -1) {
                    this.addNode(null, "PCIe Link Gen", interval.getPcieLinkGen(), null, null);
                }
                if (interval.getPcieLinkWidth() > -1) {
                    this.addNode(null, "PCIe Link Width", interval.getPcieLinkWidth(), null, null);
                }
                if (interval.getClocksThrottleReasons() == null) break;
                String str = "";
                CuptiEnvironmentClocksThrottleReason[] cuptiEnvironmentClocksThrottleReasonArray = interval.getClocksThrottleReasons();
                int n = cuptiEnvironmentClocksThrottleReasonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CuptiEnvironmentClocksThrottleReason cuptiEnvironmentClocksThrottleReason = cuptiEnvironmentClocksThrottleReasonArray[n2];
                    if (!cuptiEnvironmentClocksThrottleReason.equals((Object)CuptiEnvironmentClocksThrottleReason.CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTED) && !cuptiEnvironmentClocksThrottleReason.equals((Object)CuptiEnvironmentClocksThrottleReason.CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWN)) {
                        str = String.valueOf(str) + (str.isEmpty() ? "" : ", ") + cuptiEnvironmentClocksThrottleReason.getName();
                    }
                    ++n2;
                }
                if (str.isEmpty()) break;
                this.addNode(null, "Clocks Throttle Reasons", str, null, null);
                break;
            }
            case CUPTI_ACTIVITY_ENVIRONMENT_POWER: {
                if (interval.getPower() > -1) {
                    this.addNode(null, "Power", new PowerFormatter().format((double)interval.getPower() / 1000.0), null, null);
                }
                if (interval.getPowerLimit() <= -1) break;
                this.addNode(null, "Power limit", new PowerFormatter().format((double)interval.getPowerLimit() / 1000.0), null, null);
                break;
            }
            case CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE: {
                if (interval.getGpuTemperature() <= -1) break;
                this.addNode(null, "Temperature", String.valueOf(interval.getGpuTemperature()) + " C", null, null);
                break;
            }
            case CUPTI_ACTIVITY_ENVIRONMENT_COOLING: {
                if (interval.getFanSpeed() <= -1) break;
                this.addNode(null, "Fan", percentIntegerFormatter.format((double)interval.getFanSpeed() / 100.0), null, null);
                break;
            }
        }
    }

    private void showUVMInterval(Timeline timeline, TimelineIntervalUVM interval, TreeItem subTree) {
        this.setTitle(interval.getDisplayName(), interval.getDisplayName());
        this.addNode(subTree, "Sample Start", new PreciseTimeFormatter(interval.getStart()), null, "The start time for the sampling of unified memory data migration");
        this.addNode(subTree, "Sample End", new PreciseTimeFormatter(interval.getEnd()), null, "The end time for the sampling of unified memory data migration");
        this.addNode(subTree, "Sample Duration", new PreciseTimeFormatter(interval.getDuration()), null, "The time duration of the sampling of unified memory data migration");
        switch (interval.getKind()) {
            case UVM_MEMCPY_HTOD: 
            case UVM_MEMCPY_DTOH: {
                this.addNode(subTree, "Size", new ValueByteSize(ByteSizeFormatter.Base.KILOBYTE, interval.getCounterValue()), null, "The bytes transferred during the sampling of unified memory data migration");
                break;
            }
            case UVM_PAGE_FAULT: {
                this.addNode(subTree, "CPU Page Faults", interval.getCounterValue(), null, "The page faults occurred during the sampling of unified memory data migration");
            }
        }
        this.addNode(subTree, "Process", interval.getProcessId(), null, "The process id of the interval");
    }

    protected void showMarkerInterval(Timeline timeline, TimelineIntervalMarker marker) {
        this.setTitle(marker.getDisplayName(), marker.getDisplayName());
        this.addNode(null, "Timestamp", new PreciseTimeFormatter(marker.getStart()), null, "The marker timestamp");
        if (marker.getMarkerData() != null) {
            this.addMarkerData(null, marker.getMarkerData());
        }
    }

    protected void showRangeInterval(Timeline timeline, TimelineIntervalRange range) {
        this.setTitle(range.getDisplayName(), range.getDisplayName());
        this.addNode(null, "Start", new PreciseTimeFormatter(range.getStart()), null, "The start time for the range");
        this.addNode(null, "End", new PreciseTimeFormatter(range.getEnd()), null, "The end time for the range");
        this.addNode(null, "Duration", new PreciseTimeFormatter(range.getDuration()), null, "The duration of the range");
        if (range.getMarkerData() != null) {
            this.addMarkerData(null, range.getMarkerData());
        }
    }

    protected void showAPIInterval(Timeline timeline, TimelineIntervalAPI api) {
        this.addNode(null, "Start", new PreciseTimeFormatter(api.getStart()), null, "The start time for the CUDA API call");
        this.addNode(null, "End", new PreciseTimeFormatter(api.getEnd()), null, "The end time for the CUDA API call");
        this.addNode(null, "Duration", new PreciseTimeFormatter(api.getDuration()), null, "The duration of the CUDA API call");
        HashSet<TimelineIntervalHierarchy> family = new HashSet<TimelineIntervalHierarchy>();
        TimelineIntervalHierarchy oldest = api.getOldestAncestor();
        this.activeSession.getHostLaunchedDescendants(oldest, family);
        this.setTitle(api.getDisplayName(), api.getDisplayName());
        for (TimelineIntervalHierarchy corr : family) {
            Timeline corrTimeline;
            if (corr instanceof TimelineIntervalKernel) {
                Dimension bounds = FigureUtilities.getStringExtents((String)"W", (Font)this.getFont());
                bounds.height = Integer.MAX_VALUE;
                bounds.width *= 100;
                String tooltip = StringUtils.getBoundedText("CUDA API call that launches kernel " + corr.getDisplayName(), bounds, this.getFont(), 100);
                this.setTitle("Launch " + corr.getDisplayName(), tooltip);
            }
            if (corr == null || (corrTimeline = corr.getPrimaryTimeline()) == null) continue;
            if (corr instanceof TimelineIntervalMemcpy) {
                TreeItem memcpy = this.addNode(null, "Memory Copy", null, null, null);
                this.showMemcpyInterval(corrTimeline, (TimelineIntervalMemcpy)corr, memcpy);
                memcpy.setExpanded(true);
                continue;
            }
            if (corr instanceof TimelineIntervalKernel) {
                TreeItem kernel = this.addNode(null, "Kernel", null, null, null);
                this.showKernelInterval(corrTimeline, (TimelineIntervalKernel)corr, kernel);
                kernel.setExpanded(true);
                TreeItem[] treeItemArray = kernel.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem ti = treeItemArray[n2];
                    ti.setExpanded(true);
                    ++n2;
                }
                continue;
            }
            if (!(corr instanceof TimelineIntervalMemset)) continue;
            TreeItem memset = this.addNode(null, "Memory Set", null, null, null);
            this.showMemsetInterval(corrTimeline, (TimelineIntervalMemset)corr, memset);
            memset.setExpanded(true);
        }
    }

    protected void showKernelInterval(Timeline timeline, TimelineIntervalKernel kernel, TreeItem subTree) {
        ComputeLimits computeLimits;
        Integer[] block;
        Integer[] grid;
        CuptiActivityComputeApiKind computeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
        TimelineContext ctxTimeline = (TimelineContext)timeline.getAncestor(TimelineKind.CONTEXT);
        if (ctxTimeline != null) {
            computeKind = ctxTimeline.getComputeKind();
        }
        TimelineDevice deviceTimeline = (TimelineDevice)timeline.getAncestor(TimelineKind.DEVICE);
        String name = kernel.getDisplayName();
        String tooltip = "Kernel " + name;
        if (subTree == null) {
            this.setTitle(name, tooltip);
        } else {
            this.addNode(subTree, "Name", name, null, null);
        }
        this.addNode(subTree, "Start", new PreciseTimeFormatter(kernel.getStart()), null, "The time that the first thread begins executing the kernel");
        this.addNode(subTree, "End", new PreciseTimeFormatter(kernel.getEnd()), null, "The time that the last thread finishes executing the kernel");
        Long minCompleted = kernel.getCompleted(true);
        if (minCompleted != null) {
            this.addNode(subTree, "Completion", new PreciseTimeFormatter(minCompleted), null, "The latest end time for all descendant kernels launched by this kernel");
        }
        this.addNode(subTree, "Duration", new PreciseTimeFormatter(kernel.getDuration()), null, "The duration of the kernel execution (end time - start time)");
        if (minCompleted != null) {
            this.addNode(subTree, "Completion Duration", new PreciseTimeFormatter(minCompleted - kernel.getEnd()), null, "The duration of the kernel completion (completion time - end time)");
        }
        if (System.getenv("VIPER_DEBUG") != null) {
            Long completed;
            Long submitted;
            TreeItem schedNode = this.addNode(subTree, "Scheduler", null, null, null);
            Long queued = kernel.getQueued();
            if (queued != null) {
                this.addNode(schedNode, "Queued", new PreciseTimeFormatter(queued), null, "The time when the kernel is queued in the scheduler");
            }
            if ((submitted = kernel.getSubmitted()) != null) {
                this.addNode(schedNode, "Submitted", new PreciseTimeFormatter(submitted), null, "The time when the kernel is submitted to the GPU for execution");
            }
            if ((completed = kernel.getCompleted(false)) != null) {
                this.addNode(schedNode, "Completed", new PreciseTimeFormatter(completed), null, "The time when the scheduler reports the kernel as completed");
            }
            if (schedNode.getItemCount() > 0) {
                schedNode.setExpanded(true);
            } else {
                schedNode.dispose();
            }
        }
        if ((grid = kernel.getGrid()) != null && grid[0] != null && grid[1] != null && grid[2] != null) {
            this.addNode(subTree, String.valueOf(ViperComputeDictionary.GRID.getLabel(computeKind)) + " Size", "[ " + grid[0] + "," + grid[1] + "," + grid[2] + " ]", null, "The grid dimensions for the kernel launch");
        }
        if ((block = kernel.getBlock()) != null && block[0] != null && block[1] != null && block[2] != null) {
            this.addNode(subTree, String.valueOf(ViperComputeDictionary.BLOCK.getLabel(computeKind)) + " Size", "[ " + block[0] + "," + block[1] + "," + block[2] + " ]", null, "The block dimensions for the kernel launch");
        }
        if (kernel.getRegistersPerThread() != null) {
            this.addNode(subTree, "Registers/" + ViperComputeDictionary.THREAD.getLabel(computeKind), kernel.getRegistersPerThread(), null, "The number of registers required for each thread executing the kernel");
        }
        if (kernel.getStaticSharedMemory() != null && kernel.getDynamicSharedMemory() != null) {
            ValueByteSize sharedMemPerBlock = new ValueByteSize(ByteSizeFormatter.Base.KIBIBYTE, kernel.getStaticSharedMemory() + kernel.getDynamicSharedMemory());
            this.addNode(subTree, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + "  Memory/" + ViperComputeDictionary.BLOCK.getLabel(computeKind), sharedMemPerBlock, null, "The amount of shared memory required for each block executing the kernel");
        }
        Analysis analysis = this.activeSession.getAnalysis();
        TreeItem effNode = null;
        if (analysis != null) {
            IValue memEfficiency;
            boolean foundGld = false;
            boolean foundGst = false;
            List<AnalysisResult> globalMemoryEffResults = analysis.getAnalysisResults(AnalysisStage.KERNELS_PERFORMANCE, AnalysisResultGlobalMemoryEfficiency.class);
            for (AnalysisResult result : globalMemoryEffResults) {
                boolean isLoad;
                AnalysisResultGlobalMemoryEfficiency gmemResult = (AnalysisResultGlobalMemoryEfficiency)result;
                if (!gmemResult.containsInterval(kernel) || (!(isLoad = gmemResult.isLoad()) || foundGld) && (isLoad || foundGst)) continue;
                memEfficiency = gmemResult.getValue(kernel);
                if (memEfficiency != null) {
                    if (effNode == null) {
                        effNode = this.addNode(subTree, "Efficiency", null, null, null);
                    }
                    if (memEfficiency.equals(new ValuePercent(0.0))) {
                        this.addNode(effNode, "Global " + (isLoad ? "Load" : "Store") + " Efficiency", "n/a", null, gmemResult.getValueDescription(kernel));
                    } else {
                        this.addNode(effNode, "Global " + (isLoad ? "Load" : "Store") + " Efficiency", memEfficiency, this.getAnalysisImage(result.getSeverity()), gmemResult.getValueDescription(kernel));
                    }
                }
                if ((foundGld |= isLoad) && (foundGst |= !isLoad)) break;
            }
            List<AnalysisResult> sharedMemoryEffResults = analysis.getAnalysisResults(AnalysisStage.KERNELS_PERFORMANCE, AnalysisResultSharedMemoryEfficiency.class);
            for (AnalysisResult result : sharedMemoryEffResults) {
                AnalysisResultSharedMemoryEfficiency sharedResult = (AnalysisResultSharedMemoryEfficiency)result;
                if (!sharedResult.containsInterval(kernel)) continue;
                memEfficiency = sharedResult.getValue(kernel);
                if (memEfficiency == null) break;
                if (effNode == null) {
                    effNode = this.addNode(subTree, "Efficiency", null, null, null);
                }
                if (memEfficiency.equals(new ValuePercent(0.0))) {
                    this.addNode(effNode, "Shared Efficiency", "n/a", null, sharedResult.getValueDescription(kernel));
                    break;
                }
                this.addNode(effNode, "Shared Efficiency", memEfficiency, this.getAnalysisImage(result.getSeverity()), sharedResult.getValueDescription(kernel));
                break;
            }
            List<AnalysisResult> lmemOverheadResults = analysis.getAnalysisResults(AnalysisStage.KERNEL_INSTANCE_MEMORY, AnalysisResultLocalMemoryOverhead.class);
            for (AnalysisResult result : lmemOverheadResults) {
                AnalysisResultLocalMemoryOverhead overheadResult = (AnalysisResultLocalMemoryOverhead)result;
                if (overheadResult.getKernel() != kernel) continue;
                IValue overhead = overheadResult.getOverheadValue();
                if (overhead == null) break;
                if (effNode == null) {
                    effNode = this.addNode(subTree, "Efficiency", null, null, null);
                }
                this.addNode(effNode, "Local Memory Overhead", overhead, this.getAnalysisImage(result.getSeverity()), overheadResult.getOverheadValueDescription());
                break;
            }
            IValue execEffValue = null;
            IValue nonpredExecEffValue = null;
            Object execEffSeverity = AnalysisDescriptor.Severity.OK;
            String execEffDesc = null;
            String nonpredExecEffDesc = null;
            List<AnalysisResult> warpExecResults = analysis.getAnalysisResults(AnalysisStage.KERNELS_PERFORMANCE, AnalysisResultWarpExecutionEfficiency.class);
            for (AnalysisResult result : warpExecResults) {
                AnalysisResultWarpExecutionEfficiency weeResult = (AnalysisResultWarpExecutionEfficiency)result;
                if (!weeResult.containsInterval(kernel)) continue;
                execEffValue = weeResult.getValue(kernel);
                nonpredExecEffValue = weeResult.getNonPredicatedValue(kernel);
                execEffDesc = weeResult.getValueDescription(kernel);
                nonpredExecEffDesc = weeResult.getNonPredicatedValueDescription(kernel);
                execEffSeverity = weeResult.getSeverity();
                break;
            }
            if (execEffValue == null) {
                List<AnalysisResult> kernelWarpExecResults = analysis.getAnalysisResults(AnalysisStage.KERNEL_INSTANCE_SM, AnalysisResultKernelExecutionEfficiency.class);
                for (AnalysisResult result : kernelWarpExecResults) {
                    AnalysisResultKernelExecutionEfficiency weeResult = (AnalysisResultKernelExecutionEfficiency)result;
                    if (weeResult.getKernel() != kernel) continue;
                    execEffValue = weeResult.getValue();
                    nonpredExecEffValue = weeResult.getNonPredicatedValue();
                    execEffDesc = weeResult.getValueDescription();
                    nonpredExecEffDesc = weeResult.getNonPredicatedValueDescription();
                    execEffSeverity = weeResult.getSeverity();
                    break;
                }
            }
            if (execEffValue != null) {
                if (effNode == null) {
                    effNode = this.addNode(subTree, "Efficiency", null, null, null);
                }
                this.addNode(effNode, "Warp Execution Efficiency", execEffValue, this.getAnalysisImage((AnalysisDescriptor.Severity)((Object)execEffSeverity)), execEffDesc);
                if (nonpredExecEffValue != null) {
                    this.addNode(effNode, "Non-Predicated Warp Execution Efficiency", nonpredExecEffValue, this.getAnalysisImage((AnalysisDescriptor.Severity)((Object)execEffSeverity)), nonpredExecEffDesc);
                }
            }
        }
        TreeItem occupancyNode = null;
        Double occupancy = null;
        if (analysis != null) {
            AnalysisResult occupancyResult;
            IValue occupancyValue = null;
            AnalysisDescriptor.Severity occupancySeverity = AnalysisDescriptor.Severity.OK;
            String occupancyDesc = null;
            List<AnalysisResult> occupancyResults = analysis.getAnalysisResults(AnalysisStage.KERNELS, AnalysisResultOccupancy.class);
            for (AnalysisResult result : occupancyResults) {
                occupancyResult = (AnalysisResultOccupancy)result;
                if (!((AnalysisResultInterval)occupancyResult).containsInterval(kernel)) continue;
                occupancy = (Double)((AnalysisResultInterval)occupancyResult).getData(kernel);
                occupancyValue = ((AnalysisResultOccupancy)occupancyResult).getValue(kernel);
                occupancySeverity = occupancyResult.getSeverity();
                occupancyDesc = ((AnalysisResultOccupancy)occupancyResult).getValueDescription(kernel);
                break;
            }
            if (occupancyValue == null) {
                occupancyResults = analysis.getAnalysisResults(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelOccupancy.class);
                for (AnalysisResult result : occupancyResults) {
                    occupancyResult = (AnalysisResultKernelOccupancy)result;
                    if (((AnalysisResultKernelOccupancy)occupancyResult).getKernel() != kernel) continue;
                    occupancy = ((AnalysisResultKernelOccupancy)occupancyResult).getAchievedOccupancy();
                    occupancyValue = new ValuePercent(occupancy * 100.0);
                    break;
                }
            }
            if (occupancyValue != null) {
                if (occupancyNode == null) {
                    occupancyNode = this.addNode(subTree, "Occupancy", null, null, null);
                }
                this.addNode(occupancyNode, "Achieved", occupancyValue, this.getAnalysisImage(occupancySeverity), occupancyDesc);
            }
        }
        if (timeline != null && deviceTimeline != null) {
            OccupancyCalculator.Limiter limiter;
            OccupancyCalculator oc = new OccupancyCalculator(kernel, deviceTimeline);
            Double theoreticalOccupancy = oc.getTheoreticOccupancy();
            if (theoreticalOccupancy != null) {
                ValuePercent toc = new ValuePercent(theoreticalOccupancy * 100.0);
                if (occupancyNode == null) {
                    occupancyNode = this.addNode(subTree, "Occupancy", null, null, null);
                }
                this.addNode(occupancyNode, "Theoretical", toc, null, "The peak occupancy based on block size, register usage, shared memory usage, etc.");
            }
            if ((limiter = oc.getLimiter()).isKnownLimit() && occupancy != null && occupancy < 0.5) {
                if (occupancyNode == null) {
                    occupancyNode = this.addNode(subTree, "Occupancy", null, null, null);
                }
                this.addNode(occupancyNode, "Limiter", oc.isGridSizeLimited() ? "Grid Size" : limiter, null, null);
            }
        }
        if (kernel.getParent() instanceof TimelineIntervalKernel) {
            TimelineIntervalKernel parent = (TimelineIntervalKernel)kernel.getParent();
            TreeItem parentNode = this.addNode(subTree, "Parent Kernel", null, null, null);
            this.addNode(parentNode, "Name", parent.getDisplayName(), null, null);
            Integer[] parentBlock = kernel.getParentBlock();
            if (parentBlock != null && parentBlock[0] != null && parentBlock[1] != null && parentBlock[2] != null) {
                this.addNode(parentNode, "Launch " + ViperComputeDictionary.BLOCK.getLabel(computeKind), "[ " + parentBlock[0] + "," + parentBlock[1] + "," + parentBlock[2] + " ]", null, "The parent block containing the thread that launched this kernel");
            }
            parentNode.setExpanded(true);
        }
        if (deviceTimeline != null && (computeLimits = ComputeLimits.getComputeLimits(deviceTimeline.getComputeCapabilityMajor(), deviceTimeline.getComputeCapabilityMinor())) != null) {
            CuCacheConfig ccRequested = kernel.getCacheConfigRequested();
            Integer smemRequested = ccRequested == null ? -1 : computeLimits.getSharedMemorySize(ccRequested);
            CuCacheConfig ccExecuted = kernel.getCacheConfigExecuted();
            Integer smemExecuted = ccExecuted == null ? -1 : computeLimits.getSharedMemorySize(ccExecuted);
            Integer smemConfig = kernel.getSharedMemoryBankSize();
            if (smemRequested != null || smemExecuted != null || smemConfig != null) {
                TreeItem smemConfigNode = this.addNode(subTree, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + " Memory Configuration", null, null, null);
                if (smemRequested != null) {
                    this.addNode(smemConfigNode, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + " Memory Requested", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(smemRequested.intValue()), null, null);
                }
                if (smemExecuted != null) {
                    this.addNode(smemConfigNode, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + " Memory Executed", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(smemExecuted.intValue()), null, null);
                }
                if (smemConfig != null) {
                    this.addNode(smemConfigNode, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + " Memory Bank Size", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(smemConfig.intValue()), null, null);
                }
                smemConfigNode.setExpanded(true);
            }
        }
        if (effNode != null) {
            effNode.setExpanded(true);
        }
        if (occupancyNode != null) {
            occupancyNode.setExpanded(true);
        }
    }

    protected void showMemcpyInterval(Timeline timeline, TimelineIntervalMemcpy memcpy, TreeItem subTree) {
        String name = memcpy.getDisplayName();
        String tooltip = String.valueOf(memcpy.isAsync() ? "Asynchronous " : "Synchronous ") + memcpy.getCopyKind().getLongName().toLowerCase(Locale.ENGLISH) + " memory copy";
        if (subTree == null) {
            this.setTitle(name, tooltip);
        } else {
            this.addNode(subTree, "Description", name, null, tooltip);
        }
        this.addNode(subTree, "Start", new PreciseTimeFormatter(memcpy.getStart()), null, "The start time for the memory copy");
        this.addNode(subTree, "End", new PreciseTimeFormatter(memcpy.getEnd()), null, "The end time for the memory copy");
        this.addNode(subTree, "Duration", new PreciseTimeFormatter(memcpy.getDuration()), null, "The time required to complete the memory copy");
        Analysis analysis = this.activeSession.getAnalysis();
        long bytes = memcpy.getBytes();
        if (bytes >= 0L) {
            CuptiActivityMemoryKind dstKind;
            Image sizeAnalysisImage = null;
            if (analysis != null) {
                List<AnalysisResult> sizeResults = analysis.getAnalysisResults(AnalysisStage.TIMELINE, AnalysisResultMemcpySize.class);
                for (AnalysisResult result : sizeResults) {
                    AnalysisResultMemcpySize sizeResult = (AnalysisResultMemcpySize)result;
                    if (!sizeResult.containsInterval(memcpy)) continue;
                    sizeAnalysisImage = this.getAnalysisImage(result.getSeverity());
                    break;
                }
            }
            this.addNode(subTree, "Size", new ValueByteSize(ByteSizeFormatter.Base.KILOBYTE, bytes), sizeAnalysisImage, null);
            Image bwAnalysisImage = null;
            if (analysis != null) {
                List<AnalysisResult> bwResults = analysis.getAnalysisResults(AnalysisStage.TIMELINE, AnalysisResultMemcpyThroughput.class);
                for (AnalysisResult result : bwResults) {
                    AnalysisResultMemcpyThroughput bwResult = (AnalysisResultMemcpyThroughput)result;
                    if (!bwResult.containsInterval(memcpy)) continue;
                    bwAnalysisImage = this.getAnalysisImage(result.getSeverity());
                    break;
                }
            }
            ValueBandwidth bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, memcpy.getThroughput());
            this.addNode(subTree, "Throughput", bwValue, bwAnalysisImage, null);
            TreeItem memKindNode = null;
            CuptiActivityMemoryKind srcKind = memcpy.getSrcMemoryKind();
            if (!srcKind.equals((Object)CuptiActivityMemoryKind.CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN)) {
                if (memKindNode == null) {
                    memKindNode = this.addNode(subTree, "Memory Type", null, null, null);
                }
                this.addNode(memKindNode, "Source", srcKind.getShortName(), null, srcKind.getLongName());
            }
            if (!(dstKind = memcpy.getDstMemoryKind()).equals((Object)CuptiActivityMemoryKind.CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN)) {
                if (memKindNode == null) {
                    memKindNode = this.addNode(subTree, "Memory Type", null, null, null);
                }
                this.addNode(memKindNode, "Destination", dstKind.getShortName(), null, dstKind.getLongName());
            }
            if (memKindNode != null) {
                memKindNode.setExpanded(true);
            }
            if (memcpy.getSourceDeviceId() > -1) {
                this.addNode(subTree, "Source Device", "[" + memcpy.getSourceDeviceId() + "]" + " " + this.activeSession.getDeviceName(memcpy.getSourceDeviceId()), null, null);
            }
            if (memcpy.getDestinationDeviceId() > -1) {
                this.addNode(subTree, "Destination Device", "[" + memcpy.getDestinationDeviceId() + "]" + " " + this.activeSession.getDeviceName(memcpy.getDestinationDeviceId()), null, null);
            }
        }
    }

    protected void showMemsetInterval(Timeline timeline, TimelineIntervalMemset memset, TreeItem subTree) {
        if (subTree == null) {
            this.setTitle(memset.getDisplayName(), memset.getDisplayName());
        } else {
            this.addNode(subTree, "Description", memset.getDisplayName(), null, null);
        }
        this.addNode(subTree, "Start", new PreciseTimeFormatter(memset.getStart()), null, "The start time for the memory set operation");
        this.addNode(subTree, "End", new PreciseTimeFormatter(memset.getEnd()), null, "The end time for the memory set operation");
        this.addNode(subTree, "Duration", new PreciseTimeFormatter(memset.getDuration()), null, "The time required to complete the memory set operation");
        this.addNode(subTree, "Value", memset.getValue(), null, null);
        this.addNode(subTree, "Size", new ValueByteSize(ByteSizeFormatter.Base.KILOBYTE, memset.getBytes()), null, null);
        ValueBandwidth bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, memset.getThroughput());
        this.addNode(subTree, "Throughput", bwValue, null, null);
    }

    protected void showTimeline(Timeline timeline) {
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        this.addDuration(null);
    }

    protected void showAPITimeline(Timeline timeline) {
        Timeline threadTimeline = timeline.getParent();
        if (threadTimeline != null && TimelineKind.THREAD.equals((Object)threadTimeline.getKind())) {
            this.setTitle(String.valueOf(timeline.getDisplayName(false)) + " [ " + threadTimeline.getDisplayName(false) + " ]", String.valueOf(timeline.getDisplayName(false)) + " invoked from " + threadTimeline.getDisplayName(false));
        } else {
            this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        }
        this.addDuration(null);
    }

    protected void showComputeTimeline(Timeline timeline) {
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        CuptiActivityComputeApiKind computeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
        TimelineContext ctxTimeline = (TimelineContext)timeline.getAncestor(TimelineKind.CONTEXT);
        if (ctxTimeline != null) {
            computeKind = ctxTimeline.getComputeKind();
            long totalExecTime = ctxTimeline.getTotalKernelExecutionTime();
            int totalInvocationCount = ctxTimeline.getTotalKernelInvocationCount();
            TreeItem duration = this.addDuration(null);
            this.addNode(duration, String.valueOf(ViperComputeDictionary.KERNEL.getLabel(computeKind)) + "s", new PreciseTimeFormatter(totalExecTime), null, "The total execution time for all kernels");
            ValuePercent utilValue = new ValuePercent(100.0 * ctxTimeline.getComputeUtilization());
            this.addNode(null, "Compute Utilization", utilValue, null, "The percentage of time that any kernel was executing");
            this.addNode(null, String.valueOf(ViperComputeDictionary.KERNEL.getLabel(computeKind)) + " Invocations", totalInvocationCount, null, "The total number of kernel invocations");
        }
    }

    protected void showKernelTimeline(TimelineKernel timeline) {
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        CuptiActivityComputeApiKind computeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
        TimelineContext ctxTimeline = (TimelineContext)timeline.getAncestor(TimelineKind.CONTEXT);
        if (ctxTimeline != null) {
            computeKind = ctxTimeline.getComputeKind();
        }
        TreeItem duration = this.addDuration(null);
        long selfExecTime = timeline.getSelfExecutionTime();
        long totalExecTime = timeline.getTotalExecutionTime();
        if (timeline.isContainer()) {
            this.addNode(duration, String.valueOf(ViperComputeDictionary.KERNEL.getLabel(computeKind)) + " (self)", new PreciseTimeFormatter(selfExecTime), null, "The total execution time for all instances of the kernel, not including descendant kernels");
            this.addNode(duration, String.valueOf(ViperComputeDictionary.KERNEL.getLabel(computeKind)) + " (total)", new PreciseTimeFormatter(totalExecTime), null, "The total execution time for all instances of the kernel and all instances of descendant kernels");
        } else {
            this.addNode(duration, ViperComputeDictionary.KERNEL.getLabel(computeKind), new PreciseTimeFormatter(totalExecTime), null, "The total execution time for all instances of the kernel");
        }
        int selfInvocations = timeline.getSelfInvocationCount();
        int totalInvocations = timeline.getTotalInvocationCount();
        if (timeline.isContainer()) {
            TreeItem invocations = this.addNode(null, "Invocations", null, null, null);
            this.addNode(invocations, "Self", selfInvocations, null, "The number of times this kernel was invoked, not including descendant kernels");
            this.addNode(invocations, "Total", totalInvocations, null, "The number of times this kernel and all descendant kernels were invoked");
            invocations.setExpanded(true);
        } else {
            this.addNode(null, "Invocations", totalInvocations, null, "The number of times this kernel was invoked");
        }
        ValuePercent selfExecRatioValue = new ValuePercent(100.0 * timeline.getSelfExecutionRatio());
        ValuePercent totalExecRatioValue = new ValuePercent(100.0 * timeline.getTotalExecutionRatio());
        if (timeline.isContainer()) {
            TreeItem execRatio = this.addNode(null, "Importance", null, null, null);
            this.addNode(execRatio, "Self", selfExecRatioValue, null, "The percentage of total GPU compute time spent executing instances of this kernel, not including descendant kernels");
            this.addNode(execRatio, "Total", totalExecRatioValue, null, "The percentage of total GPU compute time spent executing instances of this kernel and all descendant kernels");
            execRatio.setExpanded(true);
        } else {
            this.addNode(null, "Importance", totalExecRatioValue, null, "The percentage of total GPU compute time spent executing instances of this kernel");
        }
    }

    protected void showMemcpyTimeline(TimelineMemcpy timeline) {
        long totalExecTime = timeline.getTotalExecTime();
        long totalBytes = timeline.getTotalBytes();
        int invocations = timeline.getNumVisibleIntervals();
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        TreeItem duration = this.addDuration(null);
        this.addNode(duration, "Memcpys", new PreciseTimeFormatter(totalExecTime), null, "The total duration of all memory copies");
        this.addNode(null, "Invocations", invocations, null, "The total number of memory copies");
        if (totalBytes > 0L) {
            this.addNode(null, "Total Bytes", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(totalBytes), null, "The total number of bytes copied");
        }
        if (totalBytes > 0L) {
            ValueBandwidth bwValue = new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, totalBytes, totalExecTime);
            this.addNode(null, "Avg. Throughput", bwValue, null, "The average memory copy throughput");
        }
    }

    private void showUVMParentTimeline(TimelineUVM timeline) {
        List<Timeline> uvmTimelines = timeline.getChildren();
        for (Timeline uvmTimeline : uvmTimelines) {
            long totalValue;
            if (!(uvmTimeline instanceof TimelineUVM) || (totalValue = ((TimelineUVM)uvmTimeline).getTotalValue()) <= 0L) continue;
            switch (uvmTimeline.getKind()) {
                case UVM_PAGE_FAULT: {
                    this.addNode(null, "Total Page Faults", totalValue, null, "The total number of page faults");
                    break;
                }
                case UVM_MEMCPY_HTOD: {
                    this.addNode(null, "Total Bytes (HtoD)", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(totalValue), null, "The total number of bytes migrated from host to device");
                    break;
                }
                case UVM_MEMCPY_DTOH: {
                    this.addNode(null, "Total Bytes (DtoH)", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(totalValue), null, "The total number of bytes migrated from device to host");
                }
            }
        }
    }

    protected void showUVMTimeline(TimelineUVM timeline) {
        long totalValue = 0L;
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        this.addDuration(null);
        if (timeline.getKind().equals((Object)TimelineKind.UVM)) {
            this.showUVMParentTimeline(timeline);
        } else {
            int samples = timeline.getNumVisibleIntervals();
            if (samples > 0) {
                this.addNode(null, "Samples", samples, null, "The total number of samples for unified memory data migration");
            }
            if ((totalValue = timeline.getTotalValue()) > 0L) {
                switch (timeline.getKind()) {
                    case UVM_PAGE_FAULT: {
                        this.addNode(null, "Total Page Faults", totalValue, null, "The total number of page faults");
                        break;
                    }
                    case UVM_MEMCPY_HTOD: 
                    case UVM_MEMCPY_DTOH: {
                        this.addNode(null, "Total Bytes", new ByteSizeFormatter(ByteSizeFormatter.Base.KILOBYTE).format(totalValue), null, "The total number of bytes migrated");
                        break;
                    }
                }
            }
        }
    }

    protected void showDeviceTimeline(TimelineDevice timeline) {
        Number pciWidth;
        Number pciRate;
        Number flopDp;
        Integer[] block;
        Integer[] grid;
        CuptiActivityComputeApiKind computeKind = CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA;
        this.setTitle(timeline.getDisplayName(false), timeline.getDisplayName(false));
        this.addDuration(null);
        Analysis analysis = this.activeSession.getAnalysis();
        if (analysis != null) {
            TreeItem overlapNode = null;
            List<AnalysisResult> computeResults = analysis.getAnalysisResults(AnalysisStage.TIMELINE, AnalysisResultGPUCompute.class);
            for (AnalysisResult result : computeResults) {
                AnalysisResultGPUCompute timelineResult = (AnalysisResultGPUCompute)result;
                if (!timelineResult.containsTimeline(timeline)) continue;
                IValue util = timelineResult.getValue(timeline);
                if (util == null) break;
                this.addNode(null, "Compute Utilization", util, this.getAnalysisImage(result.getSeverity()), null);
                break;
            }
            List<AnalysisResult> memcpyResults = analysis.getAnalysisResults(AnalysisStage.TIMELINE, AnalysisResultGPUComputeEfficiency.class);
            for (AnalysisResult result : memcpyResults) {
                AnalysisResultGPUComputeEfficiency timelineResult = (AnalysisResultGPUComputeEfficiency)result;
                if (!timelineResult.containsTimeline(timeline)) continue;
                IValue util = timelineResult.getValue(timeline);
                if (util == null) break;
                this.addNode(null, "Compute/Memcpy", util, this.getAnalysisImage(result.getSeverity()), timelineResult.getValueDescription(timeline));
                break;
            }
            List<AnalysisResult> kmOverlapResults = analysis.getAnalysisResults(AnalysisStage.TIMELINE, AnalysisResultGPUOverlap.class);
            for (AnalysisResult result : kmOverlapResults) {
                AnalysisResultGPUOverlap timelineResult = (AnalysisResultGPUOverlap)result;
                if (!timelineResult.containsTimeline(timeline)) continue;
                IValue overlap = timelineResult.getValue(timeline);
                if (overlap == null) break;
                if (overlapNode == null) {
                    overlapNode = this.addNode(null, "Overlap", null, null, null);
                }
                this.addNode(overlapNode, String.valueOf(ViperComputeDictionary.KERNEL.getLabel(computeKind)) + "/Memcpy", overlap, this.getAnalysisImage(result.getSeverity()), timelineResult.getValueDescription(timeline));
                break;
            }
            List<AnalysisResult> mmOverlapResults = analysis.getAnalysisResults(AnalysisStage.TIMELINE, AnalysisResultMemcpyOverlap.class);
            for (AnalysisResult result : mmOverlapResults) {
                AnalysisResultMemcpyOverlap timelineResult = (AnalysisResultMemcpyOverlap)result;
                if (!timelineResult.containsTimeline(timeline)) continue;
                IValue overlap = timelineResult.getValue(timeline);
                if (overlap == null) break;
                if (overlapNode == null) {
                    overlapNode = this.addNode(null, "Overlap", null, null, null);
                }
                this.addNode(overlapNode, "Memcpy/Memcpy", overlap, this.getAnalysisImage(result.getSeverity()), timelineResult.getValueDescription(timeline));
                break;
            }
            if (overlapNode != null) {
                overlapNode.setExpanded(true);
            }
        }
        TreeItem attributesNode = this.addNode(null, "Attributes", null, null, null);
        if (timeline.getComputeCapabilityMajor() > 0) {
            this.addNode(attributesNode, "Compute Capability", String.valueOf(timeline.getComputeCapabilityMajor()) + "." + timeline.getComputeCapabilityMinor(), null, null);
        }
        TreeItem maximumsNode = this.addNode(attributesNode, "Maximums", null, null, null);
        if (timeline.getMaxThreadsPerBlock() > 0) {
            this.addNode(maximumsNode, String.valueOf(ViperComputeDictionary.THREAD.getLabel(computeKind)) + "s per " + ViperComputeDictionary.BLOCK.getLabel(computeKind), timeline.getMaxThreadsPerBlock(), null, null);
        }
        if (timeline.getMaxSharedMemoryPerBlock() > 0) {
            this.addNode(maximumsNode, String.valueOf(ViperComputeDictionary.SHARED.getLabel(computeKind)) + " Memory per " + ViperComputeDictionary.BLOCK.getLabel(computeKind), new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(timeline.getMaxSharedMemoryPerBlock()), null, null);
        }
        if (timeline.getMaxRegistersPerBlock() > 0) {
            this.addNode(maximumsNode, "Registers per " + ViperComputeDictionary.BLOCK.getLabel(computeKind), timeline.getMaxRegistersPerBlock(), null, null);
        }
        if ((grid = timeline.getMaxGridDims()) != null && grid.length == 3 && grid[0] > 0 && grid[1] > 0 && grid[2] > 0) {
            this.addNode(maximumsNode, String.valueOf(ViperComputeDictionary.GRID.getLabel(computeKind)) + " Dimensions", "[ " + grid[0] + ", " + grid[1] + ", " + grid[2] + " ]", null, null);
        }
        if ((block = timeline.getMaxBlockDims()) != null && block.length == 3 && block[0] > 0 && block[1] > 0 && block[2] > 0) {
            this.addNode(maximumsNode, String.valueOf(ViperComputeDictionary.BLOCK.getLabel(computeKind)) + " Dimensions", "[ " + block[0] + ", " + block[1] + ", " + block[2] + " ]", null, null);
        }
        if (timeline.getMaxWarpsPerMultiprocessor() > 0) {
            this.addNode(maximumsNode, "Warps per " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind), timeline.getMaxWarpsPerMultiprocessor(), null, null);
        }
        if (timeline.getMaxBlocksPerMultiprocessor() > 0) {
            this.addNode(maximumsNode, "Blocks per " + ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind), timeline.getMaxBlocksPerMultiprocessor(), null, null);
        }
        long tepidClockRate = timeline.getComputeCapabilityMajor() == 2 ? timeline.getCoreClockRate() / 2L : timeline.getCoreClockRate();
        Number flopSp = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_FLOP_SP);
        if (flopSp != null && flopSp instanceof Long) {
            long flopsSp = flopSp.longValue() * tepidClockRate;
            this.addNode(maximumsNode, "Single Precision FLOP/s", new FlopsFormatter().format(flopsSp), null, "Single Precision floating point operations per second");
        }
        if ((flopDp = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_FLOP_DP)) != null && flopDp instanceof Long) {
            long flopsDp = flopDp.longValue() * tepidClockRate;
            this.addNode(maximumsNode, "Double Precision FLOP/s", new FlopsFormatter().format(flopsDp), null, "Double Precision floating point operations per second");
        }
        TreeItem smNode = this.addNode(attributesNode, ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind), null, null, null);
        if (timeline.getNumMultiprocessors() > 0) {
            this.addNode(smNode, String.valueOf(ViperComputeDictionary.MULTIPROCESSOR.getLabel(computeKind)) + "s", timeline.getNumMultiprocessors(), null, null);
        }
        if (timeline.getCoreClockRate() > 0L) {
            this.addNode(smNode, "Clock Rate", new FrequencyFormatter().format(timeline.getCoreClockRate()), null, null);
        }
        if (timeline.getComputeCapabilityMajor() > 0) {
            this.addNode(smNode, "Concurrent " + ViperComputeDictionary.KERNEL.getLabel(computeKind), timeline.supportsConcurrentKernels(), null, null);
        }
        if (timeline.getMaxIPC() > 0) {
            this.addNode(smNode, "Max IPC", timeline.getMaxIPC(), null, null);
        }
        if (timeline.getNumThreadsPerWarp() > 0) {
            this.addNode(smNode, String.valueOf(ViperComputeDictionary.THREAD.getLabel(computeKind)) + "s per Warp", timeline.getNumThreadsPerWarp(), null, null);
        }
        TreeItem memoryNode = this.addNode(attributesNode, "Memory", null, null, null);
        if (timeline.getGlobalMemoryBandwidth() > 0L) {
            this.addNode(memoryNode, "Global Memory Bandwidth", new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(timeline.getGlobalMemoryBandwidth()), null, null);
        }
        if (timeline.getGlobalMemorySize() > 0L) {
            this.addNode(memoryNode, "Global Memory Size", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(timeline.getGlobalMemorySize()), null, null);
        }
        if (timeline.getConstantMemorySize() > 0) {
            this.addNode(memoryNode, "Constant Memory Size", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(timeline.getConstantMemorySize()), null, null);
        }
        if (timeline.getL2CacheSize() > 0) {
            this.addNode(memoryNode, "L2 Cache Size", new ByteSizeFormatter(ByteSizeFormatter.Base.KIBIBYTE).format(timeline.getL2CacheSize()), null, null);
        }
        if (timeline.getNumMemcpyEngines() > 0) {
            this.addNode(memoryNode, "Memcpy Engines", timeline.getNumMemcpyEngines(), null, null);
        }
        TreeItem pciNode = this.addNode(attributesNode, "PCIe", null, null, null);
        Number pciGen = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_GEN);
        if (pciGen instanceof Long) {
            this.addNode(pciNode, "Generation", pciGen.longValue(), null, null);
        }
        if ((pciRate = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_LINK_RATE)) instanceof Long) {
            this.addNode(pciNode, "Link Rate", new BandwidthFormatter(ByteSizeFormatter.Base.KILOBIT).format(pciRate.longValue() * 1000L * 1000L), null, null);
        }
        if ((pciWidth = timeline.getAttributeValue(CuptiDeviceAttribute.CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH)) instanceof Long) {
            this.addNode(pciNode, "Link Width", pciWidth.longValue(), null, null);
        }
        TreeItem environmentNode = this.addNode(null, "Environment", null, null, null);
        TreeItem smClockNode = this.addNode(environmentNode, "SM Clock", null, null, null);
        if (timeline.getSmClockAvg() > 0.0) {
            this.addNode(smClockNode, "Avg", new FrequencyFormatter().format((long)timeline.getSmClockAvg() * 1000000L), null, null);
        }
        if (timeline.getSmClockMin() > 0) {
            this.addNode(smClockNode, "Min", new FrequencyFormatter().format((long)timeline.getSmClockMin() * 1000000L), null, null);
        }
        if (timeline.getSmClockMax() > 0) {
            this.addNode(smClockNode, "Max", new FrequencyFormatter().format((long)timeline.getSmClockMax() * 1000000L), null, null);
        }
        if (timeline.getNumClockSamples() > 0) {
            this.addNode(smClockNode, "Samples", timeline.getNumClockSamples(), null, null);
        }
        TreeItem memClockNode = this.addNode(environmentNode, "Memory Clock", null, null, null);
        if (timeline.getMemoryClockAvg() > 0.0) {
            this.addNode(memClockNode, "Avg", new FrequencyFormatter().format((long)timeline.getMemoryClockAvg() * 1000000L), null, null);
        }
        if (timeline.getMemoryClockMin() > 0) {
            this.addNode(memClockNode, "Min", new FrequencyFormatter().format((long)timeline.getMemoryClockMin() * 1000000L), null, null);
        }
        if (timeline.getMemoryClockMax() > 0) {
            this.addNode(memClockNode, "Max", new FrequencyFormatter().format((long)timeline.getMemoryClockMax() * 1000000L), null, null);
        }
        if (timeline.getNumClockSamples() > 0) {
            this.addNode(memClockNode, "Samples", timeline.getNumClockSamples(), null, null);
        }
        TreeItem temperatureNode = this.addNode(environmentNode, "Temperature", null, null, null);
        if (timeline.getTemperatureAvg() > 0) {
            this.addNode(temperatureNode, "Avg", String.valueOf(timeline.getTemperatureAvg()) + " C", null, null);
        }
        if (timeline.getTemperatureMin() > 0) {
            this.addNode(temperatureNode, "Min", String.valueOf(timeline.getTemperatureMin()) + " C", null, null);
        }
        if (timeline.getTemperatureMax() > 0) {
            this.addNode(temperatureNode, "Max", String.valueOf(timeline.getTemperatureMax()) + " C", null, null);
        }
        if (timeline.getNumTemperatureSamples() > 0) {
            this.addNode(temperatureNode, "Samples", timeline.getNumTemperatureSamples(), null, null);
        }
        TreeItem powerNode = this.addNode(environmentNode, "Power", null, null, null);
        if (timeline.getPowerAvg() > 0.0) {
            this.addNode(powerNode, "Avg", new PowerFormatter().format(timeline.getPowerAvg() / 1000.0), null, null);
        }
        if (timeline.getPowerMin() > 0) {
            this.addNode(powerNode, "Min", new PowerFormatter().format((double)timeline.getPowerMin() / 1000.0), null, null);
        }
        if (timeline.getPowerMax() > 0) {
            this.addNode(powerNode, "Max", new PowerFormatter().format((double)timeline.getPowerMax() / 1000.0), null, null);
        }
        if (timeline.getNumPowerSamples() > 0) {
            this.addNode(powerNode, "Samples", timeline.getNumPowerSamples(), null, null);
        }
        TreeItem fanNode = this.addNode(environmentNode, "Fan", null, null, null);
        if (timeline.getFanSpeedAvg() > 0.0) {
            this.addNode(fanNode, "Avg", percentIntegerFormatter.format(timeline.getFanSpeedAvg() / 100.0), null, null);
        }
        if (timeline.getFanSpeedMin() > 0) {
            this.addNode(fanNode, "Min", percentIntegerFormatter.format((double)timeline.getFanSpeedMin() / 100.0), null, null);
        }
        if (timeline.getFanSpeedMax() > 0) {
            this.addNode(fanNode, "Max", percentIntegerFormatter.format((double)timeline.getFanSpeedMax() / 100.0), null, null);
        }
        if (timeline.getNumFanSpeedSamples() > 0) {
            this.addNode(fanNode, "Samples", timeline.getNumFanSpeedSamples(), null, null);
        }
        if (attributesNode.getItemCount() > 0) {
            attributesNode.setExpanded(true);
        } else {
            attributesNode.dispose();
        }
        if (memoryNode.getItemCount() > 0) {
            memoryNode.setExpanded(true);
        } else {
            memoryNode.dispose();
        }
        if (smNode.getItemCount() > 0) {
            smNode.setExpanded(true);
        } else {
            smNode.dispose();
        }
        if (pciNode.getItemCount() > 0) {
            pciNode.setExpanded(true);
        } else {
            pciNode.dispose();
        }
        if (maximumsNode.getItemCount() > 0) {
            maximumsNode.setExpanded(true);
        } else {
            maximumsNode.dispose();
        }
        if (environmentNode.getItemCount() > 0) {
            environmentNode.setExpanded(true);
        } else {
            environmentNode.dispose();
        }
        if (smClockNode.getItemCount() > 0) {
            smClockNode.setExpanded(true);
        } else {
            smClockNode.dispose();
        }
        if (memClockNode.getItemCount() > 0) {
            memClockNode.setExpanded(true);
        } else {
            memClockNode.dispose();
        }
        if (temperatureNode.getItemCount() > 0) {
            temperatureNode.setExpanded(true);
        } else {
            temperatureNode.dispose();
        }
        if (powerNode.getItemCount() > 0) {
            powerNode.setExpanded(true);
        } else {
            powerNode.dispose();
        }
        if (fanNode.getItemCount() > 0) {
            fanNode.setExpanded(true);
        } else {
            fanNode.dispose();
        }
    }

    protected TreeItem addNode(TreeItem parent, String label, Object value, Image image, String tooltip) {
        TreeItem item = parent != null ? new TreeItem(parent, 0) : new TreeItem(this.tree, 0);
        item.setText(new String[]{label, value == null ? null : value.toString()});
        if (image != null) {
            Image[] imageArray = new Image[2];
            imageArray[1] = image;
            item.setImage(imageArray);
        }
        if (tooltip != null) {
            this.nodeTooltips.put(item, tooltip);
        }
        return item;
    }

    protected Image getAnalysisImage(AnalysisDescriptor.Severity severity) {
        switch (severity) {
            case INFO: 
            case OK: {
                return null;
            }
        }
        return ViperImages.getAnalysisImageForSeverity(severity);
    }

    protected TreeItem addDuration(TreeItem parent) {
        TreeItem duration = this.addNode(parent, "Duration", null, null, "the total duration of the session");
        this.addNode(duration, "Session", new PreciseTimeFormatter(this.activeSession.getDuration()), null, null);
        duration.setExpanded(true);
        return duration;
    }

    protected TreeItem addMarkerData(TreeItem parent, CuptiActivityMarkerData data) {
        TreeItem node = this.addNode(parent, "Extended", null, null, null);
        this.addNode(node, "Category", new Integer(data.category), null, null);
        String valueString = null;
        Number value = data.getPayload();
        if (value != null) {
            valueString = CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_PERCENT.equals((Object)data.getPayloadKind()) ? percentFormatter.format(value.doubleValue() / 100.0) : (CuptiMetricValueKind.CUPTI_METRIC_VALUE_KIND_THROUGHPUT.equals((Object)data.getPayloadKind()) ? new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(value.longValue()) : numberFormatter.format(value));
        }
        if (valueString != null) {
            this.addNode(node, "Payload", valueString, null, null);
        }
        node.setExpanded(true);
        return node;
    }

    public void setSession(Session session) {
        if (this.activeSession != session) {
            if (this.activeSession != null) {
                this.activeSession.removePropertyChangeListener(this);
            }
            this.activeSession = session;
            if (session != null) {
                this.activeSession.addPropertyChangeListener(this);
                this.setInput(this.activeSession.getPrimarySelected(), false);
            } else {
                this.setInput(null, false);
            }
        }
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        if ("session:sInterval".equals(propertyName)) {
            this.handleSelectedInterval(((Session)model).getPrimarySelected(), ((Session)model).getSecondarySelected());
            this.handleHighlightedInterval(this.activeSession.getPrimaryHighlighted());
        } else if ("session:hInterval".equals(propertyName)) {
            this.handleHighlightedInterval(this.activeSession.getPrimaryHighlighted());
        } else if ("session:analysis".equals(propertyName)) {
            this.setInput(this.input, true);
        }
    }

    public Session getSession() {
        return this.activeSession;
    }

    protected void handleHighlightedInterval(TimelineIntervalPair pair) {
        if (pair == null) {
            this.setInput(this.activeSession.getSecondarySelected() == null ? this.activeSession.getPrimarySelected() : null, false);
        } else if (this.activeSession.getPrimarySelected() == null) {
            this.setInput(pair, false);
        } else {
            Collection<ITimelineInterval> selected = this.activeSession.getAllSelectedIntervals();
            if (selected != null && selected.contains(pair.getInterval())) {
                this.setInput(pair, false);
            } else {
                this.setInput(this.activeSession.getSecondarySelected() == null ? this.activeSession.getPrimarySelected() : null, false);
            }
        }
    }

    protected void handleSelectedInterval(TimelineIntervalPair primary, Collection<TimelineIntervalPair> secondary) {
        if (secondary != null && !secondary.isEmpty()) {
            this.setInput(null, false);
        } else {
            this.setInput(primary, false);
        }
    }

    public boolean setFocus() {
        if (this.tree != null) {
            return this.tree.setFocus();
        }
        return super.setFocus();
    }
}

