/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalEnvironment;
import java.util.Set;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class TimelineFigure
extends RectangleFigure {
    private static final Rectangle NO_CLIP = new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final int SHORTENED_STRING_MINIMUM_CHARS = 4;
    private static final int INTERVAL_TEXT_HMARGIN = 3;
    private static final int INTERVAL_TEXT_VMARGIN = 0;
    private static final int INTERVAL_GRADIENT_WIDTH_THRESHOLD = 1;
    private static final int INTERVAL_GRADIENT_HEIGHT_THRESHOLD = 2;
    public static final int ENV_INTERVAL_SYMBOL_HEIGHT = 6;
    public static final int ENV_INTERVAL_SYMBOL_WIDTH = 6;
    private final Timeline model;
    private final boolean showExtended;
    private double xScale = 1.0;
    private Set<ITimelineInterval> highlightIntervals = null;
    private boolean isSelected = false;
    private int minIntervalTextWidth = -1;
    private int minIntervalTextHeight = -1;
    private static int systemFontHeight = Integer.MIN_VALUE;

    public TimelineFigure(Timeline model) {
        this.model = model;
        this.showExtended = model.getKind().usesExtendedEnd();
    }

    public void setXScale(double scale) {
        this.xScale = scale;
    }

    public boolean setHighlightIntervals(Set<ITimelineInterval> intervals) {
        if (this.highlightIntervals == null != (intervals == null)) {
            this.highlightIntervals = intervals;
            return true;
        }
        if (this.highlightIntervals == null || this.highlightIntervals.equals(intervals)) {
            return false;
        }
        this.highlightIntervals = intervals;
        return true;
    }

    public void setIsSelected(boolean selected) {
        this.isSelected = selected;
    }

    protected Rectangle getRegionBounds(long start, long length, int height, Rectangle clip) {
        int x = (int)Math.round((double)start * this.xScale);
        int y = height >= 0 ? clip.y + this.model.getIntervalRowHeight() - height : clip.y;
        int regionHeight = height >= 0 ? height : clip.height;
        int regionWidth = (int)Math.round((double)length * this.xScale);
        Rectangle rect = new Rectangle(x, y, Math.max(1, regionWidth), regionHeight);
        rect.intersect(clip);
        return rect;
    }

    protected Rectangle getPrimaryIntervalBounds(ITimelineInterval interval, Rectangle clip) {
        return this.getRegionBounds(interval.getStart(), interval.getDuration(), interval.getHeight(this.model.getIntervalRowHeight()), clip);
    }

    protected Rectangle getExtendedIntervalBounds(ITimelineInterval interval, Rectangle clip) {
        return this.getRegionBounds(interval.getEnd(), interval.getExtendedEnd() - interval.getEnd(), interval.getHeight(this.model.getIntervalRowHeight()), clip);
    }

    protected Rectangle getIntervalBounds(ITimelineInterval interval, Rectangle clip) {
        return this.getRegionBounds(interval.getStart(), this.showExtended ? interval.getExtendedDuration() : interval.getDuration(), interval.getHeight(this.model.getIntervalRowHeight()), clip);
    }

    protected void paintEnvSymbols(ITimelineInterval interval, Graphics g, Rectangle clip, Color fgColor, ViperColors.GradientColors bgColors, int alpha) {
        if (this.model instanceof TimelineDevice) {
            int oldAlpha = g.getAlpha();
            if (alpha != -1) {
                g.setAlpha(alpha);
            }
            g.setForegroundColor(bgColors.primary);
            g.setBackgroundColor(bgColors.secondary);
            int x = (int)Math.round((double)interval.getStart() * this.xScale);
            x -= 3;
            int rowHeight = TimelineFigure.getScaledValue(this.model.getIntervalRowHeight());
            int yOffset = TimelineFigure.getScaledValue(((TimelineDevice)this.model).getYOffsetForEnvSymbol(interval));
            int scaledSymbolHeight = TimelineFigure.getScaledValue(6);
            int symbolRadius = scaledSymbolHeight / 2;
            yOffset = yOffset < symbolRadius ? scaledSymbolHeight : (yOffset > rowHeight - symbolRadius ? rowHeight : (yOffset += symbolRadius));
            int y = clip.y + rowHeight - yOffset;
            Rectangle rect = new Rectangle(x, y, Math.max(1, TimelineFigure.getScaledValue(6)), scaledSymbolHeight);
            rect.intersect(clip);
            g.fillOval(rect);
            g.setAlpha(oldAlpha);
        }
    }

    protected void paintInterval(ITimelineInterval interval, Graphics g, Rectangle clip, Color fgColor, ViperColors.GradientColors bgColors, int alpha) {
        Rectangle clipRect = this.getIntervalBounds(interval, clip);
        boolean useGradient = bgColors.secondary != null && clipRect.width > 1 && clipRect.height > 2;
        int oldAlpha = g.getAlpha();
        if (alpha != -1) {
            g.setAlpha(alpha);
        }
        g.setForegroundColor(bgColors.primary);
        g.setBackgroundColor(bgColors.secondary);
        if (useGradient) {
            g.fillGradient(clipRect, true);
        } else {
            g.fillRectangle(clipRect);
        }
        if (this.showExtended && interval.getExtendedEnd() > interval.getEnd()) {
            Rectangle primaryClipRect = this.getPrimaryIntervalBounds(interval, clip);
            Rectangle.SINGLETON.x = primaryClipRect.x + primaryClipRect.width;
            Rectangle.SINGLETON.y = clipRect.y + 1;
            Rectangle.SINGLETON.height = clipRect.height - 2;
            Rectangle.SINGLETON.width = clipRect.width - primaryClipRect.width - 1;
            if (Rectangle.SINGLETON.width > 0 && Rectangle.SINGLETON.height > 0) {
                g.setBackgroundColor(this.model.getBackgroundColor());
                g.fillRectangle(Rectangle.SINGLETON);
            }
        }
        if (clipRect.height > this.minIntervalTextHeight && clipRect.width > this.minIntervalTextWidth && alpha == -1) {
            Rectangle fullRect = this.getPrimaryIntervalBounds(interval, NO_CLIP);
            if (fullRect.width > this.minIntervalTextWidth) {
                fullRect.y = clipRect.y;
                fullRect.height = clipRect.height;
                Dimension textBounds = new Dimension(fullRect.width - 6, clipRect.height - 0);
                Font font = this.getLocalFont();
                String boundedText = StringUtils.getBoundedText(interval.getDisplayName(), textBounds, font, 4);
                if (boundedText != null) {
                    Dimension extents = FigureUtilities.getStringExtents((String)boundedText, (Font)font);
                    Point textLoc = fullRect.getCenter().translate(-extents.width / 2, -extents.height / 2);
                    g.setForegroundColor(fgColor);
                    g.drawText(boundedText, textLoc);
                }
            }
        }
        g.setAlpha(oldAlpha);
    }

    protected void paintIntervalBorder(ITimelineInterval interval, Graphics g, Rectangle clip, Color color, int alpha) {
        float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
        int inset1 = (int)Math.floor(lineInset);
        int inset2 = (int)Math.ceil(lineInset);
        Rectangle newClip = new Rectangle(clip).expand(this.getLineWidth() * 2, 0);
        Rectangle r = this.getPrimaryIntervalBounds(interval, newClip);
        r.x += inset1;
        r.y += inset1;
        r.width -= inset1 + inset2;
        r.height -= inset1 + inset2;
        int oldAlpha = g.getAlpha();
        g.setAlpha(alpha);
        g.setForegroundColor(color);
        g.drawRectangle(r);
        g.setAlpha(oldAlpha);
    }

    public void paintFigure(Graphics g) {
        if (this.minIntervalTextWidth == -1 || this.minIntervalTextHeight == -1 || !this.getFont().equals((Object)this.getLocalFont())) {
            this.setFont(this.getFont());
            this.minIntervalTextWidth = FigureUtilities.getFontMetrics((Font)this.getLocalFont()).getAverageCharWidth() * 4;
            this.minIntervalTextHeight = this.model instanceof TimelineDevice ? Integer.MAX_VALUE : FigureUtilities.getFontMetrics((Font)this.getLocalFont()).getHeight() - 2;
        }
        Rectangle drawArea = this.getClientArea();
        Rectangle intervalClip = g.getClip(new Rectangle());
        int numRows = this.model.getNumIntervalRows();
        int rowHeight = TimelineFigure.getScaledValue(this.model.getIntervalRowHeight());
        int rowInnerMargin = TimelineFigure.getScaledValue(this.model.getIntervalRowInnerMargin());
        int timelineMargin = TimelineFigure.getScaledValue(this.model.getTimelineOuterMargin());
        Rectangle[] rowBounds = new Rectangle[numRows];
        int[] maxOpaque = new int[numRows];
        int[] maxNonOpaque = new int[numRows];
        int i = 0;
        while (i < numRows) {
            rowBounds[i] = new Rectangle(drawArea.x, drawArea.y + timelineMargin + (rowHeight + rowInnerMargin) * i, drawArea.width, rowHeight);
            maxOpaque[i] = -1;
            maxNonOpaque[i] = -1;
            ++i;
        }
        if (this.isSelected) {
            g.setBackgroundColor(ViperColors.TIMELINE_SELECTED_COLOR);
            g.fillRectangle(drawArea);
            int originalWidth = g.getLineWidth();
            if (timelineMargin > originalWidth) {
                g.setLineWidth(timelineMargin);
            }
            g.setBackgroundColor(this.getBackgroundColor());
            g.fillRectangle(drawArea.getExpanded(0, -timelineMargin));
            if (timelineMargin > originalWidth) {
                g.setLineWidth(originalWidth);
            }
        } else {
            g.setBackgroundColor(this.getBackgroundColor());
            g.fillRectangle(drawArea);
        }
        double startNS = (double)intervalClip.x / this.xScale;
        double endNS = startNS + (double)intervalClip.width / this.xScale;
        Timeline.IntervalRange intervals = this.model.getVisibleIntervals((long)startNS, (long)(endNS + 0.5));
        int iidx = intervals.getStartIndex();
        while (iidx < intervals.getEndIndex()) {
            ViperColors.GradientColors colors;
            int alpha;
            ITimelineInterval interval = intervals.getInterval(iidx);
            int row = this.model.getVisibleIntervalRow(interval);
            Rectangle iBounds = this.getIntervalBounds(interval, NO_CLIP);
            int start = iBounds.x;
            int end = start + iBounds.width - 1;
            if (interval instanceof TimelineIntervalEnvironment) {
                alpha = this.model.getIntervalAlpha(interval);
                colors = this.model.getIntervalColors(interval);
                this.paintEnvSymbols(interval, g, rowBounds[row], ViperColors.INTERVAL_TEXT_FGCOLOR, colors, alpha);
            } else if (end > maxOpaque[row] && ((alpha = this.model.getIntervalAlpha(interval)) == -1 || alpha != -1 && end > maxNonOpaque[row])) {
                colors = this.model.getIntervalColors(interval);
                this.paintInterval(interval, g, rowBounds[row], ViperColors.INTERVAL_TEXT_FGCOLOR, colors, alpha);
                maxNonOpaque[row] = end;
                if (alpha == -1) {
                    maxOpaque[row] = end;
                }
            }
            if (this.highlightIntervals != null && this.highlightIntervals.contains(interval)) {
                alpha = this.model.getIntervalAlpha(interval);
                if (interval instanceof TimelineIntervalEnvironment) {
                    this.paintEnvSymbols(interval, g, rowBounds[row], ViperColors.INTERVAL_HILITE_TEXT_FGCOLOR, ViperColors.INTERVAL_HILITE_COLORS, alpha);
                } else {
                    this.paintInterval(interval, g, rowBounds[row], ViperColors.INTERVAL_HILITE_TEXT_FGCOLOR, ViperColors.INTERVAL_HILITE_COLORS, alpha);
                }
            }
            ++iidx;
        }
    }

    public static int getScaledTimelineHeight(Timeline timeline) {
        int numRows = timeline.getNumIntervalRows();
        int rowHeight = TimelineFigure.getScaledValue(timeline.getIntervalRowHeight());
        int innerMargin = TimelineFigure.getScaledValue(timeline.getIntervalRowInnerMargin());
        int outerMargin = TimelineFigure.getScaledValue(timeline.getTimelineOuterMargin());
        int height = numRows * (rowHeight + innerMargin) - innerMargin;
        return height + 2 * outerMargin;
    }

    public static int getScaledValue(int height) {
        if (systemFontHeight == Integer.MIN_VALUE) {
            int h;
            Display current = Display.getCurrent();
            if (current == null) {
                throw new IllegalStateException("Should be called from the SWT thread");
            }
            Font font = current.getSystemFont();
            systemFontHeight = h = FigureUtilities.getFontMetrics((Font)font).getHeight();
        }
        return Math.max(height * systemFontHeight / 16, height);
    }
}

