/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.Activator;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.ViperRunMode;
import com.nvidia.viper.actions.ColorByKernelAction;
import com.nvidia.viper.actions.ColorByProcessAction;
import com.nvidia.viper.actions.ColorByStreamAction;
import com.nvidia.viper.actions.FocusTimelineAction;
import com.nvidia.viper.actions.RunAnalysisAction;
import com.nvidia.viper.actions.RunProfileAction;
import com.nvidia.viper.actions.RunTimelineAction;
import com.nvidia.viper.actions.ScaleFitAction;
import com.nvidia.viper.actions.ScaleInAction;
import com.nvidia.viper.actions.ScaleOutAction;
import com.nvidia.viper.actions.SessionContextMenuProvider;
import com.nvidia.viper.actions.UnfocusTimelineAction;
import com.nvidia.viper.actions.WritePdmAction;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineRuler;
import com.nvidia.viper.model.VerticalRuler;
import com.nvidia.viper.parts.SessionEditPartFactory;
import com.nvidia.viper.parts.TimelineEditPart;
import com.nvidia.viper.rulers.TimelineRulerProvider;
import com.nvidia.viper.rulers.VerticalRulerProvider;
import com.nvidia.viper.ui.SessionRulerComposite;
import com.nvidia.viper.ui.ViperMessageDialogWithToggle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.SelectionManager;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class SessionEditor
extends GraphicalEditor
implements ITabbedPropertySheetPageContributor {
    public static final String ID = "com.nvidia.viper.sessioneditor";
    protected static final int VERTICAL_REVEAL_MARGIN = 10;
    protected static final int HORIZONTAL_REVEAL_MARGIN = 10;
    protected static final double SCROLL_WHEEL_ZOOM_FACTOR = 0.05;
    private boolean dirty;
    SessionRulerComposite rulerComp;
    private Session session;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            IPerspectiveDescriptor perspective;
            IWorkbenchPage activePage;
            IWorkbenchWindow workbenchWindow;
            IWorkbench workbench;
            if (part instanceof SessionEditor && part == SessionEditor.this && (workbench = PlatformUI.getWorkbench()) != null && !workbench.isStarting() && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = workbenchWindow.getActivePage()) != null && (perspective = activePage.getWorkbenchWindow().getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("com.nvidia.viper.perspective")) != null && !perspective.equals(activePage.getPerspective()) && SessionEditor.shouldSwitchPerspective(activePage.getWorkbenchWindow().getShell(), perspective)) {
                activePage.setPerspective(perspective);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            Session closeSession;
            if (part instanceof SessionEditor && part == SessionEditor.this && (closeSession = ((SessionEditor)part).getSession()) != null) {
                closeSession.removePropertyChangeListener(SessionEditor.this.sessionListener);
                Activator.getDefault().getViperWorkbench().closeEditorInput(SessionEditor.this.getEditorInput());
            }
        }
    };
    private ISessionPropertyChangeListener sessionListener = new ISessionPropertyChangeListener(){

        @Override
        public void propertyChange(IModel model, String propertyName) {
            if ("session:name".equals(propertyName)) {
                SessionEditor.this.setNameFromSession();
                SessionEditor.this.firePropertyChange(1);
            } else if ("session:hReveal".equals(propertyName)) {
                SessionEditor.this.revealX(SessionEditor.this.getSession().getHorizontalReveal());
            } else if ("session:vReveal".equals(propertyName)) {
                SessionEditor.this.revealY(SessionEditor.this.getSession().getVerticalReveal());
            } else if ("session:vruler".equals(propertyName)) {
                SessionEditor.this.rulerComp.layout(true);
            } else if ("session:timelines".equals(propertyName)) {
                SessionEditor.this.scaleToFit();
            }
            SessionEditor.this.setDirty(SessionEditor.this.getSession().isDirty() && !SessionEditor.this.getSession().isReadOnly());
        }
    };

    private static boolean shouldSwitchPerspective(Shell shell, IPerspectiveDescriptor descriptor) {
        String string = DebugUIPlugin.getDefault().getPreferenceStore().getString("org.eclipse.debug.ui.switch_perspective_on_suspend");
        if ("always".equals(string)) {
            return true;
        }
        if ("never".equals(string)) {
            return false;
        }
        return ViperMessageDialogWithToggle.openQuestionWithToggle(shell, LaunchConfigurationsMessages.PerspectiveManager_12, "Profile perspective displays auxiliary views that provide a deeper insight in profiling data. Do you want to open this perspective now?", null, false, DebugUIPlugin.getDefault().getPreferenceStore(), "org.eclipse.debug.ui.switch_perspective_on_suspend") == 2;
    }

    public Session getSession() {
        return this.session;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.session = Activator.getDefault().getViperWorkbench().getSession(input);
        this.dirty = false;
        this.setEditDomain(new DefaultEditDomain(null));
        super.init(site, input);
        this.setNameFromSession();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
        this.getSession().addPropertyChangeListener(this.sessionListener);
        site.getPage().getViews();
    }

    public void dispose() {
        super.dispose();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        if (viewer != null) {
            viewer.setProperty("horizontal ruler", null);
            viewer.setProperty("vertical ruler", null);
        }
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        if (this.getSession() != null) {
            this.getSession().removePropertyChangeListener(this.sessionListener);
        }
        this.rulerComp.dispose();
        this.rulerComp = null;
        this.session = null;
    }

    protected void setNameFromSession() {
        String name = null;
        Session session = this.getSession();
        if (session != null) {
            name = session.getName();
        }
        this.setPartName(name == null ? "" : name);
    }

    protected void createGraphicalViewer(Composite parent) {
        this.rulerComp = new SessionRulerComposite(this.getSession(), parent, 0);
        super.createGraphicalViewer((Composite)this.rulerComp);
        this.rulerComp.setGraphicalViewer((ScrollingGraphicalViewer)this.getGraphicalViewer());
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new SessionEditPartFactory());
        viewer.setSelectionManager(new SelectionManager(){

            public ISelection getSelection() {
                Object sel = super.getSelection();
                if (sel instanceof StructuredSelection) {
                    sel = new StructuredSelection(((StructuredSelection)sel).toList()){

                        public boolean equals(Object o) {
                            boolean r = super.equals(o);
                            if (r) {
                                Object[] objectArray = super.toArray();
                                int n = objectArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object element = objectArray[n2];
                                    if (element instanceof TimelineEditPart) {
                                        return false;
                                    }
                                    ++n2;
                                }
                            }
                            return r;
                        }
                    };
                }
                return sel;
            }
        });
        SessionContextMenuProvider cmProvider = new SessionContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)cmProvider);
        this.getSite().registerContextMenu((MenuManager)cmProvider, (ISelectionProvider)viewer);
        TimelineRuler timelineRuler = this.getSession().getHorizontalRuler();
        RulerProvider provider = timelineRuler == null ? null : new TimelineRulerProvider(timelineRuler);
        viewer.setProperty("horizontal ruler", (Object)provider);
        VerticalRuler verticalRuler = this.getSession().getVerticalRuler();
        provider = verticalRuler == null ? null : new VerticalRulerProvider(verticalRuler);
        viewer.setProperty("vertical ruler", (Object)provider);
        viewer.setProperty("ruler$visibility", (Object)Boolean.TRUE);
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)new MouseWheelHandler(){

            public void handleMouseWheel(Event event, EditPartViewer viewer) {
                if (event.type == 37 && event.doit) {
                    SessionEditor.this.scale(event.count >= 0 ? 0.95 : 1.05);
                    event.doit = false;
                }
            }
        });
        viewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD2), (Object)new MouseWheelHandler(){

            public void handleMouseWheel(Event event, EditPartViewer viewer) {
                if (event.type == 37 && event.doit) {
                    FigureCanvas canvas = (FigureCanvas)SessionEditor.this.getGraphicalViewer().getControl();
                    int x = canvas.getViewport().getViewLocation().x;
                    canvas.scrollToX(event.count < 0 ? x + 100 : x - 100);
                    event.doit = false;
                }
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        ViperHelp.setContextHelp(viewer.getControl(), ViperHelp.SESSION_EDITOR_CONTEXT_ID);
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        Action action = new FocusTimelineAction(this);
        registry.registerAction((IAction)action);
        action = new UnfocusTimelineAction(this);
        registry.registerAction((IAction)action);
        action = new ScaleInAction(this);
        registry.registerAction((IAction)action);
        action = new ScaleOutAction(this);
        registry.registerAction((IAction)action);
        action = new ScaleFitAction(this);
        registry.registerAction((IAction)action);
        action = new RunAnalysisAction(this.getSession(), true, RunAnalysisAction.ShowMode.GUIDED);
        registry.registerAction((IAction)action);
        action = new RunTimelineAction(this.getSession());
        registry.registerAction((IAction)action);
        action = new RunProfileAction(this.getSession(), null, true, false);
        registry.registerAction((IAction)action);
        action = new RunProfileAction(this.getSession(), null, true, true);
        registry.registerAction((IAction)action);
        action = new ColorByKernelAction(this);
        registry.registerAction((IAction)action);
        action = new ColorByStreamAction(this);
        registry.registerAction((IAction)action);
        action = new ColorByProcessAction(this);
        registry.registerAction((IAction)action);
        if (System.getenv("VIPER_DEBUG") != null) {
            action = new WritePdmAction(this.getSession(), true);
            registry.registerAction((IAction)action);
            action = new WritePdmAction(this.getSession(), false);
            registry.registerAction((IAction)action);
        }
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.getSession());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public boolean isSaveOnCloseNeeded() {
        if (ViperRunMode.getRunMode().equals((Object)ViperRunMode.RunMode.TEST)) {
            System.out.println("[MESSAGE] Save resources dialog is suppressed for test when viper is closed");
            return false;
        }
        return super.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            Activator.getDefault().getViperWorkbench().save(this.getSite().getShell(), this.getSession(), this.getEditorInput());
            this.setDirty(this.session.isDirty());
        }
        catch (ViperException e) {
            ViperExceptionHandler.handle(ViperMessages.Save_Fail_Title, ViperMessages.Save_Fail_Message, e);
        }
    }

    public void doSaveAs() {
        try {
            IEditorInput newInput = Activator.getDefault().getViperWorkbench().saveAs(this.getSite().getShell(), this.getSession(), this.getEditorInput());
            if (newInput != null) {
                this.setInputWithNotify(newInput);
                this.setTitleToolTip(newInput.getToolTipText());
                this.setDirty(this.session.isDirty());
            }
        }
        catch (ViperException e) {
            ViperExceptionHandler.handle(ViperMessages.Save_Fail_Title, ViperMessages.Save_Fail_Message, e);
        }
    }

    public void scaleToFit() {
        int width = ((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart()).getFigure().getBounds().width;
        long length = this.getSession().getVisibleDuration();
        this.getSession().setHorizontalScale((double)(width -= 4) / (double)length);
        this.getGraphicalViewer().setRouteEventsToEditDomain(false);
    }

    public void scale(double factor) {
        final FigureCanvas canvas = (FigureCanvas)this.getGraphicalViewer().getControl();
        Viewport viewport = canvas.getViewport();
        final int oldX = viewport.getBounds().getCenter().x;
        int hCenterOld = viewport.getViewLocation().x + oldX;
        try {
            this.rulerComp.setRedraw(false);
            double oldScale = this.getSession().getHorizontalScale();
            this.getSession().setHorizontalScale(oldScale * factor);
            double newScale = this.getSession().getHorizontalScale();
            double centerFactor = newScale / oldScale;
            final int hCenterNew = (int)((double)hCenterOld * centerFactor);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        canvas.scrollToX(hCenterNew - oldX);
                    }
                    finally {
                        SessionEditor.this.rulerComp.setRedraw(true);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            this.rulerComp.setRedraw(true);
            throw e;
        }
        this.getGraphicalViewer().setRouteEventsToEditDomain(false);
    }

    public void revealY(int pos) {
        FigureCanvas canvas = (FigureCanvas)this.getGraphicalViewer().getControl();
        Viewport viewport = canvas.getViewport();
        Rectangle bounds = viewport.getBounds();
        int y = bounds.y + viewport.getViewLocation().y;
        int height = bounds.height;
        if (y > pos) {
            canvas.scrollToY(pos - 10);
        } else if (y + height < pos) {
            canvas.scrollToY(pos - height + 10);
        }
    }

    public void revealX(int pos) {
        FigureCanvas canvas = (FigureCanvas)this.getGraphicalViewer().getControl();
        Viewport viewport = canvas.getViewport();
        Rectangle bounds = viewport.getBounds();
        int x = bounds.x + viewport.getViewLocation().x;
        int width = bounds.width;
        if (x > pos) {
            canvas.scrollToX(pos - 10);
        } else if (x + width < pos) {
            canvas.scrollToX(pos - width + 10);
        }
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return Activator.getDefault().getViperWorkbench().createPropertySheetPage(this);
        }
        return super.getAdapter(type);
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public void createPartControl(Composite parent) {
        Composite root = Activator.getDefault().getViperWorkbench().configureEditorSite(parent, (IEditorPart)this);
        super.createPartControl(root);
    }
}

