/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.CsvReader;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.ImportCsvWizardPage;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.SessionEditorInput;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ImportCsvWizard
extends Wizard
implements IImportWizard {
    private ImportCsvWizardPage importCSVWizardPage;

    public ImportCsvWizard() {
        this.setWindowTitle(ViperMessages.ImportCSV_Wizard_Title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        String[] filenames = this.importCSVWizardPage.getFilePaths();
        String basename = null;
        if (filenames != null && filenames.length > 0) {
            File file = new File(filenames[0]);
            basename = file.getName();
        }
        ImportCsvWizard.importFromFiles(basename, filenames);
        Viper.closeWelcomePage(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        return true;
    }

    public static Session importFromFiles(String sessionName, String[] filenames) {
        IProgressService ps = PlatformUI.getWorkbench().getProgressService();
        try {
            Session session = new Session();
            ps.busyCursorWhile((IRunnableWithProgress)new ImportCSVRunnableWithProgress(session, sessionName, filenames));
            return session;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException ite) {
            ViperExceptionHandler.logError(null, ite);
        }
        return null;
    }

    public static boolean isCSV(File file) {
        try {
            CsvReader cpr = new CsvReader(new FileInputStream(file), file.getName());
            cpr.step();
            int deviceNum = cpr.getCurrentDeviceNum();
            return deviceNum != -1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void addPages() {
        this.importCSVWizardPage = new ImportCsvWizardPage("Import CSV");
        this.addPage((IWizardPage)this.importCSVWizardPage);
        super.addPages();
    }

    public static class ImportCSVRunnableWithProgress
    implements IRunnableWithProgress {
        final Session session;
        final String sessionName;
        final String[] filenames;

        public ImportCSVRunnableWithProgress(Session session, String sessionName, String[] filenames) {
            this.session = session;
            this.sessionName = sessionName;
            this.filenames = filenames;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                monitor.beginTask("Importing CSV profile...", -1);
                final ProfileDataModel pdm = new ProfileDataModel();
                try {
                    pdm.readCsv(this.filenames);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    long normalizeTime = 0L;
                    try {
                        normalizeTime = NativeCupti.cuptiPDMGetNormalizeTime(pdm.getNativeHandle());
                    }
                    catch (CuptiException e1) {
                        ViperExceptionHandler.handle(ViperMessages.ImportCsv_Fail_Title, ViperMessages.ImportCmdline_Fail_Message, e1);
                    }
                    pdm.normalizeTimestamps(normalizeTime);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SessionEditor editor;
                                IWorkbenchPage activePage;
                                IWorkbenchWindow workbenchWindow;
                                ImportCSVRunnableWithProgress.this.session.setTimelines(pdm);
                                ImportCSVRunnableWithProgress.this.session.setExpert(new Expert());
                                ImportCSVRunnableWithProgress.this.session.setAnalysis(new Analysis());
                                ImportCSVRunnableWithProgress.this.session.setName(ImportCSVRunnableWithProgress.this.sessionName);
                                IWorkbench workbench = PlatformUI.getWorkbench();
                                if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = workbenchWindow.getActivePage()) != null && (editor = (SessionEditor)activePage.openEditor((IEditorInput)new SessionEditorInput(ImportCSVRunnableWithProgress.this.session), "com.nvidia.viper.sessioneditor")) != null) {
                                    editor.scaleToFit();
                                    editor.setDirty(true);
                                    ImportCSVRunnableWithProgress.this.session.setDirty(true);
                                }
                            }
                            catch (Exception e2) {
                                ViperException e2;
                                if (!(e2 instanceof ViperException)) {
                                    e2 = new ViperException(e2);
                                }
                                ViperExceptionHandler.logError(e2.getMessage());
                                ViperExceptionHandler.handle(ViperMessages.ImportCsv_Fail_Title, ViperMessages.ImportCsv_Fail_Message, null);
                            }
                        }
                    });
                }
                finally {
                    pdm.dispose();
                }
            }
            catch (ViperException e) {
                ViperExceptionHandler.logError(e.getMessage());
                ViperExceptionHandler.handle(ViperMessages.ImportCsv_Fail_Title, ViperMessages.ImportCsv_Fail_Message, null);
            }
        }
    }
}

