/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityMemset;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.value.ValueBandwidth;

public class TimelineIntervalMemset
extends TimelineIntervalHierarchy
implements IModel,
ITimelineInterval {
    protected CuptiActivityMemset activity;
    private Timeline primaryTimeline;

    public TimelineIntervalMemset(CuptiActivityMemset activity) {
        this.activity = activity;
        this.primaryTimeline = null;
    }

    @Override
    public TimelineIntervalKind getKind() {
        return TimelineIntervalKind.MEMSET;
    }

    @Override
    public String getName() {
        return "memset (" + this.activity.value + ")";
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public int getCorrelationId() {
        return this.activity.correlationId;
    }

    public int getRuntimeCorrelationId() {
        return this.activity.runtimeCorrelationId;
    }

    @Override
    public ViperColors.GradientColors getColor(ViperColors.GradientColors colors) {
        return colors;
    }

    @Override
    public long getStart() {
        return this.activity.start;
    }

    @Override
    public long getEnd() {
        return this.activity.end;
    }

    @Override
    public long getDuration() {
        return this.activity.end - this.activity.start;
    }

    @Override
    public long getExtendedEnd() {
        return this.activity.end;
    }

    @Override
    public long getExtendedDuration() {
        return this.getDuration();
    }

    public long getBytes() {
        return this.activity.bytes;
    }

    public long getThroughput() {
        return new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, this.activity.bytes, this.getDuration()).getBandwidth();
    }

    public int getValue() {
        return this.activity.value;
    }

    @Override
    public Timeline getPrimaryTimeline() {
        return this.primaryTimeline;
    }

    @Override
    public void setPrimaryTimeline(Timeline timeline) {
        this.primaryTimeline = timeline;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.activity.appendToPDM(pdm.getNativeHandle());
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }
}

