/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityMarker;
import com.nvidia.viper.activity.CuptiActivityMarkerData;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.TimelineIntervalBase;
import com.nvidia.viper.model.TimelineIntervalKind;

public class TimelineIntervalMarker
extends TimelineIntervalBase {
    private CuptiActivityMarker marker;
    private CuptiActivityMarkerData data;

    public TimelineIntervalMarker(CuptiActivityMarker marker, CuptiActivityMarkerData data) {
        this.marker = marker;
        this.data = data;
    }

    @Override
    public TimelineIntervalKind getKind() {
        return TimelineIntervalKind.MARKER;
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.marker.name;
    }

    @Override
    public int getCorrelationId() {
        return 0;
    }

    @Override
    public ViperColors.GradientColors getColor(ViperColors.GradientColors colors) {
        if (this.data != null && CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_COLOR_ARGB.isSet(this.data.flags)) {
            return ViperColors.getMarkerGradientColors(this.data.color, false);
        }
        return null;
    }

    @Override
    public long getStart() {
        return this.marker.timestamp;
    }

    @Override
    public long getEnd() {
        return this.marker.timestamp;
    }

    public CuptiActivityMarkerData getMarkerData() {
        return this.data;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.marker.appendToPDM(pdm.getNativeHandle());
            if (this.data != null) {
                this.data.appendToPDM(pdm.getNativeHandle());
            }
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }
}

