/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.CallbackIdUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityAPI;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKind;

public class TimelineIntervalAPI
extends TimelineIntervalHierarchy
implements IModel,
ITimelineInterval {
    protected TimelineIntervalKind kind;
    protected CuptiActivityAPI activity;
    private Timeline primaryTimeline;

    public TimelineIntervalAPI(TimelineIntervalKind kind, CuptiActivityAPI activity) {
        this.kind = kind;
        this.activity = activity;
        this.primaryTimeline = null;
    }

    @Override
    public TimelineIntervalKind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        if (this.kind == TimelineIntervalKind.RUNTIME) {
            return CallbackIdUtils.getRuntimeName(this.getCallbackId(), false);
        }
        return CallbackIdUtils.getDriverName(this.getCallbackId(), false);
    }

    @Override
    public int getCorrelationId() {
        return this.activity.correlationId;
    }

    public int getCallbackId() {
        return this.activity.cbid;
    }

    @Override
    public long getStart() {
        return this.activity.start;
    }

    @Override
    public long getEnd() {
        return this.activity.end;
    }

    @Override
    public long getDuration() {
        return this.activity.end - this.activity.start;
    }

    @Override
    public long getExtendedEnd() {
        return this.activity.end;
    }

    @Override
    public long getExtendedDuration() {
        return this.getDuration();
    }

    @Override
    public Timeline getPrimaryTimeline() {
        return this.primaryTimeline;
    }

    @Override
    public void setPrimaryTimeline(Timeline timeline) {
        this.primaryTimeline = timeline;
    }

    public void setCorrelationId(int correlationId) {
        this.activity.correlationId = correlationId;
    }

    public int getProcessId() {
        return this.activity.processId;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.activity.appendToPDM(pdm.getNativeHandle());
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }
}

