/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.common.util.XmlUtil;
import com.nvidia.cuda.ide.util.IMarkerScope;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.TimelineFactory;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.jni.CUptiResult;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.ContainerState;
import com.nvidia.viper.model.CudaFunctionManager;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.ExpertData;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.ISessionSerializable;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.SessionFilter;
import com.nvidia.viper.model.SourceLevelResult;
import com.nvidia.viper.model.SourceLocator;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineColorMode;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalAPI;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalMemcpy;
import com.nvidia.viper.model.TimelineIntervalMemset;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.TimelineProcess;
import com.nvidia.viper.model.TimelineRuler;
import com.nvidia.viper.model.TimelineStream;
import com.nvidia.viper.model.TimelineUVM;
import com.nvidia.viper.model.VerticalRuler;
import com.nvidia.viper.ui.LargeDataMessageDialog;
import com.nvidia.viper.ui.TimelineFigure;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.Disposable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Session
extends ModelWithProperties
implements IModel,
IMarkerScope,
ISessionSerializable,
Disposable {
    public static final int VERSION = 1;
    public static final String PROPERTY_SESSION = "session:session";
    public static final String PROPERTY_NAME = "session:name";
    public static final String PROPERTY_FILE = "session:file";
    public static final String PROPERTY_EXECUTABLE = "session:executable";
    public static final String PROPERTY_EXPERT = "session:expert";
    public static final String PROPERTY_ANALYSIS = "session:analysis";
    public static final String PROPERTY_EXPERT_SYSTEM = "session:expertsystem";
    public static final String PROPERTY_EXPERTDATA = "session:expertdata";
    public static final String PROPERTY_TIMELINES = "session:timelines";
    public static final String PROPERTY_TIMELINE = "session:timeline";
    public static final String PROPERTY_TIMELINE_RESET = "session:timelinereset";
    public static final String PROPERTY_VRULER = "session:vruler";
    public static final String PROPERTY_HRULER = "session:hruler";
    public static final String PROPERTY_HORIZONTAL_SCALE = "session:hScale";
    public static final String PROPERTY_HORIZONTAL_REVEAL = "session:hReveal";
    public static final String PROPERTY_VERTICAL_REVEAL = "session:vReveal";
    public static final String PROPERTY_HIGHLIGHT_INTERVAL = "session:hInterval";
    public static final String PROPERTY_SELECTED_INTERVAL = "session:sInterval";
    public static final String PROPERTY_COLORMODE = "session:colorMode";
    private static final double DEFAULT_HSCALE = 1.0E-6;
    public static final String FILE_EXTENSION = "nvvp";
    private int version = 1;
    private String name = null;
    private int pdmSize = -1;
    private long pdmStartTime = -1L;
    private long startCorrelationId;
    private long endCorrelationId;
    private Executable executable = null;
    private Expert expert = null;
    private Analysis analysis = null;
    private ExpertSystem expertSystem = null;
    private SourceLocator sourceLocator = new SourceLocator(this);
    private CudaFunctionManager cudaFunctionManager = new CudaFunctionManager();
    private ExpertData expertData;
    private List<Timeline> topLevelTimelines = new LinkedList<Timeline>();
    private List<Timeline> allTimelines = null;
    private List<Timeline> allVisibleTimelines = null;
    private TimelineState timelineState = null;
    private TimelineRuler horizontalRuler;
    private VerticalRuler verticalRuler;
    private double maxHorizontalScale = 1.0E-6;
    private double horizontalScale = 1.0E-6;
    private int horizontalReveal;
    private int verticalReveal;
    private TimelineIntervalPair primaryHighlighted;
    private Collection<TimelineIntervalPair> allHighlighted;
    private TimelineIntervalPair primarySelected;
    private Collection<TimelineIntervalPair> secondarySelected;
    private Collection<TimelineIntervalPair> allSelected;
    private Collection<ITimelineInterval> allSelectedIntervals;
    private boolean dirty = false;
    private boolean readOnly = false;
    private Object file = null;
    private Color currentTimelineBGColor = ViperColors.TIMELINE_BGCOLOR_0;
    private ViperColors.GradientColors[] timelineIntervalColors = null;
    private TimelineColorMode colorMode = TimelineColorMode.KERNEL;

    public Session() {
        this.setVerticalRuler(new VerticalRuler(this));
        this.setHorizontalRuler(new TimelineRuler(this));
    }

    public Session(Element el) throws ViperException {
        this();
        this.read(el);
        this.dirty = false;
    }

    public void dispose() {
        this.firePropertyChange(PROPERTY_TIMELINE_RESET);
        this.removeAllPropertyChangeListeners();
        try {
            this.setTimelines(null);
        }
        catch (ViperException e) {
            ViperExceptionHandler.logError("unable to dispose timelines", e);
        }
        if (this.executable != null) {
            this.executable.dispose();
        }
        if (this.expert != null) {
            this.expert.dispose();
        }
        if (this.expertData != null) {
            this.expertData.dispose();
        }
        if (this.analysis != null) {
            this.analysis.dispose();
        }
        if (this.expertSystem != null) {
            this.expertSystem.dispose();
        }
        if (this.sourceLocator != null) {
            this.sourceLocator.dispose();
        }
        if (this.cudaFunctionManager != null) {
            this.cudaFunctionManager.dispose();
        }
        this.executable = null;
        this.expert = null;
        this.expertData = null;
        this.analysis = null;
        this.expertSystem = null;
        this.sourceLocator = null;
        this.cudaFunctionManager = null;
        this.topLevelTimelines = null;
        this.allTimelines = null;
        this.allVisibleTimelines = null;
        this.timelineState = null;
        this.horizontalRuler = null;
        this.verticalRuler = null;
        this.allHighlighted = null;
        this.primarySelected = null;
        this.secondarySelected = null;
        this.allSelected = null;
        this.allSelectedIntervals = null;
        this.file = null;
    }

    public boolean needProfilingDataDelete() {
        Executable exe = this.getExecutable();
        if (exe != null) {
            try {
                return exe.isTimestampChanged() && !this.getTimelines().isEmpty();
            }
            catch (ConnectionNotFoundException e) {
                ViperExceptionHandler.logError(e.getMessage());
            }
        }
        return false;
    }

    public boolean needToGenerateTimeline() {
        Executable exe = this.getExecutable();
        if (exe != null) {
            try {
                return exe.isTimestampChanged() && this.getTimelines().isEmpty();
            }
            catch (ConnectionNotFoundException e) {
                ViperExceptionHandler.logError(e.getMessage());
            }
        }
        return false;
    }

    public int getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!StringUtils.equals(name, this.name)) {
            this.name = name;
            this.dirty = true;
            this.firePropertyChange(PROPERTY_NAME);
        }
    }

    public TimelineColorMode getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(TimelineColorMode colorMode) {
        if (!this.colorMode.equals((Object)colorMode)) {
            TimelineColorMode oldMode = this.colorMode;
            this.colorMode = colorMode;
            this.setTimelineIntervalColors(oldMode, this.colorMode);
            this.firePropertyChange(PROPERTY_COLORMODE);
        }
    }

    public Object getFile() {
        return this.file;
    }

    public void setFile(Object file) {
        if (file == null && this.file != null || file != null && !file.equals(this.file)) {
            this.file = file;
            this.firePropertyChange(PROPERTY_FILE);
        }
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        if (this.executable != executable) {
            Executable oldExec = this.executable;
            if (oldExec != null) {
                oldExec.removeAllPropertyChangeListeners();
            }
            this.executable = executable;
            if (this.executable != null) {
                this.executable.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                    @Override
                    public void propertyChange(IModel model, String propertyName) {
                        Session.this.dirty = true;
                        Session.this.firePropertyChange(Session.PROPERTY_EXECUTABLE);
                    }
                });
            }
            this.dirty = true;
            this.firePropertyChange(PROPERTY_EXECUTABLE);
        }
    }

    public Expert getExpert() {
        return this.expert;
    }

    public void setExpert(Expert expert) {
        if (this.expert != expert) {
            Expert oldExpert = this.expert;
            if (oldExpert != null) {
                oldExpert.removeAllPropertyChangeListeners();
            }
            this.expert = expert;
            if (this.expert != null) {
                this.expert.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                    @Override
                    public void propertyChange(IModel model, String propertyName) {
                        Session.this.dirty = true;
                        Session.this.firePropertyChange(Session.PROPERTY_EXPERT);
                    }
                });
            }
            this.dirty = true;
            this.firePropertyChange(PROPERTY_EXPERT);
        }
    }

    public ExpertData getExpertData() {
        if (this.expertData == null) {
            this.expertData = new ExpertData(this);
            this.expertData.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                @Override
                public void propertyChange(IModel model, String propertyName) {
                    Session.this.firePropertyChange(Session.PROPERTY_EXPERTDATA);
                }
            });
        }
        return this.expertData;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(Analysis analysis) {
        if (this.analysis != analysis) {
            Analysis oldAnalysis = this.analysis;
            if (oldAnalysis != null) {
                oldAnalysis.removeAllPropertyChangeListeners();
            }
            this.analysis = analysis;
            if (this.analysis != null) {
                this.analysis.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                    @Override
                    public void propertyChange(IModel model, String propertyName) {
                        if ("analysis:visited".equals(propertyName) || "analysis:guided".equals(propertyName) || "analysis:pciegen".equals(propertyName) || "analysis:pcielinkrate".equals(propertyName) || "analysis:pcielinkwidth".equals(propertyName)) {
                            Session.this.dirty = true;
                        }
                        Session.this.firePropertyChange(Session.PROPERTY_ANALYSIS);
                    }
                });
            }
            this.dirty = true;
            this.firePropertyChange(PROPERTY_ANALYSIS);
        }
    }

    public ExpertSystem getExpertSystem() {
        return this.expertSystem;
    }

    public void setExpertSystem(ExpertSystem expertSystem) {
        if (this.expertSystem != expertSystem) {
            ExpertSystem oldExpertSystem = this.expertSystem;
            if (oldExpertSystem != null) {
                oldExpertSystem.removeAllPropertyChangeListeners();
            }
            this.expertSystem = expertSystem;
            if (this.expertSystem != null) {
                this.expertSystem.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                    @Override
                    public void propertyChange(IModel model, String propertyName) {
                        Session.this.dirty = true;
                        Session.this.firePropertyChange(Session.PROPERTY_EXPERT_SYSTEM);
                    }
                });
            }
            this.dirty = true;
            this.firePropertyChange(PROPERTY_EXPERT_SYSTEM);
        }
    }

    public SourceLocator getSourceLocator() {
        return this.sourceLocator;
    }

    public CudaFunctionManager getCudaFunctionManager() {
        return this.cudaFunctionManager;
    }

    public void setSourceLocator(SourceLocator sourceLocator) {
        if (this.sourceLocator != sourceLocator) {
            this.sourceLocator = sourceLocator;
            this.dirty = true;
        }
    }

    public ProfileDataModel getPdm() throws ViperException {
        ProfileDataModel pdm = new ProfileDataModel();
        try {
            this.sourceLocator.appendToPDM(pdm);
            this.cudaFunctionManager.appendToPDM(pdm);
            for (Timeline timeline : this.getTimelines()) {
                if (!timeline.getKind().appendsToPDM()) continue;
                timeline.appendToPDM(pdm);
            }
        }
        catch (ViperException e) {
            if (CUptiResult.CUPTI_ERROR_OUT_OF_MEMORY.name().equals(e.toString().trim())) {
                ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.OutOfMemoryWarning_Label, ViperMessages.OutOfMemorySaveWarning_Message);
            }
            throw e;
        }
        return pdm;
    }

    public TimelineDevice getDeviceTimeline(int deviceId) {
        List<Timeline> deviceTimelines = this.getTimelines(TimelineKind.DEVICE);
        for (Timeline timeline : deviceTimelines) {
            TimelineDevice deviceTimeline = (TimelineDevice)timeline;
            if (deviceTimeline.getId() != deviceId) continue;
            return deviceTimeline;
        }
        return null;
    }

    public String getDeviceName(int deviceId) {
        TimelineDevice deviceTimeline = this.getDeviceTimeline(deviceId);
        if (deviceTimeline != null) {
            return deviceTimeline.getName();
        }
        return null;
    }

    public List<Timeline> getVisibleTimelines() {
        if (this.allVisibleTimelines == null) {
            List<Timeline> timelines = this.getTimelines();
            this.allVisibleTimelines = new ArrayList<Timeline>(timelines.size());
            for (Timeline tl : timelines) {
                if (!tl.isVisible()) continue;
                this.allVisibleTimelines.add(tl);
            }
            this.allVisibleTimelines = Collections.unmodifiableList(this.allVisibleTimelines);
        }
        return this.allVisibleTimelines;
    }

    public List<Timeline> getTimelines() {
        if (this.allTimelines == null) {
            this.allTimelines = new LinkedList<Timeline>();
            for (Timeline tl : this.topLevelTimelines) {
                this.allTimelines.add(tl);
                this.collectDescendants(tl, this.allTimelines);
            }
            this.allTimelines = Collections.unmodifiableList(this.allTimelines);
        }
        return this.allTimelines;
    }

    public List<Timeline> getTopLevelTimelines() {
        return Collections.unmodifiableList(this.topLevelTimelines);
    }

    private void collectDescendants(Timeline parent, List<Timeline> tls) {
        for (Timeline child : parent.getChildren()) {
            tls.add(child);
            this.collectDescendants(child, tls);
        }
    }

    protected void clearAllTimelineList() {
        this.allTimelines = null;
    }

    protected void clearAllVisibleTimelineList() {
        this.allVisibleTimelines = null;
    }

    public List<Timeline> getTimelines(TimelineKind kind) {
        return this.getTimelines(Arrays.asList(kind));
    }

    public List<Timeline> getTimelines(Collection<TimelineKind> kinds) {
        ArrayList<Timeline> ctls = new ArrayList<Timeline>();
        for (Timeline tl : this.getTimelines()) {
            if (!kinds.contains((Object)tl.getKind())) continue;
            ctls.add(tl);
        }
        return ctls;
    }

    protected void initTimeline(Timeline timeline) {
        timeline.setSession(this);
        timeline.addPropertyChangeListener(new ISessionPropertyChangeListener(){

            @Override
            public void propertyChange(IModel model, String propertyName) {
                String propagatePropertyName = Session.PROPERTY_TIMELINE;
                if ("timeline:visible".equals(propertyName) || "timeline:filtered".equals(propertyName)) {
                    Session.this.handleVisibilityChange();
                } else if ("timeline:ievent".equals(propertyName)) {
                    if (Session.this.expertData != null) {
                        Session.this.expertData.refreshEvents(true, true);
                    }
                    Session.this.dirty = true;
                } else if ("timeline:imetric".equals(propertyName)) {
                    if (Session.this.expertData != null) {
                        Session.this.expertData.refreshMetrics(true, true);
                    }
                    Session.this.dirty = true;
                } else if ("timeline:children".equals(propertyName)) {
                    Session.this.clearAllTimelineList();
                    Session.this.clearAllVisibleTimelineList();
                    Session.this.setTimelineBackgroundColors();
                    propagatePropertyName = Session.PROPERTY_TIMELINES;
                    Session.this.dirty = true;
                }
                Session.this.firePropertyChange(propagatePropertyName);
            }
        });
        for (Timeline child : timeline.getChildren()) {
            this.initTimeline(child);
        }
    }

    public boolean addTopLevelTimeline(Timeline timeline, boolean update) {
        if (timeline.getParent() != null) {
            return false;
        }
        this.topLevelTimelines.add(timeline);
        this.initTimeline(timeline);
        this.dirty = true;
        this.clearAllTimelineList();
        this.clearAllVisibleTimelineList();
        if (update) {
            this.setTimelineBackgroundColors();
            this.updateMaxHorizontalScale();
            if (this.expertData != null) {
                this.expertData.refresh(true, true);
            }
            this.firePropertyChange(PROPERTY_TIMELINES);
        }
        return true;
    }

    public boolean removeTopLevelTimeline(Timeline timeline, boolean update) {
        if (timeline.getParent() != null) {
            return false;
        }
        boolean removed = this.removeTimelineRec(timeline);
        removed &= this.topLevelTimelines.remove(timeline);
        this.clearAllTimelineList();
        this.clearAllVisibleTimelineList();
        this.dirty = true;
        if (update) {
            this.updateMaxHorizontalScale();
            this.setTimelineBackgroundColors();
            if (this.expertData != null) {
                this.expertData.refresh(true, true);
            }
            this.firePropertyChange(PROPERTY_TIMELINES);
        }
        return removed;
    }

    private boolean removeTimelineRec(Timeline timeline) {
        boolean removed = true;
        timeline.removeAllPropertyChangeListeners();
        for (Timeline child : timeline.getChildren()) {
            removed &= this.removeTimelineRec(child);
            timeline.removeChild(child);
        }
        timeline.dispose();
        return removed;
    }

    public void setTimelines(ProfileDataModel profileDataModel) throws ViperException {
        final TimelineFactory[] factory = new TimelineFactory[1];
        if (profileDataModel != null) {
            factory[0] = new TimelineFactory(profileDataModel);
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Session.this.createTimelines(factory[0]);
                }
                catch (ViperException e) {
                    ViperExceptionHandler.handle(ViperMessages.LoadPdm_Fail_Title, ViperMessages.LoadPdm_Fail_Message, e);
                }
            }
        });
    }

    public void setTimelinesMultiplePdms(ProfileDataModel[] pdms) throws ViperException {
        final TimelineFactory factory = new TimelineFactory(pdms);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Session.this.createTimelines(factory);
                }
                catch (ViperException e) {
                    ViperExceptionHandler.handle(ViperMessages.LoadPdm_Fail_Title, ViperMessages.LoadPdm_Fail_Message, e);
                }
            }
        });
    }

    private void createTimelines(TimelineFactory factory) throws ViperException {
        ArrayList<Timeline> rtimelines = new ArrayList<Timeline>(this.topLevelTimelines);
        this.topLevelTimelines.clear();
        this.clearAllTimelineList();
        this.clearAllVisibleTimelineList();
        this.pdmStartTime = -1L;
        this.pdmSize = -1;
        this.startCorrelationId = -1L;
        this.endCorrelationId = -1L;
        this.firePropertyChange(PROPERTY_TIMELINE_RESET);
        this.firePropertyChange(PROPERTY_SESSION);
        for (Timeline tl : rtimelines) {
            this.removeTopLevelTimeline(tl, false);
        }
        try {
            ModelWithProperties.disableAllNotifications();
            if (!this.topLevelTimelines.isEmpty() || this.timelineState == null) {
                this.timelineState = new TimelineState();
            }
            this.setPrimaryAndSecondarySelected(null, null, false, true);
            if (this.analysis != null) {
                this.analysis.resetForNewTimeline();
            }
            if (this.expertSystem != null) {
                this.expertSystem.resetForNewTimeline();
            }
            if (this.sourceLocator != null) {
                this.sourceLocator.resetForNewTimeline();
            }
            if (this.cudaFunctionManager != null) {
                this.cudaFunctionManager.resetForNewTimeline();
            }
            if (factory != null) {
                factory.createTimelines(this);
                for (Timeline tl : this.getTimelines()) {
                    tl.assignVisibleIntervalRows();
                }
            }
            this.timelineState.apply();
            this.setTimelineIntervalColors(this.colorMode, this.colorMode);
            this.clearAllTimelineList();
            this.clearAllVisibleTimelineList();
            this.setTimelineBackgroundColors();
            this.updateMaxHorizontalScale();
            if (this.expertData != null) {
                this.expertData.refresh(true, true);
            }
            if (!this.topLevelTimelines.isEmpty() && this.analysis != null) {
                this.analysis.setVisitedStage(AnalysisStage.TIMELINE, null, true);
            }
        }
        finally {
            ModelWithProperties.enableAllNotifications();
        }
        this.firePropertyChange(PROPERTY_SESSION);
        this.firePropertyChange(PROPERTY_TIMELINES);
    }

    public boolean mergeTimelines(ProfileDataModel profileDataModel, SessionFilter scope, boolean mergeEvents, boolean mergeMetrics, boolean mergeSourceLevelResults, Set<SourceLevelResult> nullSourceLevelResults) throws ViperException {
        boolean completeMerge = true;
        if (profileDataModel != null) {
            TimelineFactory factory = new TimelineFactory(profileDataModel);
            completeMerge = factory.merge(this, scope, mergeEvents, mergeMetrics, mergeSourceLevelResults, nullSourceLevelResults);
            if (this.expertData != null) {
                if (mergeEvents) {
                    this.expertData.refreshEvents(true, true);
                }
                if (mergeMetrics) {
                    this.expertData.refreshMetrics(true, true);
                }
            }
            this.firePropertyChange(PROPERTY_TIMELINE);
        }
        return completeMerge;
    }

    private Color nextTimelineBackgroundColor() {
        Color next = this.currentTimelineBGColor;
        this.currentTimelineBGColor = this.currentTimelineBGColor.equals((Object)ViperColors.TIMELINE_BGCOLOR_0) ? ViperColors.TIMELINE_BGCOLOR_1 : ViperColors.TIMELINE_BGCOLOR_0;
        return next;
    }

    private void setTimelineBackgroundColors() {
        this.currentTimelineBGColor = ViperColors.TIMELINE_BGCOLOR_0;
        List<Timeline> bgtimelines = this.getVisibleTimelines();
        for (Timeline tl : bgtimelines) {
            tl.setBackgroundColor(this.nextTimelineBackgroundColor());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void setTimelineIntervalColors(TimelineColorMode oldColorMode, TimelineColorMode newColorMode) {
        block32: {
            List<Timeline> colorTimelines;
            Object tls;
            ArrayList<Timeline> containerTimelines = new ArrayList<Timeline>();
            List<Timeline> deviceTimelines = this.getTimelines(TimelineKind.DEVICE);
            for (Timeline device : deviceTimelines) {
                List<Timeline> contextTimelines = device.getDescendants(TimelineKind.CONTEXT);
                if (contextTimelines.isEmpty()) {
                    containerTimelines.add(device);
                    continue;
                }
                containerTimelines.addAll(contextTimelines);
            }
            int numColors = 0;
            if (newColorMode.equals((Object)TimelineColorMode.PROCESS)) {
                List<Timeline> processes = this.getTimelines(TimelineKind.PROCESS);
                numColors = processes.size();
            } else {
                for (Timeline container : containerTimelines) {
                    if (newColorMode == TimelineColorMode.STREAM) {
                        List<Timeline> tls2 = container.getDescendants(TimelineKind.STREAM);
                        numColors = Math.max(numColors, tls2.size());
                        continue;
                    }
                    if (newColorMode != TimelineColorMode.KERNEL) continue;
                    HashSet<String> kernelNames = new HashSet<String>();
                    tls = container.getDescendants(TimelineKind.KERNEL);
                    Iterator iterator = tls.iterator();
                    while (iterator.hasNext()) {
                        Timeline tl = (Timeline)iterator.next();
                        kernelNames.add(tl.getName());
                    }
                    numColors = Math.max(numColors, kernelNames.size());
                }
            }
            if (this.timelineIntervalColors == null || this.timelineIntervalColors.length < numColors) {
                if (this.timelineIntervalColors != null) {
                    tls = this.timelineIntervalColors;
                    int kernelNames = this.timelineIntervalColors.length;
                    int contextTimelines = 0;
                    while (contextTimelines < kernelNames) {
                        Object color = tls[contextTimelines];
                        ((ViperColors.GradientColors)color).dispose();
                        ++contextTimelines;
                    }
                }
                List<ViperColors.GradientColors> colors = ViperColors.getGradientColors(numColors, ViperColors.INTERVAL_KERNEL_COLORTHEME);
                this.timelineIntervalColors = colors.toArray(new ViperColors.GradientColors[0]);
            }
            if (oldColorMode.equals((Object)TimelineColorMode.STREAM) || oldColorMode.equals((Object)TimelineColorMode.PROCESS)) {
                colorTimelines = this.getTimelines(Arrays.asList(TimelineKind.MEMCPY_DTOH, TimelineKind.MEMCPY_HTOD, TimelineKind.MEMCPY_DTOD, TimelineKind.MEMCPY_PTOP));
                for (Timeline tl : colorTimelines) {
                    tl.setIntervalColors(null);
                }
            }
            if (oldColorMode.equals((Object)TimelineColorMode.PROCESS)) {
                colorTimelines = this.getTimelines(Arrays.asList(TimelineKind.UVM_MEMCPY_HTOD, TimelineKind.UVM_MEMCPY_DTOH, TimelineKind.UVM_PAGE_FAULT));
                for (Timeline t1 : colorTimelines) {
                    t1.setIntervalColors(null);
                }
            }
            if (numColors <= 0 || this.timelineIntervalColors.length <= 0) break block32;
            if (newColorMode == TimelineColorMode.PROCESS) {
                HashMap<Integer, void> processIdMap = new HashMap<Integer, void>();
                List<Timeline> streams = this.getTimelines(TimelineKind.STREAM);
                for (Timeline streamTimeline : streams) {
                    void var11_35;
                    int procId;
                    if (!(streamTimeline instanceof TimelineStream) || (procId = ((TimelineStream)streamTimeline).getProcessId()) <= -1) continue;
                    if (processIdMap.containsKey(procId)) {
                        Set set = (Set)processIdMap.get(procId);
                    } else {
                        HashSet hashSet = new HashSet();
                    }
                    var11_35.add(streamTimeline);
                    processIdMap.put(procId, var11_35);
                }
                List<Timeline> uvms = this.getTimelines(Arrays.asList(TimelineKind.UVM_MEMCPY_DTOH, TimelineKind.UVM_MEMCPY_HTOD, TimelineKind.UVM_PAGE_FAULT));
                int idx = 0;
                int stride = this.timelineIntervalColors.length / numColors;
                List<Timeline> list = this.getTimelines(TimelineKind.PROCESS);
                for (Timeline process : list) {
                    if (!(process instanceof TimelineProcess)) continue;
                    int processId = ((TimelineProcess)process).getId();
                    Set tls3 = (Set)processIdMap.get(processId);
                    if (tls3 != null) {
                        for (Timeline tl : tls3) {
                            tl.setIntervalColors(this.timelineIntervalColors[idx]);
                        }
                    }
                    for (Timeline uvm : uvms) {
                        if (!(uvm instanceof TimelineUVM)) continue;
                        ((TimelineUVM)uvm).setIntervalColors(processId, this.timelineIntervalColors[idx]);
                    }
                    idx += stride;
                }
            } else {
                for (Timeline container : containerTimelines) {
                    LinkedList timelineColorSets = new LinkedList();
                    if (newColorMode == TimelineColorMode.STREAM) {
                        List<Timeline> tls4 = container.getDescendants(TimelineKind.STREAM);
                        for (Timeline tl : tls4) {
                            HashSet<Timeline> set = new HashSet<Timeline>();
                            set.add(tl);
                            timelineColorSets.add(set);
                        }
                    } else if (newColorMode == TimelineColorMode.KERNEL) {
                        HashMap<String, HashSet<Timeline>> kernelNameMap = new HashMap<String, HashSet<Timeline>>();
                        List<Timeline> tls5 = container.getDescendants(TimelineKind.KERNEL);
                        for (Timeline timeline : tls5) {
                            HashSet<Timeline> set = (HashSet<Timeline>)kernelNameMap.get(timeline.getName());
                            if (set == null) {
                                set = new HashSet<Timeline>();
                                timelineColorSets.add(set);
                                kernelNameMap.put(timeline.getName(), set);
                            }
                            set.add(timeline);
                        }
                    }
                    int idx = 0;
                    int stride = this.timelineIntervalColors.length / numColors;
                    for (Set set : timelineColorSets) {
                        for (Timeline tl : set) {
                            tl.setIntervalColors(this.timelineIntervalColors[idx]);
                        }
                        idx += stride;
                    }
                }
            }
        }
    }

    public long getDuration() {
        Long duration = 0L;
        for (Timeline tl : this.getTimelines()) {
            duration = Math.max(duration, tl.getDuration());
        }
        return duration;
    }

    public long getVisibleDuration() {
        Long duration = 0L;
        for (Timeline tl : this.getVisibleTimelines()) {
            duration = Math.max(duration, tl.getDuration());
        }
        return duration;
    }

    public TimelineRuler getHorizontalRuler() {
        return this.horizontalRuler;
    }

    public void setHorizontalRuler(TimelineRuler horizontalRuler) {
        if (this.horizontalRuler != horizontalRuler) {
            TimelineRuler oldHr = this.horizontalRuler;
            if (oldHr != null) {
                oldHr.removeAllPropertyChangeListeners();
            }
            this.horizontalRuler = horizontalRuler;
            if (this.horizontalRuler != null) {
                this.horizontalRuler.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                    @Override
                    public void propertyChange(IModel model, String propertyName) {
                        Session.this.firePropertyChange(Session.PROPERTY_HRULER);
                    }
                });
            }
            this.dirty = true;
            this.firePropertyChange(PROPERTY_HRULER);
        }
    }

    public VerticalRuler getVerticalRuler() {
        return this.verticalRuler;
    }

    public void setVerticalRuler(VerticalRuler verticalRuler) {
        if (this.verticalRuler != verticalRuler) {
            VerticalRuler oldVr = this.verticalRuler;
            if (oldVr != null) {
                oldVr.removeAllPropertyChangeListeners();
            }
            this.verticalRuler = verticalRuler;
            if (this.verticalRuler != null) {
                this.verticalRuler.addPropertyChangeListener(new ISessionPropertyChangeListener(){

                    @Override
                    public void propertyChange(IModel model, String propertyName) {
                        Session.this.dirty = true;
                        Session.this.firePropertyChange(Session.PROPERTY_VRULER);
                    }
                });
            }
            this.dirty = true;
            this.firePropertyChange(PROPERTY_VRULER);
        }
    }

    public double getHorizontalScale() {
        return this.horizontalScale;
    }

    public void setHorizontalScale(double hScale) {
        if (hScale > 0.0 && hScale != this.horizontalScale) {
            this.horizontalScale = Math.min(this.maxHorizontalScale, hScale);
            this.dirty = true;
            this.firePropertyChange(PROPERTY_HORIZONTAL_SCALE);
        }
    }

    protected void updateMaxHorizontalScale() {
        this.maxHorizontalScale = this.getDuration() > 0L ? 1.073741823E9 / (double)this.getDuration() : 1.0E-6;
        if (this.horizontalScale > this.maxHorizontalScale) {
            this.setHorizontalScale(this.maxHorizontalScale);
        }
    }

    public int getHorizontalReveal() {
        return this.horizontalReveal;
    }

    public void setHorizontalReveal(int horizontalReveal) {
        this.horizontalReveal = horizontalReveal;
        this.firePropertyChange(PROPERTY_HORIZONTAL_REVEAL);
    }

    public int getVerticalReveal() {
        return this.verticalReveal;
    }

    public void setVerticalReveal(int verticalReveal) {
        this.verticalReveal = verticalReveal;
        this.firePropertyChange(PROPERTY_VERTICAL_REVEAL);
    }

    public void revealTimelineInterval(TimelineIntervalPair pair) {
        Timeline timeline = pair.getTimeline();
        if (timeline != null) {
            int Y = 0;
            for (Timeline tl : this.getVisibleTimelines()) {
                if (tl.equals(timeline)) break;
                Y += TimelineFigure.getScaledTimelineHeight(tl);
            }
            this.setVerticalReveal(Y);
            this.setVerticalReveal(Y + TimelineFigure.getScaledTimelineHeight(timeline));
            ITimelineInterval interval = pair.getInterval();
            if (interval != null) {
                int startX = (int)Math.round(this.horizontalScale * (double)interval.getStart());
                int endX = (int)Math.round(this.horizontalScale * (double)interval.getExtendedEnd());
                this.setHorizontalReveal(startX);
                this.setHorizontalReveal(endX);
            }
        }
    }

    public TimelineIntervalPair getPrimaryHighlighted() {
        return this.primaryHighlighted;
    }

    public Collection<TimelineIntervalPair> getHighlighted() {
        if (this.allHighlighted == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.allHighlighted);
    }

    public void setPrimaryHighlighted(TimelineIntervalPair highlight) {
        boolean p;
        boolean bl = this.primaryHighlighted == null ? highlight == null : (p = this.primaryHighlighted.equals(highlight));
        if (!p) {
            this.primaryHighlighted = highlight;
            if (this.primaryHighlighted != null && this.primaryHighlighted.getInterval() == null && this.primaryHighlighted.getTimeline() == null) {
                this.primaryHighlighted = null;
            }
            this.updateCorrelatedHighlightIntervals();
            this.firePropertyChange(PROPERTY_HIGHLIGHT_INTERVAL);
        }
    }

    public TimelineIntervalPair getPrimarySelected() {
        return this.primarySelected;
    }

    public Collection<TimelineIntervalPair> getSecondarySelected() {
        if (this.secondarySelected == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.secondarySelected);
    }

    public Collection<TimelineIntervalPair> getAllSelected() {
        if (this.allSelected == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.allSelected);
    }

    public Collection<ITimelineInterval> getAllSelectedIntervals() {
        if (this.allSelectedIntervals == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.allSelectedIntervals);
    }

    public void setPrimarySelected(TimelineIntervalPair selected, boolean setAnalysisInterval) {
        boolean p;
        boolean bl = this.primarySelected == null ? selected == null : (p = this.primarySelected.equals(selected));
        if (!p) {
            this.setPrimaryAndSecondarySelected(selected, null, false, setAnalysisInterval);
        }
    }

    public void setPrimaryAndSecondarySelected(TimelineIntervalPair primary, Collection<TimelineIntervalPair> secondary, boolean selectCorrelated, boolean setAnalysisInterval) {
        this.primarySelected = primary;
        if (this.primarySelected != null && this.primarySelected.getInterval() == null && this.primarySelected.getTimeline() == null) {
            this.primarySelected = null;
        }
        if (this.primarySelected == null) {
            this.secondarySelected = null;
            this.allSelected = null;
            this.allSelectedIntervals = null;
        } else {
            this.secondarySelected = null;
            this.allSelected = new HashSet<TimelineIntervalPair>();
            this.allSelected.add(this.primarySelected);
            this.allSelectedIntervals = null;
            if (this.primarySelected.getInterval() != null) {
                this.allSelectedIntervals = new HashSet<ITimelineInterval>();
                this.allSelectedIntervals.add(this.primarySelected.getInterval());
            }
            if (secondary != null) {
                for (TimelineIntervalPair sec : secondary) {
                    if (sec == null || sec.getInterval() == null && sec.getTimeline() == null) continue;
                    if (this.secondarySelected == null) {
                        this.secondarySelected = new HashSet<TimelineIntervalPair>();
                    }
                    this.secondarySelected.add(sec);
                    this.allSelected.add(sec);
                    if (sec.getInterval() == null) continue;
                    if (this.allSelectedIntervals == null) {
                        this.allSelectedIntervals = new HashSet<ITimelineInterval>();
                    }
                    this.allSelectedIntervals.add(sec.getInterval());
                }
            }
            if (selectCorrelated) {
                TimelineIntervalPair[] pairs;
                TimelineIntervalPair[] timelineIntervalPairArray = pairs = this.allSelected.toArray(new TimelineIntervalPair[0]);
                int n = pairs.length;
                int n2 = 0;
                while (n2 < n) {
                    TimelineIntervalPair pair = timelineIntervalPairArray[n2];
                    ITimelineInterval interval = pair.getInterval();
                    if (interval instanceof TimelineIntervalHierarchy) {
                        TimelineIntervalHierarchy hier = (TimelineIntervalHierarchy)interval;
                        HashSet<TimelineIntervalHierarchy> family = new HashSet<TimelineIntervalHierarchy>();
                        hier.getAncestors(family);
                        hier.getDescendants(family);
                        this.getCorrelatedIntervals(hier, family);
                        for (TimelineIntervalHierarchy f : family) {
                            this.allSelected.add(new TimelineIntervalPair(f.getPrimaryTimeline(), f));
                            if (this.allSelectedIntervals == null) {
                                this.allSelectedIntervals = new HashSet<ITimelineInterval>();
                            }
                            this.allSelectedIntervals.add(f);
                        }
                    }
                    ++n2;
                }
            }
        }
        if (this.expertData != null) {
            this.expertData.refreshResults(true, true);
        }
        if (setAnalysisInterval && this.analysis != null) {
            this.analysis.setActiveScopeInterval(this.primarySelected == null ? null : this.primarySelected.getInterval());
        }
        this.firePropertyChange(PROPERTY_SELECTED_INTERVAL);
    }

    private void getCorrelatedIntervals(TimelineIntervalHierarchy interval, Set<TimelineIntervalHierarchy> correlatedIntervals) {
        TimelineIntervalHierarchy oldsetAncestor = interval.getOldestAncestor();
        HashSet<TimelineIntervalHierarchy> allDescendants = new HashSet<TimelineIntervalHierarchy>();
        oldsetAncestor.getDescendants(allDescendants);
        for (TimelineIntervalHierarchy child : allDescendants) {
            if (child.getCorrelationId() == 0 || child.getCorrelationId() != interval.getCorrelationId()) continue;
            correlatedIntervals.add(child);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    protected void updateCorrelatedHighlightIntervals() {
        if (this.primaryHighlighted == null) {
            this.allHighlighted = null;
        } else {
            this.allHighlighted = new HashSet<TimelineIntervalPair>();
            this.allHighlighted.add(this.primaryHighlighted);
            HashSet<TimelineIntervalHierarchy> family = new HashSet<TimelineIntervalHierarchy>();
            ITimelineInterval interval = this.primaryHighlighted.getInterval();
            if (interval instanceof TimelineIntervalKernel || interval instanceof TimelineIntervalMemset || interval instanceof TimelineIntervalMemcpy) {
                interval = ((TimelineIntervalHierarchy)interval).getParent();
            }
            if (interval instanceof TimelineIntervalAPI) {
                TimelineIntervalHierarchy api = (TimelineIntervalHierarchy)interval;
                TimelineIntervalHierarchy oldest = api.getOldestAncestor();
                family.add(oldest);
                this.getHostLaunchedDescendants(oldest, family);
            }
            for (TimelineIntervalHierarchy f : family) {
                this.allHighlighted.add(new TimelineIntervalPair(f.getPrimaryTimeline(), f));
            }
        }
    }

    public void getHostLaunchedDescendants(TimelineIntervalHierarchy interval, Collection<TimelineIntervalHierarchy> hostLaunchedDescendants) {
        HashSet<TimelineIntervalHierarchy> descendants = new HashSet<TimelineIntervalHierarchy>();
        interval.getDescendants(descendants);
        for (TimelineIntervalHierarchy child : descendants) {
            TimelineIntervalKind childKind = child.getKind();
            if (!childKind.equals((Object)TimelineIntervalKind.DRIVER) && !childKind.equals((Object)TimelineIntervalKind.KERNEL) && !childKind.equals((Object)TimelineIntervalKind.MEMSET) && !childKind.equals((Object)TimelineIntervalKind.MEMCPY_DTOD) && !childKind.equals((Object)TimelineIntervalKind.MEMCPY_DTOH) && !childKind.equals((Object)TimelineIntervalKind.MEMCPY_HTOD) && !childKind.equals((Object)TimelineIntervalKind.MEMCPY_PTOP) || !(child.getParent() instanceof TimelineIntervalAPI)) continue;
            hostLaunchedDescendants.add(child);
        }
    }

    public void unfocusAllTimelines() {
        for (Timeline timeline : this.getTimelines()) {
            timeline.setVisibleIntervals(null);
        }
        for (Timeline compute : this.getTimelines(TimelineKind.KERNELS)) {
            compute.refreshDescendantVisibility(true);
        }
    }

    public void focusOnIntervals(Collection<ITimelineInterval> focusIntervals) {
        if (focusIntervals != null) {
            HashMap<Timeline, Collection<ITimelineInterval>> timelines = new HashMap<Timeline, Collection<ITimelineInterval>>();
            for (ITimelineInterval interval : focusIntervals) {
                if (interval.getPrimaryTimeline() == null) continue;
                this.addTimelineFocusInterval(timelines, interval.getPrimaryTimeline(), interval);
                if (!(interval instanceof TimelineIntervalHierarchy)) continue;
                HashSet<TimelineIntervalHierarchy> family = new HashSet<TimelineIntervalHierarchy>();
                ((TimelineIntervalHierarchy)interval).getAncestors(family);
                ((TimelineIntervalHierarchy)interval).getDescendants(family);
                for (TimelineIntervalHierarchy f : family) {
                    TimelineIntervalHierarchy fi = f;
                    Timeline ft = fi.getPrimaryTimeline();
                    if (ft == null) continue;
                    this.addTimelineFocusInterval(timelines, ft, fi);
                }
            }
            for (Timeline timeline : this.getTimelines()) {
                if (timelines.containsKey(timeline)) {
                    timeline.setVisibleIntervals((Collection)timelines.get(timeline));
                    continue;
                }
                if (!(timeline instanceof TimelineKernel)) continue;
                Set<ITimelineInterval> empty = Collections.emptySet();
                timeline.setVisibleIntervals(empty);
                timeline.setVisible(false);
            }
            HashSet<Timeline> allTimelines = new HashSet<Timeline>(timelines.keySet());
            block3: for (Timeline timeline : timelines.keySet()) {
                Timeline parent = timeline.getParent();
                while (parent != null) {
                    if (allTimelines.contains(parent)) continue block3;
                    allTimelines.add(parent);
                    parent = parent.getParent();
                }
            }
            this.focusOnTimelines(this.getTopLevelTimelines(), allTimelines);
        }
    }

    private void addTimelineFocusInterval(Map<Timeline, Collection<ITimelineInterval>> map, Timeline timeline, ITimelineInterval interval) {
        Collection<ITimelineInterval> intervals = map.get(timeline);
        if (intervals == null) {
            intervals = new HashSet<ITimelineInterval>();
            map.put(timeline, intervals);
        }
        intervals.add(interval);
    }

    private void focusOnTimelines(Collection<Timeline> visitTimelines, Collection<Timeline> revealTimelines) {
        for (Timeline visit : visitTimelines) {
            block3: {
                block4: {
                    ContainerState cState;
                    block6: {
                        block5: {
                            if (!revealTimelines.contains(visit)) break block3;
                            if (!visit.isContainer()) break block4;
                            cState = ContainerState.CLOSED;
                            if (!TimelineKind.CONTEXT.equals((Object)visit.getKind())) break block5;
                            if (ContainerState.CLOSED.equals((Object)visit.getContainerState())) break block6;
                            cState = visit.getContainerState();
                            break block6;
                        }
                        for (Timeline child : visit.getChildren()) {
                            if (!revealTimelines.contains(child)) continue;
                            cState = ContainerState.OPEN_ALL;
                            break;
                        }
                    }
                    visit.setContainerState(cState);
                }
                if (visit.getKind().isFilterable()) {
                    visit.setFiltered(false);
                }
                this.focusOnTimelines(visit.getChildren(), revealTimelines);
                continue;
            }
            if (!visit.isContainer() || TimelineKind.STREAMS.equals((Object)visit.getKind())) continue;
            visit.setContainerState(ContainerState.CLOSED);
        }
    }

    private void handleVisibilityChange() {
        this.clearAllVisibleTimelineList();
        this.setTimelineBackgroundColors();
        if (this.expertData != null) {
            this.expertData.refreshResults(true, true);
        }
        this.dirty = true;
    }

    public void fireGlobalVisibilityChange() {
        this.handleVisibilityChange();
        this.firePropertyChange(PROPERTY_TIMELINE);
    }

    @Override
    public void write(Writer w) throws ViperException {
        try {
            w.write("<session version=\"" + this.version + "\"");
            if (this.name != null) {
                w.write(" name=\"" + XmlUtil.escapeString((String)this.name) + "\"");
            }
            w.write(" hscale=\"" + this.horizontalScale + "\"");
            w.write(">\n");
            if (this.executable != null) {
                this.executable.write(w);
            }
            if (this.expert != null) {
                this.expert.write(w);
            }
            if (this.analysis != null) {
                this.analysis.write(w);
            }
            if (this.expertSystem != null) {
                this.expertSystem.write(w);
            }
            if (this.verticalRuler != null) {
                this.verticalRuler.write(w);
            }
            if (this.horizontalRuler != null) {
                this.horizontalRuler.write(w);
            }
            if (this.timelineState != null) {
                this.timelineState.write(w);
            }
            ProfileDataModel pdm = this.getPdm();
            try {
                pdm.write(w);
            }
            finally {
                pdm.dispose();
            }
            w.write("</session>\n");
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }

    protected void read(Element el) throws ViperException {
        if (!"session".equals(el.getTagName())) {
            throw new ViperException("expected \"session\" tag, got " + el.getTagName());
        }
        try {
            this.version = Integer.parseInt(el.getAttribute("version"));
            this.setName(StringUtils.emptyToNull(el.getAttribute("name")));
            this.setHorizontalScale(Double.parseDouble(el.getAttribute("hscale")));
        }
        catch (NumberFormatException e) {
            throw new ViperException("unable to parse version, name, or hscale", e);
        }
        NodeList execList = el.getElementsByTagName("executable");
        switch (execList.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                this.setExecutable(new Executable((Element)execList.item(0)));
                break;
            }
            default: {
                throw new ViperException("expected 0 or 1 <executable> tags, got " + execList.getLength());
            }
        }
        NodeList expertList = el.getElementsByTagName("expert");
        switch (expertList.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                this.setExpert(new Expert((Element)expertList.item(0)));
                break;
            }
            default: {
                throw new ViperException("expected 0 or 1 <expert> tags, got " + expertList.getLength());
            }
        }
        NodeList vrulerList = el.getElementsByTagName("vruler");
        switch (vrulerList.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                this.setVerticalRuler(new VerticalRuler(this, (Element)vrulerList.item(0)));
                break;
            }
            default: {
                throw new ViperException("expected 0 or 1 <vruler> tags, got " + vrulerList.getLength());
            }
        }
        NodeList hrulerList = el.getElementsByTagName("hruler");
        switch (hrulerList.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                this.setHorizontalRuler(new TimelineRuler(this, (Element)hrulerList.item(0)));
                break;
            }
            default: {
                throw new ViperException("expected 0 or 1 <hruler> tags, got " + hrulerList.getLength());
            }
        }
        NodeList tlList = el.getElementsByTagName("timelinestate");
        switch (tlList.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                this.timelineState = new TimelineState((Element)tlList.item(0));
                break;
            }
            default: {
                throw new ViperException("expected 0 or 1 <timelines> tags, got " + tlList.getLength());
            }
        }
        NodeList pdmList = el.getElementsByTagName("pdm");
        switch (pdmList.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                ProfileDataModel pdm = new ProfileDataModel((Element)pdmList.item(0));
                try {
                    try {
                        this.setTimelines(pdm);
                    }
                    catch (OutOfMemoryError e) {
                        ViperExceptionHandler.logError("Out of memory error", e);
                        LargeDataMessageDialog.show();
                        pdm.dispose();
                        break;
                    }
                }
                catch (Throwable throwable) {
                    pdm.dispose();
                    throw throwable;
                }
                pdm.dispose();
                break;
            }
            default: {
                throw new ViperException("expected 0 or 1 <pdm> tags, got " + pdmList.getLength());
            }
        }
        NodeList analysisList = el.getElementsByTagName("analysis");
        switch (analysisList.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                this.setAnalysis(new Analysis((Element)analysisList.item(0)));
                break;
            }
            default: {
                throw new ViperException("expected 0 or 1 <analysis> tags, got " + analysisList.getLength());
            }
        }
        NodeList expertSystemList = el.getElementsByTagName("expertsystem");
        switch (expertSystemList.getLength()) {
            case 0: {
                if (this.analysis == null) break;
                this.setExpertSystem(new ExpertSystem(this));
                break;
            }
            case 1: {
                this.setExpertSystem(new ExpertSystem(this, (Element)expertSystemList.item(0)));
                break;
            }
            default: {
                throw new ViperException("expected 0 or 1 <expertsystem> tags, got " + expertSystemList.getLength());
            }
        }
        if (!this.topLevelTimelines.isEmpty() && this.analysis != null) {
            this.analysis.setVisitedStage(AnalysisStage.TIMELINE, null, true);
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getLabel() {
        return this.getName();
    }

    public long getStartCorrelationId() {
        return this.startCorrelationId;
    }

    public void setStartCorrelationId(long startCorrelationId) {
        this.startCorrelationId = startCorrelationId;
    }

    public long getEndCorrelationId() {
        return this.endCorrelationId;
    }

    public void setEndCorrelationId(long endCorrelationId) {
        this.endCorrelationId = endCorrelationId;
    }

    public int getPdmSize() {
        return this.pdmSize;
    }

    public void setPdmSize(int size) {
        this.pdmSize = size;
    }

    public long getPdmStartTime() {
        return this.pdmStartTime;
    }

    public void setPdmStartTime(long startTime) {
        this.pdmStartTime = startTime;
    }

    protected class TimelineState {
        private Vector<State> orderedTimelineState = new Vector();
        Map<String, State> stateMap = new HashMap<String, State>();

        protected TimelineState(Element timelinesElement) throws ViperException {
            if (!"timelinestate".equals(timelinesElement.getTagName())) {
                throw new ViperException("expected \"timelinestate\" tag, got " + timelinesElement.getTagName());
            }
            NodeList tlList = timelinesElement.getElementsByTagName("timeline");
            int i = 0;
            while (i < tlList.getLength()) {
                ContainerState containerState;
                Element tlElement = (Element)tlList.item(i);
                if (!"timeline".equals(tlElement.getTagName())) {
                    throw new ViperException("expected \"timeline\" tag, got " + tlElement.getTagName());
                }
                String pathName = StringUtils.emptyToNull(tlElement.getAttribute("pathname"));
                TimelineKind kind = TimelineKind.valueOf(tlElement.getAttribute("kind"));
                boolean filtered = Boolean.parseBoolean(tlElement.getAttribute("filtered"));
                try {
                    containerState = ContainerState.valueOf(tlElement.getAttribute("containerstate"));
                }
                catch (Exception exception) {
                    containerState = ContainerState.OPEN_ALL;
                }
                this.addState(pathName, kind, containerState, filtered);
                ++i;
            }
        }

        protected TimelineState() {
            Map<Timeline, String> pathnames = this.getTimelinePathnames();
            for (Timeline tl : Session.this.getTimelines()) {
                String pathname;
                Timeline parent;
                if (tl instanceof TimelineKernel && (parent = tl.getParent()) != null && parent instanceof TimelineKernel || (pathname = pathnames.get(tl)) == null) continue;
                this.addState(pathname, tl.getKind(), tl.getContainerState(), tl.isFiltered());
            }
        }

        protected State addState(String pathname, TimelineKind kind, ContainerState containerState, boolean filtered) {
            State newState = new State(this.orderedTimelineState.size(), containerState, filtered);
            this.orderedTimelineState.add(newState);
            this.stateMap.put(pathname, newState);
            return newState;
        }

        protected void apply() {
            State state;
            String pathname;
            Map<Timeline, String> timelinePathNameMap = this.getTimelinePathnames();
            for (Timeline tl : Session.this.getTimelines()) {
                pathname = timelinePathNameMap.get(tl);
                if (pathname == null || !this.stateMap.containsKey(pathname)) continue;
                state = this.stateMap.get(pathname);
                tl.setFiltered(state.filtered);
            }
            for (Timeline tl : Session.this.getTimelines()) {
                pathname = timelinePathNameMap.get(tl);
                if (pathname == null || !this.stateMap.containsKey(pathname)) continue;
                state = this.stateMap.get(pathname);
                tl.setContainerState(state.containerState);
            }
            TimelineOrderComparator orderComparator = new TimelineOrderComparator(timelinePathNameMap);
            for (Timeline topLevelTimeline : Session.this.topLevelTimelines) {
                this.orderChildren(topLevelTimeline, orderComparator);
            }
        }

        private void orderChildren(Timeline parent, Comparator<Timeline> orderComparator) {
            List<Timeline> children = parent.getChildren();
            if (children.size() > 1) {
                boolean canReorder = true;
                for (Timeline child : children) {
                    canReorder &= child.getKind().canReorder();
                }
                if (canReorder) {
                    Timeline[] childrenArray = children.toArray(new Timeline[0]);
                    Arrays.sort(childrenArray, orderComparator);
                    int idx = 0;
                    while (idx < childrenArray.length) {
                        Timeline child = childrenArray[idx];
                        parent.appendChild(child);
                        ++idx;
                    }
                }
            }
            for (Timeline child : children) {
                this.orderChildren(child, orderComparator);
            }
        }

        protected Map<Timeline, String> getTimelinePathnames() {
            HashMap<Timeline, String> pathMap = new HashMap<Timeline, String>();
            for (Timeline timeline : Session.this.topLevelTimelines) {
                this.getTimelinePathnames(timeline, (IPath)new Path(""), pathMap);
            }
            return pathMap;
        }

        private void getTimelinePathnames(Timeline timeline, IPath parentPath, Map<Timeline, String> pathMap) {
            IPath path = parentPath.append(timeline.getIdentifyingName());
            pathMap.put(timeline, path.toString());
            for (Timeline child : timeline.getChildren()) {
                this.getTimelinePathnames(child, path, pathMap);
            }
        }

        protected void write(Writer w) throws ViperException {
            Map<Timeline, String> pathnames = this.getTimelinePathnames();
            try {
                w.write("<timelinestate>\n");
                for (Timeline tl : Session.this.getTimelines()) {
                    String pathname;
                    Timeline parent;
                    if (tl instanceof TimelineKernel && (parent = tl.getParent()) != null && parent instanceof TimelineKernel || (pathname = pathnames.get(tl)) == null) continue;
                    w.write("<timeline pathname=\"" + XmlUtil.escapeString((String)pathname) + "\" kind=\"" + tl.getKind().name() + "\" containerstate=\"" + tl.getContainerState().name() + "\" filtered=\"" + tl.isFiltered() + "\"/>\n");
                }
                w.write("</timelinestate>\n");
            }
            catch (Exception e) {
                throw new ViperException(e);
            }
        }

        private class State {
            private int index;
            private ContainerState containerState;
            private boolean filtered;

            private State(int index, ContainerState containerState, boolean filtered) {
                this.index = index;
                this.containerState = containerState;
                this.filtered = filtered;
            }
        }

        class TimelineOrderComparator
        implements Comparator<Timeline> {
            private Map<Timeline, String> timelinePathNameMap;

            public TimelineOrderComparator(Map<Timeline, String> timelinePathNameMap) {
                this.timelinePathNameMap = timelinePathNameMap;
            }

            @Override
            public int compare(Timeline tl1, Timeline tl2) {
                String pn1 = this.timelinePathNameMap.get(tl1);
                String pn2 = this.timelinePathNameMap.get(tl2);
                if (pn1 == null && pn2 == null) {
                    return 0;
                }
                if (pn1 == null) {
                    return 1;
                }
                if (pn2 == null) {
                    return -1;
                }
                State state1 = TimelineState.this.stateMap.get(pn1);
                State state2 = TimelineState.this.stateMap.get(pn2);
                if (state1 == null && state2 == null) {
                    return 0;
                }
                if (state1 == null) {
                    return 1;
                }
                if (state2 == null) {
                    return -1;
                }
                return state1.index - state2.index;
            }
        }
    }
}

