/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionSerializable;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.Element;

public class RegionOfInterest
implements IModel,
ISessionSerializable {
    private int uid;
    private boolean selected;
    private long start;
    private long end;

    public RegionOfInterest(int uid, boolean selected, long start, long end) {
        this.uid = uid;
        this.selected = selected;
        this.start = start;
        this.end = end;
    }

    public RegionOfInterest(Element el) throws ViperException {
        this.read(el);
    }

    public int getUid() {
        return this.uid;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public long getDuration() {
        return Math.abs(this.end - this.start);
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            this.selected = selected;
        }
    }

    @Override
    public void write(Writer w) throws ViperException {
        try {
            w.write("<roi uid=\"" + this.uid + "\" selected=\"" + this.selected + "\" start=\"" + this.start + "\" end=\"" + this.end + "\"/>\n");
        }
        catch (IOException e) {
            throw new ViperException(e);
        }
    }

    protected void read(Element el) throws ViperException {
        if (!"roi".equals(el.getTagName())) {
            throw new ViperException("expected \"roi\" tag, got " + el.getTagName());
        }
        try {
            String uidStr = StringUtils.emptyToNull(el.getAttribute("uid"));
            String selStr = StringUtils.emptyToNull(el.getAttribute("selected"));
            String startStr = StringUtils.emptyToNull(el.getAttribute("start"));
            String endStr = StringUtils.emptyToNull(el.getAttribute("end"));
            if (uidStr != null && selStr != null && startStr != null && endStr != null) {
                this.uid = Integer.parseInt(uidStr);
                this.selected = Boolean.parseBoolean(selStr);
                this.start = Long.parseLong(startStr);
                this.end = Long.parseLong(endStr);
            }
        }
        catch (NumberFormatException e) {
            throw new ViperException("unable to parse region-of-interest", e);
        }
    }

    public String toString() {
        return "ROI " + this.uid + " [" + this.start + "," + this.end + "]" + (this.selected ? " sel" : "");
    }
}

