/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.jni.CuptiMetricCategory;
import com.nvidia.viper.model.Metric;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MetricCategory
implements Comparable<MetricCategory> {
    private CuptiMetricCategory category;
    private Set<Metric> metrics;
    private Set<Metric> aggregateMetrics;
    private Set<Metric> perInstanceMetrics;

    public MetricCategory(CuptiMetricCategory category) {
        this.category = category;
        this.metrics = new HashSet<Metric>();
        this.aggregateMetrics = new HashSet<Metric>();
        this.perInstanceMetrics = new HashSet<Metric>();
    }

    public String getDisplayName() {
        switch (this.category) {
            case CUPTI_METRIC_CATEGORY_MEMORY: {
                return "Memory";
            }
            case CUPTI_METRIC_CATEGORY_INSTRUCTION: {
                return "Instruction";
            }
            case CUPTI_METRIC_CATEGORY_MULTIPROCESSOR: {
                return "Multiprocessor";
            }
            case CUPTI_METRIC_CATEGORY_CACHE: {
                return "Cache";
            }
            case CUPTI_METRIC_CATEGORY_TEXTURE: {
                return "Texture";
            }
        }
        return "Misc";
    }

    public Set<Metric> getMetrics() {
        return Collections.unmodifiableSet(this.metrics);
    }

    public Set<Metric> getAggregateMetrics() {
        return Collections.unmodifiableSet(this.aggregateMetrics);
    }

    public Set<Metric> getPerInstanceMetrics() {
        return Collections.unmodifiableSet(this.perInstanceMetrics);
    }

    public void addMetric(Metric metric) {
        this.metrics.add(metric);
        if (metric.getEvaluationMode().isAggregateMode()) {
            this.aggregateMetrics.add(metric);
        }
        if (metric.getEvaluationMode().isPerInstanceMode()) {
            this.perInstanceMetrics.add(metric);
        }
    }

    public int hashCode() {
        return (this.category.hashCode() + 1) * 31;
    }

    public boolean equals(Object other) {
        if (!(other instanceof MetricCategory)) {
            return false;
        }
        return this.category.equals((Object)((MetricCategory)other).category);
    }

    @Override
    public int compareTo(MetricCategory other) {
        return this.category.compareTo(other.category);
    }
}

