/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.model.IProfilingData;
import com.nvidia.viper.model.Metric;

public class MetricAggregate
implements IProfilingData,
Comparable<MetricAggregate> {
    private final Metric metric;

    public MetricAggregate(Metric metric) {
        this.metric = metric;
        if (!metric.getEvaluationMode().isAggregateMode()) {
            ViperExceptionHandler.logError("expected aggregrate evaluation mode for metric " + metric.getName());
        }
    }

    public Metric getMetric() {
        return this.metric;
    }

    @Override
    public IProfilingData.Kind getProfileDataKind() {
        return IProfilingData.Kind.aggregate_metric;
    }

    @Override
    public String getName() {
        return this.metric.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetricAggregate) || this.metric == null) {
            return false;
        }
        return this.metric.equals(((MetricAggregate)obj).metric);
    }

    @Override
    public int compareTo(MetricAggregate other) {
        return this.metric.compareTo(other.metric);
    }

    public int hashCode() {
        return this.metric.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

