/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.fs;

import com.nvidia.viper.DeviceManager;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.model.Device;
import com.nvidia.viper.model.DeviceDescriptor;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.EventCategory;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.MetricCategory;
import java.util.Collection;

public final class LocalSystemDevicesData
implements IDevicesData {
    @Override
    public int[] getDeviceIds(String deviceType) {
        DeviceDescriptor descriptor = DeviceManager.getDeviceDescriptor(deviceType);
        Collection<Device> devices = DeviceManager.getDevices(descriptor);
        int[] ids = new int[devices.size()];
        int i = 0;
        for (Device device : devices) {
            ids[i++] = device.getNum();
        }
        return ids;
    }

    @Override
    public String[] getDeviceTypes() {
        Collection<DeviceDescriptor> descriptors = DeviceManager.getDeviceDescriptors();
        String[] types = new String[descriptors.size()];
        int i = 0;
        for (DeviceDescriptor deviceDescriptor : descriptors) {
            types[i++] = deviceDescriptor.getName();
        }
        return types;
    }

    @Override
    public Collection<EventCategory> getEventCategories(String deviceType) {
        DeviceDescriptor descriptor = DeviceManager.getDeviceDescriptor(deviceType);
        return descriptor != null ? descriptor.getEventCategories() : null;
    }

    @Override
    public Collection<Event> getEvents(String deviceType) {
        DeviceDescriptor descriptor = DeviceManager.getDeviceDescriptor(deviceType);
        return descriptor != null ? descriptor.getEvents() : null;
    }

    @Override
    public Metric getMetric(String deviceType, String metricName) {
        DeviceDescriptor descriptor = DeviceManager.getDeviceDescriptor(deviceType);
        return descriptor != null ? descriptor.getMetric(metricName) : null;
    }

    @Override
    public Collection<MetricCategory> getMetricCategories(String deviceType) {
        DeviceDescriptor descriptor = DeviceManager.getDeviceDescriptor(deviceType);
        return descriptor != null ? descriptor.getMetricCategories() : null;
    }

    @Override
    public Collection<Metric> getMetrics(String deviceType) {
        DeviceDescriptor descriptor = DeviceManager.getDeviceDescriptor(deviceType);
        return descriptor != null ? descriptor.getMetrics() : null;
    }
}

