/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.expertsystem;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultIntervalNoData;
import com.nvidia.viper.analysis.AnalysisResultKernelAchievedOccupancy;
import com.nvidia.viper.analysis.AnalysisResultKernelGridSize;
import com.nvidia.viper.analysis.AnalysisResultKernelOccupancy;
import com.nvidia.viper.analysis.AnalysisResultKernelStall;
import com.nvidia.viper.analysis.AnalysisResultOccupancyCharts;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.expertsystem.ExpertSystemStageKind;
import com.nvidia.viper.expertsystem.ExpertSystemStepAction;
import com.nvidia.viper.expertsystem.IExpertSystemStage;
import com.nvidia.viper.expertsystem.KernelInstanceStage;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.ITimelineInterval;

public class LatencyStage
extends KernelInstanceStage
implements IExpertSystemStage {
    public LatencyStage(ExpertSystem expertSystem) {
        super(expertSystem);
    }

    @Override
    public ExpertSystemStageKind getStageKind() {
        return ExpertSystemStageKind.LATENCY;
    }

    @Override
    public String getTitle(ResultOutput otpt) {
        return ViperMessages.ExpertSystem_Latency_Title;
    }

    public static ExpertSystemStepAction getAnalysisRunAction(boolean force) {
        return new ExpertSystemStepAction(new ExpertSystemStepAction(force, AnalysisStage.KERNEL_INSTANCE_LATENCY));
    }

    @Override
    public ExpertSystemStepAction update() {
        this.stageDesc = ViperMessages.ExpertSystem_Latency_Desc;
        this.numSteps = 0;
        this.stepTitles = null;
        this.stepDescs = null;
        this.stepActions = null;
        ExpertSystemStepAction updateAction = ExpertSystemStepAction.NONE;
        ITimelineInterval kernel = this.getSelectedInDepthKernel();
        AnalysisResultIntervalNoData failResult = this.getFailResult();
        AnalysisResultKernelStall stallResult = this.getStallResult();
        AnalysisResultKernelStall noStallResult = this.getNoStallResult();
        AnalysisResultKernelGridSize gridSizeResult = this.getGridSizeResult();
        AnalysisResultKernelAchievedOccupancy lowAchievedResult = this.getLowAchievedResult();
        AnalysisResultKernelOccupancy occupancyResult = this.getOccupancyResult();
        if (kernel == null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_DescNoKernel;
            updateAction = ExpertSystemStepAction.CLEAR_RESULTS;
        } else if (failResult != null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_DescFailResult;
            this.numSteps = 0;
            this.stepTitles = null;
            this.stepDescs = null;
            this.stepActions = null;
            updateAction = new ExpertSystemStepAction(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultIntervalNoData.class);
        } else if (gridSizeResult == null && lowAchievedResult == null && occupancyResult == null && (stallResult == null || noStallResult == null)) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_DescNoResult;
            this.numSteps = 1;
            this.stepTitles = new String[]{ViperMessages.ExpertSystem_StepNoResult_Title};
            this.stepDescs = new String[]{ViperMessages.ExpertSystem_StepNoResult_Desc};
            this.stepActions = new ExpertSystemStepAction[]{KernelInstanceStage.getAnalysisRunAction(false)};
            updateAction = ExpertSystemStepAction.CLEAR_RESULTS;
        } else if (gridSizeResult != null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_Latency_DescTooFewBlocks;
            this.numSteps = 3;
            this.stepTitles = new String[]{ViperMessages.ExpertSystem_Latency_ShowOccupancy_Title, ViperMessages.ExpertSystem_Latency_ShowStall_Title, ViperMessages.ExpertSystem_StepRerun_Title};
            this.stepDescs = new String[]{String.valueOf(ViperMessages.ExpertSystem_Latency_DescOccupancy) + " " + ViperMessages.ExpertSystem_Latency_ShowOccupancyTooFewBlocks_Desc, String.valueOf(ViperMessages.ExpertSystem_Latency_ShowStall_Desc) + " " + ViperMessages.ExpertSystem_Latency_ShowStallTooFewBlocks_Desc, ViperMessages.ExpertSystem_StepRerun_Desc};
            updateAction = new ExpertSystemStepAction(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelGridSize.class, AnalysisDescriptor.KERNEL_LATENCY_GRID_SIZE), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelOccupancy.class), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultOccupancyCharts.class));
            this.stepActions = new ExpertSystemStepAction[]{updateAction, new ExpertSystemStepAction(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelGridSize.class, AnalysisDescriptor.KERNEL_LATENCY_GRID_SIZE), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelStall.class)), KernelInstanceStage.getAnalysisRunAction(true)};
            updateAction = new ExpertSystemStepAction(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelGridSize.class, AnalysisDescriptor.KERNEL_LATENCY_GRID_SIZE);
        } else if (lowAchievedResult != null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_Latency_DescLowAchieved;
            this.numSteps = 3;
            this.stepTitles = new String[]{ViperMessages.ExpertSystem_Latency_ShowOccupancy_Title, ViperMessages.ExpertSystem_Latency_ShowStall_Title, ViperMessages.ExpertSystem_StepRerun_Title};
            this.stepDescs = new String[]{String.valueOf(ViperMessages.ExpertSystem_Latency_DescOccupancy) + " " + ViperMessages.ExpertSystem_Latency_ShowOccupancyLowAchieved_Desc, String.valueOf(ViperMessages.ExpertSystem_Latency_ShowStall_Desc) + " " + ViperMessages.ExpertSystem_Latency_ShowStallLowAchieved_Desc, ViperMessages.ExpertSystem_StepRerun_Desc};
            updateAction = new ExpertSystemStepAction(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelAchievedOccupancy.class, AnalysisDescriptor.KERNEL_LATENCY_BAD_ACHIEVED), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelOccupancy.class), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultOccupancyCharts.class));
            this.stepActions = new ExpertSystemStepAction[]{updateAction, new ExpertSystemStepAction(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelAchievedOccupancy.class, AnalysisDescriptor.KERNEL_LATENCY_BAD_ACHIEVED), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelStall.class)), KernelInstanceStage.getAnalysisRunAction(true)};
            updateAction = new ExpertSystemStepAction(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelAchievedOccupancy.class, AnalysisDescriptor.KERNEL_LATENCY_BAD_ACHIEVED);
        } else if (stallResult != null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_Latency_DescStall;
            this.numSteps = 2;
            this.stepTitles = new String[]{ViperMessages.ExpertSystem_Latency_ShowOccupancy_Title, ViperMessages.ExpertSystem_StepRerun_Title};
            this.stepDescs = new String[]{String.valueOf(ViperMessages.ExpertSystem_Latency_DescOccupancy) + " " + ViperMessages.ExpertSystem_Latency_ShowOccupancyStall_Desc, ViperMessages.ExpertSystem_StepRerun_Desc};
            this.stepActions = new ExpertSystemStepAction[]{new ExpertSystemStepAction(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelStall.class), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelOccupancy.class), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultOccupancyCharts.class)), KernelInstanceStage.getAnalysisRunAction(true)};
            updateAction = new ExpertSystemStepAction(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelStall.class, AnalysisDescriptor.KERNEL_LATENCY_STALL));
        } else if (occupancyResult != null) {
            this.stageDesc = String.valueOf(this.stageDesc) + " " + ViperMessages.ExpertSystem_Latency_DescOccupancyPerf + " " + ViperMessages.ExpertSystem_Latency_DescOccupancy + " " + this.getDescriptionForOccupancyResult(occupancyResult);
            this.numSteps = 2;
            this.stepTitles = new String[]{ViperMessages.ExpertSystem_Latency_ShowStall_Title, ViperMessages.ExpertSystem_StepRerun_Title};
            this.stepDescs = new String[]{String.valueOf(ViperMessages.ExpertSystem_Latency_ShowStall_Desc) + " " + ViperMessages.ExpertSystem_Latency_ShowStallOccupancy_Desc, ViperMessages.ExpertSystem_StepRerun_Desc};
            this.stepActions = new ExpertSystemStepAction[]{new ExpertSystemStepAction(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelStall.class), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelOccupancy.class), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultOccupancyCharts.class)), KernelInstanceStage.getAnalysisRunAction(true)};
            updateAction = new ExpertSystemStepAction(new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelOccupancy.class), new ExpertSystemStepAction.ShowResultsData(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultOccupancyCharts.class));
        }
        return updateAction;
    }

    private String getDescriptionForOccupancyResult(AnalysisResultKernelOccupancy occupancyResult) {
        switch (occupancyResult.getOccupancyCalculator().getLimiter()) {
            case BLOCK: {
                return ViperMessages.ExpertSystem_Latency_DescBlockSizeLimiter;
            }
            case REGISTER: {
                return ViperMessages.ExpertSystem_Latency_DescRegisterLimiter;
            }
            case SHARED_MEMORY: {
                return ViperMessages.ExpertSystem_Latency_DescSharedMemoryLimiter;
            }
        }
        return "";
    }

    private AnalysisResultIntervalNoData getFailResult() {
        return (AnalysisResultIntervalNoData)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultIntervalNoData.class);
    }

    private AnalysisResultKernelStall getStallResult() {
        AnalysisResultKernelStall res = (AnalysisResultKernelStall)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelStall.class);
        if (res != null && AnalysisDescriptor.KERNEL_LATENCY_STALL.equals((Object)res.getDescriptor())) {
            return res;
        }
        return null;
    }

    private AnalysisResultKernelStall getNoStallResult() {
        AnalysisResultKernelStall res = (AnalysisResultKernelStall)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelStall.class);
        if (res != null && AnalysisDescriptor.KERNEL_LATENCY_NOSTALL.equals((Object)res.getDescriptor())) {
            return res;
        }
        return null;
    }

    private AnalysisResultKernelGridSize getGridSizeResult() {
        return (AnalysisResultKernelGridSize)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelGridSize.class);
    }

    private AnalysisResultKernelAchievedOccupancy getLowAchievedResult() {
        return (AnalysisResultKernelAchievedOccupancy)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelAchievedOccupancy.class, AnalysisDescriptor.KERNEL_LATENCY_BAD_ACHIEVED);
    }

    private AnalysisResultKernelOccupancy getOccupancyResult() {
        return (AnalysisResultKernelOccupancy)this.getKernelResult(AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisResultKernelOccupancy.class);
    }
}

