/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultGPUCompute;
import com.nvidia.viper.analysis.AnalysisResultIntervalNoData;
import com.nvidia.viper.analysis.AnalysisResultKernelUtilization;
import com.nvidia.viper.analysis.AnalysisResultOccupancy;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.AnalysisTimeData;
import com.nvidia.viper.analysis.TimeRanges;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineIntervalMemset;
import com.nvidia.viper.model.TimelineIntervalUtilization;
import com.nvidia.viper.model.TimelineKernel;
import com.nvidia.viper.model.TimelineKind;
import com.nvidia.viper.model.UtilizationRange;
import com.nvidia.viper.model.UtilizationRanges;
import java.util.List;

public class MultiprocessorAnalysis
extends AnalysisBase {
    private static final double BAD_COMPUTE_USAGE = 0.5;
    public static final double GOOD_OCCUPANCY = 0.5;
    public static final double GREAT_OCCUPANCY = 0.8;
    private static final double UTILIZATION_MEMSET = 0.1;

    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = true;
        if (session.getTimelines().isEmpty()) {
            results.add(new AnalysisResult(AnalysisDescriptor.KERNELS_NO_TIMELINE));
            ret = false;
        } else {
            List<Timeline> deviceTimelines = session.getTimelines(TimelineKind.DEVICE);
            if (deviceTimelines.isEmpty()) {
                results.add(new AnalysisResult(AnalysisDescriptor.KERNELS_NO_DEVICE));
            } else {
                if (generateAllResults) {
                    results.add(new AnalysisResult(AnalysisDescriptor.KERNELS_NO_TIMELINE));
                    results.add(new AnalysisResult(AnalysisDescriptor.KERNELS_NO_DEVICE));
                }
                boolean retNoCompute = this.runNoComputeAnalysis(session, results, deviceTimelines, generateAllResults);
                boolean retOcc = this.runOccupancyAnalysis(session, results, deviceTimelines, generateAllResults);
                boolean retUtil = this.runUtilizationAnalysis(results, deviceTimelines, generateAllResults);
                ret = ret && retNoCompute && retOcc && retUtil;
            }
        }
        return ret;
    }

    protected boolean runNoComputeAnalysis(Session session, List<AnalysisResult> results, List<Timeline> deviceTimelines, boolean generateAllResults) {
        AnalysisResultGPUCompute badCompute = new AnalysisResultGPUCompute(AnalysisDescriptor.KERNELS_UTILIZATION_BAD);
        for (Timeline deviceTimeline : deviceTimelines) {
            TimeRanges kernelRanges = new TimeRanges();
            List<Timeline> kernelsTimelines = deviceTimeline.getDescendants(TimelineKind.KERNELS);
            for (Timeline timeline : kernelsTimelines) {
                kernelRanges.union(new TimeRanges(timeline));
            }
            long totalTime = session.getDuration();
            long totalComputeTime = kernelRanges.getTotalTime();
            double util = (double)totalComputeTime / (double)totalTime;
            if (!(util <= 0.5)) continue;
            badCompute.addTimeline(deviceTimeline, new AnalysisTimeData(totalComputeTime, totalTime));
        }
        if (badCompute.getTimelineCount() > 0 || generateAllResults) {
            results.add(badCompute);
        }
        return true;
    }

    public boolean runUtilizationAnalysis(List<AnalysisResult> results, List<Timeline> deviceTimelines, boolean generateAllResults) {
        boolean ret = true;
        AnalysisResultKernelUtilization kernelUtil = new AnalysisResultKernelUtilization(AnalysisDescriptor.KERNELS_UTILIZATION);
        block2: for (Timeline deviceTimeline : deviceTimelines) {
            deviceTimeline.removeIntervals(TimelineIntervalKind.GPU_UTILIZATION);
            if (((TimelineDevice)deviceTimeline).getComputeCapabilityMajor() <= 1) continue;
            Metric occupancyMetric = null;
            for (Timeline timeline : deviceTimeline.getDescendants(TimelineKind.KERNELS)) {
                for (ITimelineInterval iTimelineInterval : timeline.getIntervals()) {
                    TimelineIntervalKernel kernel = AnalysisStage.getHostLaunchedKernel(iTimelineInterval);
                    if (kernel == null) continue;
                    if (occupancyMetric == null) {
                        occupancyMetric = this.getMetric(kernel, "achieved_occupancy");
                    }
                    Number occupancyNumber = null;
                    if (occupancyMetric != null && (occupancyNumber = kernel.getAggregateMetricValue(occupancyMetric)) == null) {
                        occupancyNumber = this.deriveAggregateMetricValue(kernel, occupancyMetric, true);
                    }
                    if (occupancyNumber != null) continue;
                    ret = false;
                    continue block2;
                }
            }
            UtilizationRanges ranges = new UtilizationRanges();
            for (Timeline timeline : deviceTimeline.getDescendants(TimelineKind.KERNELS)) {
                for (ITimelineInterval iTimelineInterval3 : timeline.getIntervals()) {
                    double utilization = 0.0;
                    TimelineIntervalKernel kernel = AnalysisStage.getHostLaunchedKernel(iTimelineInterval3);
                    if (kernel != null) {
                        Number occupancyNumber;
                        Number number = occupancyNumber = occupancyMetric == null ? (Number)null : (Number)kernel.getAggregateMetricValue(occupancyMetric);
                        if (occupancyNumber != null) {
                            utilization = occupancyNumber.doubleValue();
                        }
                    } else if (iTimelineInterval3 instanceof TimelineIntervalMemset) {
                        utilization = 0.1;
                    }
                    if (!(utilization > 0.0)) continue;
                    try {
                        ranges.addRange(new UtilizationRange(iTimelineInterval3.getStart(), iTimelineInterval3.getEnd(), utilization));
                    }
                    catch (Exception e) {
                        ViperExceptionHandler.logError(e.getMessage());
                    }
                }
            }
            List<UtilizationRange> rangeList = ranges.getUtilizationRanges();
            for (UtilizationRange utilizationRange : rangeList) {
                TimelineIntervalUtilization interval = new TimelineIntervalUtilization(utilizationRange);
                deviceTimeline.addInterval(interval);
                interval.setPrimaryTimeline(deviceTimeline);
            }
            deviceTimeline.updateDurations();
            kernelUtil.addTimeline(deviceTimeline, 0);
        }
        if (kernelUtil.getTimelineCount() > 0) {
            results.add(kernelUtil);
        }
        return ret;
    }

    protected boolean runOccupancyAnalysis(Session session, List<AnalysisResult> results, List<Timeline> deviceTimelines, boolean generateAllResults) {
        boolean ret = true;
        AnalysisResultOccupancy goodOccupancy = new AnalysisResultOccupancy(session, AnalysisDescriptor.KERNELS_OCCUPANCY_GOOD);
        AnalysisResultOccupancy badOccupancy = new AnalysisResultOccupancy(session, AnalysisDescriptor.KERNELS_OCCUPANCY_BAD);
        AnalysisResultIntervalNoData noDataOccupancy = new AnalysisResultIntervalNoData(session, AnalysisDescriptor.KERNELS_OCCUPANCY_NO_DATA);
        long totalKernelTime = 0L;
        for (Timeline deviceTimeline : deviceTimelines) {
            if (((TimelineDevice)deviceTimeline).getComputeCapabilityMajor() <= 1) continue;
            Metric occupancyMetric = null;
            List<Timeline> kernelTimelines = deviceTimeline.getDescendants(TimelineKind.KERNEL);
            for (Timeline timeline : kernelTimelines) {
                TimelineKernel kernelTimeline = (TimelineKernel)timeline;
                for (ITimelineInterval interval : kernelTimeline.getIntervals()) {
                    TimelineIntervalKernel kernel = AnalysisStage.getHostLaunchedKernel(interval);
                    if (kernel == null) continue;
                    totalKernelTime += kernel.getDuration();
                    if (occupancyMetric == null) {
                        occupancyMetric = this.getMetric(kernel, "achieved_occupancy");
                    }
                    Number occupancyNumber = null;
                    if (occupancyMetric != null && (occupancyNumber = kernel.getAggregateMetricValue(occupancyMetric)) == null) {
                        occupancyNumber = this.deriveAggregateMetricValue(kernel, occupancyMetric, true);
                    }
                    if (occupancyNumber == null) {
                        noDataOccupancy.addInterval(kernel, null);
                        ret = false;
                        continue;
                    }
                    double occupancy = occupancyNumber.doubleValue();
                    if (occupancy >= 0.5) {
                        goodOccupancy.addInterval(kernel, occupancy);
                        continue;
                    }
                    badOccupancy.addInterval(kernel, occupancy);
                }
            }
        }
        badOccupancy.setTotalKernelTime(totalKernelTime);
        goodOccupancy.setTotalKernelTime(totalKernelTime);
        if (noDataOccupancy.getIntervalCount() > 0 || generateAllResults) {
            results.add(noDataOccupancy);
        }
        if (badOccupancy.getIntervalCount() > 0 || generateAllResults) {
            results.add(badOccupancy);
        }
        if (goodOccupancy.getIntervalCount() > 0 || generateAllResults) {
            results.add(goodOccupancy);
        }
        return ret;
    }
}

