/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultMemcpyOverlap;
import com.nvidia.viper.analysis.AnalysisResultMemcpySize;
import com.nvidia.viper.analysis.AnalysisResultMemcpyThroughput;
import com.nvidia.viper.analysis.AnalysisTimeData;
import com.nvidia.viper.analysis.TimeRanges;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalMemcpy;
import com.nvidia.viper.model.TimelineKind;
import java.util.Arrays;
import java.util.List;

public class MemcpyAnalysis
extends AnalysisBase {
    private static final long BAD_MEMCPY_SIZE = 8192L;
    private static final double MEMCPY_SIZE_THRESHOLD = 0.3;
    private static final long BAD_MEMCPY_THROUGHPUT = 3000000000L;
    private static final double BAD_OVERLAP = 0.1;

    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = true;
        if (session.getTimelines().isEmpty()) {
            results.add(new AnalysisResult(AnalysisDescriptor.MEMCPY_NO_TIMELINE));
            ret = false;
        } else {
            List<Timeline> deviceTimelines = session.getTimelines(TimelineKind.DEVICE);
            if (deviceTimelines.isEmpty()) {
                results.add(new AnalysisResult(AnalysisDescriptor.MEMCPY_NO_DEVICE));
            } else {
                if (generateAllResults) {
                    results.add(new AnalysisResult(AnalysisDescriptor.MEMCPY_NO_TIMELINE));
                    results.add(new AnalysisResult(AnalysisDescriptor.MEMCPY_NO_DEVICE));
                }
                this.runSizeAnalysis(session, results, deviceTimelines, generateAllResults);
                this.runThroughputAnalysis(session, results, deviceTimelines, generateAllResults);
                this.runOverlapAnalysis(session, results, deviceTimelines, generateAllResults);
            }
        }
        return ret;
    }

    protected void runSizeAnalysis(Session session, List<AnalysisResult> results, List<Timeline> deviceTimelines, boolean generateAllResults) {
        AnalysisResultMemcpySize badSize = new AnalysisResultMemcpySize(session, AnalysisDescriptor.MEMCPY_SIZE_BAD);
        for (Timeline deviceTimeline : deviceTimelines) {
            TimelineIntervalMemcpy memcpy;
            List<Timeline> memcpyTimelines = deviceTimeline.getDescendants(Arrays.asList(TimelineKind.MEMCPY_DTOH, TimelineKind.MEMCPY_HTOD, TimelineKind.MEMCPY_DTOD, TimelineKind.MEMCPY_PTOP));
            int tooSmallCnt = 0;
            long tooSmall = 0L;
            long justRight = 0L;
            for (Timeline timeline : memcpyTimelines) {
                for (ITimelineInterval interval : timeline.getIntervals()) {
                    if (!(interval instanceof TimelineIntervalMemcpy)) continue;
                    memcpy = (TimelineIntervalMemcpy)interval;
                    if (memcpy.getBytes() <= 8192L) {
                        ++tooSmallCnt;
                        tooSmall += memcpy.getDuration();
                        continue;
                    }
                    justRight += memcpy.getDuration();
                }
            }
            if (tooSmallCnt <= true || !((double)tooSmall / (double)(tooSmall + justRight) > 0.3)) continue;
            for (Timeline timeline : memcpyTimelines) {
                for (ITimelineInterval interval : timeline.getIntervals()) {
                    long size;
                    if (!(interval instanceof TimelineIntervalMemcpy) || (size = (memcpy = (TimelineIntervalMemcpy)interval).getBytes()) > 8192L) continue;
                    badSize.addInterval(memcpy, size);
                }
            }
        }
        if (badSize.getIntervalCount() > 0 || generateAllResults) {
            results.add(badSize);
        }
    }

    protected void runOverlapAnalysis(Session session, List<AnalysisResult> results, List<Timeline> deviceTimelines, boolean generateAllResults) {
        AnalysisResultMemcpyOverlap badOverlap = new AnalysisResultMemcpyOverlap(AnalysisDescriptor.MEMCPY_OVERLAP_BAD);
        for (Timeline deviceTimeline : deviceTimelines) {
            long overlapTime;
            double overlap;
            if (((TimelineDevice)deviceTimeline).getNumMemcpyEngines() <= 1) continue;
            TimeRanges dtohRanges = new TimeRanges();
            List<Timeline> dtohTimelines = deviceTimeline.getDescendants(TimelineKind.MEMCPY_DTOH);
            for (Timeline timeline : dtohTimelines) {
                dtohRanges.union(new TimeRanges(timeline));
            }
            long dtohTotalTime = dtohRanges.getTotalTime();
            TimeRanges htodRanges = new TimeRanges();
            List<Timeline> htodTimelines = deviceTimeline.getDescendants(TimelineKind.MEMCPY_HTOD);
            for (Timeline timeline : htodTimelines) {
                htodRanges.union(new TimeRanges(timeline));
            }
            long htodTotalTime = htodRanges.getTotalTime();
            TimeRanges overlapRanges = dtohRanges;
            overlapRanges.intersect(htodRanges);
            long totalTime = Math.min(htodTotalTime, dtohTotalTime);
            if (totalTime <= 0L || !((overlap = (double)(overlapTime = overlapRanges.getTotalTime()) / (double)totalTime) <= 0.1)) continue;
            badOverlap.addTimeline(deviceTimeline, new AnalysisTimeData(overlapTime, totalTime));
        }
        if (badOverlap.getTimelineCount() > 0 || generateAllResults) {
            results.add(badOverlap);
        }
    }

    protected void runThroughputAnalysis(Session session, List<AnalysisResult> results, List<Timeline> deviceTimelines, boolean generateAllResults) {
        AnalysisResultMemcpyThroughput badThroughput = new AnalysisResultMemcpyThroughput(session, AnalysisDescriptor.MEMCPY_THROUGHPUT_BAD);
        long totalMemcpyTime = 0L;
        for (Timeline deviceTimeline : deviceTimelines) {
            List<Timeline> memcpyTimelines = deviceTimeline.getDescendants(Arrays.asList(TimelineKind.MEMCPY_DTOH, TimelineKind.MEMCPY_HTOD, TimelineKind.MEMCPY_DTOD, TimelineKind.MEMCPY_PTOP));
            for (Timeline timeline : memcpyTimelines) {
                for (ITimelineInterval interval : timeline.getIntervals()) {
                    if (!(interval instanceof TimelineIntervalMemcpy)) continue;
                    TimelineIntervalMemcpy memcpy = (TimelineIntervalMemcpy)interval;
                    totalMemcpyTime += memcpy.getDuration();
                    long throughput = memcpy.getThroughput();
                    if (throughput > 3000000000L) continue;
                    badThroughput.addInterval(memcpy, throughput);
                }
            }
        }
        badThroughput.setTotalMemcpyTime(totalMemcpyTime);
        if (badThroughput.getIntervalCount() > 0 || generateAllResults) {
            results.add(badThroughput);
        }
    }
}

