/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityGlobalAccess;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultUncoalescedGlobalMemory;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import java.util.List;

public class KernelInstanceUncoalescedGlobalMemoryAnalysis
extends AnalysisBase {
    private static final double BAD_COALESCE_UNCACHE_1 = 1.1;
    private static final double BAD_COALESCE_UNCACHE_2 = 2.1;
    private static final double BAD_COALESCE_CACHE_1 = 4.1;
    private static final double BAD_COALESCE_CACHE_2 = 4.1;
    private static final double BAD_COALESCE_4 = 4.1;
    private static final double BAD_COALESCE_8 = 8.1;
    private static final double BAD_COALESCE_16 = 16.1;

    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = false;
        Analysis analysis = session.getAnalysis();
        if (analysis != null) {
            TimelineIntervalKernel interval = AnalysisStage.getHostLaunchedKernel(analysis.getActiveScopeInterval());
            if (interval == null || generateAllResults) {
                results.add(new AnalysisResult(AnalysisDescriptor.SL_GLOBALMEMORYUNCOALESCED_NO_KERNEL));
            }
            if (interval instanceof TimelineIntervalKernel) {
                TimelineIntervalKernel kernel = interval;
                int totalResults = 0;
                int droppedResults = 0;
                AnalysisResultUncoalescedGlobalMemory gma = new AnalysisResultUncoalescedGlobalMemory(session, kernel, AnalysisDescriptor.SL_GLOBALMEMORY_UNCOALESCED);
                for (ICuptiActivitySourceLevelResult result : kernel.getSourceLevelResults()) {
                    if (!(result instanceof CuptiActivityGlobalAccess)) continue;
                    ++totalResults;
                    ret = true;
                    if (!this.isUncoalesced((CuptiActivityGlobalAccess)result) || gma.addResult(result)) continue;
                    ++droppedResults;
                }
                if (gma.getSourceLevelResultCount() > 0 || generateAllResults) {
                    results.add(gma);
                }
                if (droppedResults > 0 || generateAllResults) {
                    results.add(new AnalysisResult(AnalysisDescriptor.SL_GLOBALMEMORYUNCOALESCED_NO_SOURCE));
                }
                if (totalResults <= 0 || generateAllResults) {
                    results.add(new AnalysisResult(AnalysisDescriptor.SL_GLOBALMEMORYUNCOALESCED_NO_DATA));
                }
            }
        }
        return ret;
    }

    private boolean isUncoalesced(CuptiActivityGlobalAccess ga) {
        if (!ga.isNullResult()) {
            if (ga.theoreticalL2Transactions == 0L) {
                int accessSize = ga.flags & CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_SIZE_MASK.getCode();
                boolean isCached = (ga.flags & CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_CACHED.getCode()) != 0;
                double badCoalesce = this.getBadCoalesce(accessSize, isCached);
                if (ga.executed == 0) {
                    return false;
                }
                if ((double)ga.l2_transactions / (double)ga.executed >= badCoalesce) {
                    return true;
                }
            } else if (ga.l2_transactions > ga.theoreticalL2Transactions) {
                return true;
            }
        }
        return false;
    }

    private double getBadCoalesce(int accessSize, boolean isCached) {
        switch (accessSize) {
            case 1: {
                return isCached ? 4.1 : 1.1;
            }
            case 2: {
                return isCached ? 4.1 : 2.1;
            }
            case 4: {
                return 4.1;
            }
            case 8: {
                return 8.1;
            }
            case 16: {
                return 16.1;
            }
        }
        return 4.1;
    }
}

