/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityGlobalAccess;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.analysis.SourceLevelResultGraphicFactory;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.text.NumberFormat;
import org.eclipse.jface.action.Action;

public class AnalysisResultUncoalescedGlobalMemory
extends AnalysisResultSourceLevel {
    private static NumberFormat numberFormatter = NumberFormat.getNumberInstance();

    static {
        numberFormatter.setMaximumFractionDigits(1);
        numberFormatter.setGroupingUsed(false);
    }

    public AnalysisResultUncoalescedGlobalMemory(Session session, TimelineIntervalKernel kernel, AnalysisDescriptor desc) {
        super(session, kernel, desc);
    }

    public TimelineIntervalKernel getKernel() {
        return (TimelineIntervalKernel)this.getInterval();
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new SourceLevelResultGraphicFactory();
    }

    @Override
    public String getResultDescription(ICuptiActivitySourceLevelResult result) {
        if (result instanceof CuptiActivityGlobalAccess) {
            CuptiActivityGlobalAccess ga = (CuptiActivityGlobalAccess)result;
            if (ga.executed != 0) {
                double trans = (double)ga.l2_transactions / (double)ga.executed;
                String lsStr = CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_LOAD.isSet(((CuptiActivityGlobalAccess)result).flags) ? "Global Load" : "Global Store";
                lsStr = lsStr.concat(" L2 Transactions/Access = " + numberFormatter.format(trans));
                if (ga.theoreticalL2Transactions != 0L) {
                    double idealTrans = (double)ga.theoreticalL2Transactions / (double)ga.executed;
                    lsStr = lsStr.concat(", Ideal Transactions/Access = " + numberFormatter.format(idealTrans));
                }
                lsStr = lsStr.concat(" [ " + ga.l2_transactions + " L2 transactions for " + ga.executed + " total executions ]");
                return lsStr;
            }
        }
        return super.getResultDescription(result);
    }

    @Override
    public boolean addResult(ICuptiActivitySourceLevelResult slr) {
        if (super.addResult(slr)) {
            this.addMarkers(slr);
            return true;
        }
        return false;
    }

    @Override
    public Action getMoreAction() {
        return new MoreAction();
    }

    private class MoreAction
    extends Action {
        private MoreAction() {
        }

        public void run() {
            ViperHelp.displayHelp(ViperHelp.GLOBAL_MEMORY_COALESCED);
        }
    }
}

