/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.KernelFlopsGraphicFactory;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AnalysisResultKernelFlops
extends AnalysisResult {
    private final TimelineIntervalKernel kernel;
    private final Map<FlopsKind, Long> flopsKindExecCount;
    private final long totalExecCount;

    public AnalysisResultKernelFlops(TimelineIntervalKernel kernel, long execCount) {
        super(AnalysisDescriptor.KERNEL_COMPUTE_FLOPS);
        this.kernel = kernel;
        this.totalExecCount = execCount;
        this.flopsKindExecCount = new HashMap<FlopsKind, Long>();
    }

    public TimelineIntervalKernel getKernel() {
        return this.kernel;
    }

    public long getTotalExecCount() {
        return this.totalExecCount;
    }

    public List<FlopsKind> getFlopsKinds() {
        LinkedList<FlopsKind> ics = new LinkedList<FlopsKind>();
        FlopsKind[] flopsKindArray = FlopsKind.values();
        int n = flopsKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            FlopsKind ic = flopsKindArray[n2];
            if (this.flopsKindExecCount.containsKey((Object)ic)) {
                ics.add(ic);
            }
            ++n2;
        }
        return ics;
    }

    public Long getExecCount(FlopsKind kind) {
        return this.flopsKindExecCount.get((Object)kind);
    }

    public void setExecCount(FlopsKind kind, long execCount) {
        this.flopsKindExecCount.put(kind, execCount);
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(1);
        TimelineIntervalPair pair = new TimelineIntervalPair(this.kernel.getPrimaryTimeline(), this.kernel);
        pairs.add(pair);
        return pairs;
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new KernelFlopsGraphicFactory();
    }

    public static enum FlopsKind {
        FP32ADD("FP32 Add", "flops_sp_add"),
        FP32MUL("FP32 Mul", "flops_sp_mul"),
        FP32FMA("FP32 Mul-Add", "flops_sp_fma"),
        FP32SPEC("FP Special", "flops_sp_special"),
        FP64ADD("FP64 Add", "flops_dp_add"),
        FP64MUL("FP64 Mul", "flops_dp_mul"),
        FP64FMA("FP64 Mul-Add", "flops_dp_fma");

        private final String name;
        private final String metricName;

        private FlopsKind(String name, String metricName) {
            this.name = name;
            this.metricName = metricName;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String toString() {
            return this.name;
        }

        public String getLegendName() {
            return "(" + this.name + ")";
        }
    }
}

